/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum HeaderEnum {
    ACCEPT("Accept"),

    ACCEPT_CHARSET("Accept-Charset"),

    ACCEPT_DATETIME("Accept-Datetime"),

    ACCEPT_ENCODING("Accept-Encoding"),

    ACCEPT_LANGUAGE("Accept-Language"),

    AUTHORIZATION("Authorization"),

    CLOUD_FRONT_FORWARDED_PROTO("CloudFront-Forwarded-Proto"),

    CLOUD_FRONT_IS_DESKTOP_VIEWER("CloudFront-Is-Desktop-Viewer"),

    CLOUD_FRONT_IS_MOBILE_VIEWER("CloudFront-Is-Mobile-Viewer"),

    CLOUD_FRONT_IS_SMART_TV_VIEWER("CloudFront-Is-SmartTV-Viewer"),

    CLOUD_FRONT_IS_TABLET_VIEWER("CloudFront-Is-Tablet-Viewer"),

    CLOUD_FRONT_VIEWER_COUNTRY("CloudFront-Viewer-Country"),

    HOST("Host"),

    ORIGIN("Origin"),

    REFERER("Referer"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HeaderEnum(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HeaderEnum corresponding to the value
     */
    public static HeaderEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HeaderEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HeaderEnum}s
     */
    public static Set<HeaderEnum> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
