/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ContainerServiceDeploymentListCopier {
    static List<ContainerServiceDeployment> copy(Collection<ContainerServiceDeployment> containerServiceDeploymentListParam) {
        if (containerServiceDeploymentListParam == null || containerServiceDeploymentListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<ContainerServiceDeployment> containerServiceDeploymentListParamCopy = new ArrayList<>(
                containerServiceDeploymentListParam);
        return Collections.unmodifiableList(containerServiceDeploymentListParamCopy);
    }

    static List<ContainerServiceDeployment> copyFromBuilder(
            Collection<? extends ContainerServiceDeployment.Builder> containerServiceDeploymentListParam) {
        if (containerServiceDeploymentListParam == null
                || containerServiceDeploymentListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(containerServiceDeploymentListParam.stream().map(ContainerServiceDeployment.Builder::build).collect(toList()));
    }
}
