/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFormationStackRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateCloudFormationStackRequest.Builder, CreateCloudFormationStackRequest> {
    private static final SdkField<List<InstanceEntry>> INSTANCES_FIELD = SdkField
            .<List<InstanceEntry>> builder(MarshallingType.LIST)
            .memberName("instances")
            .getter(getter(CreateCloudFormationStackRequest::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD));

    private final List<InstanceEntry> instances;

    private CreateCloudFormationStackRequest(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one instance
     * entry at a time in this array. You will get an invalid parameter error if you pass more than one instance entry
     * in this array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
     *         instance entry at a time in this array. You will get an invalid parameter error if you pass more than one
     *         instance entry in this array.
     */
    public final List<InstanceEntry> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationStackRequest)) {
            return false;
        }
        CreateCloudFormationStackRequest other = (CreateCloudFormationStackRequest) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudFormationStackRequest").add("Instances", hasInstances() ? instances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationStackRequest, T> g) {
        return obj -> g.apply((CreateCloudFormationStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCloudFormationStackRequest> {
        /**
         * <p>
         * An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
         * instance entry at a time in this array. You will get an invalid parameter error if you pass more than one
         * instance entry in this array.
         * </p>
         * 
         * @param instances
         *        An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
         *        instance entry at a time in this array. You will get an invalid parameter error if you pass more than
         *        one instance entry in this array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<InstanceEntry> instances);

        /**
         * <p>
         * An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
         * instance entry at a time in this array. You will get an invalid parameter error if you pass more than one
         * instance entry in this array.
         * </p>
         * 
         * @param instances
         *        An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
         *        instance entry at a time in this array. You will get an invalid parameter error if you pass more than
         *        one instance entry in this array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(InstanceEntry... instances);

        /**
         * <p>
         * An array of parameters that will be used to create the new Amazon EC2 instance. You can only pass one
         * instance entry at a time in this array. You will get an invalid parameter error if you pass more than one
         * instance entry in this array.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceEntry>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #instances(List<InstanceEntry>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<InstanceEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<InstanceEntry>)
         */
        Builder instances(Consumer<InstanceEntry.Builder>... instances);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<InstanceEntry> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationStackRequest model) {
            super(model);
            instances(model.instances);
        }

        public final List<InstanceEntry.Builder> getInstances() {
            List<InstanceEntry.Builder> result = InstanceEntryListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instances(Collection<InstanceEntry> instances) {
            this.instances = InstanceEntryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(InstanceEntry... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<InstanceEntry.Builder>... instances) {
            instances(Stream.of(instances).map(c -> InstanceEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<InstanceEntry.BuilderImpl> instances) {
            this.instances = InstanceEntryListCopier.copyFromBuilder(instances);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFormationStackRequest build() {
            return new CreateCloudFormationStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
