/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CopySnapshotRequest.Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSnapshotName").getter(getter(CopySnapshotRequest::sourceSnapshotName))
            .setter(setter(Builder::sourceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build())
            .build();

    private static final SdkField<String> SOURCE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceResourceName").getter(getter(CopySnapshotRequest::sourceResourceName))
            .setter(setter(Builder::sourceResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceResourceName").build())
            .build();

    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restoreDate").getter(getter(CopySnapshotRequest::restoreDate)).setter(setter(Builder::restoreDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useLatestRestorableAutoSnapshot")
            .getter(getter(CopySnapshotRequest::useLatestRestorableAutoSnapshot))
            .setter(setter(Builder::useLatestRestorableAutoSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot")
                    .build()).build();

    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSnapshotName").getter(getter(CopySnapshotRequest::targetSnapshotName))
            .setter(setter(Builder::targetSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(CopySnapshotRequest::sourceRegionAsString))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD,
            SOURCE_RESOURCE_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD,
            TARGET_SNAPSHOT_NAME_FIELD, SOURCE_REGION_FIELD));

    private final String sourceSnapshotName;

    private final String sourceResourceName;

    private final String restoreDate;

    private final Boolean useLatestRestorableAutoSnapshot;

    private final String targetSnapshotName;

    private final String sourceRegion;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.sourceResourceName = builder.sourceResourceName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * <p>
     * The name of the source manual snapshot to copy.
     * </p>
     * <p>
     * Constraint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Define this parameter only when copying a manual snapshot as another manual snapshot.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the source manual snapshot to copy.</p>
     *         <p>
     *         Constraint:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Define this parameter only when copying a manual snapshot as another manual snapshot.
     *         </p>
     *         </li>
     */
    public final String sourceSnapshotName() {
        return sourceSnapshotName;
    }

    /**
     * <p>
     * The name of the source instance or disk from which the source automatic snapshot was created.
     * </p>
     * <p>
     * Constraint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the source instance or disk from which the source automatic snapshot was created.</p>
     *         <p>
     *         Constraint:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public final String sourceResourceName() {
        return sourceResourceName;
    }

    /**
     * <p>
     * The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation to identify
     * the dates of the available automatic snapshots.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be specified in <code>YYYY-MM-DD</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter.
     * The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually
     * exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation to
     *         identify the dates of the available automatic snapshots.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be specified in <code>YYYY-MM-DD</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
     *         parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters
     *         are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public final String restoreDate() {
        return restoreDate;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source
     * instance or disk.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>restore date</code> parameter. The
     * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see the
     * <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots">
     * Lightsail Dev Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A Boolean value to indicate whether to use the latest available automatic snapshot of the specified
     *         source instance or disk.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>restore date</code> parameter. The
     *         <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information,
     *         see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
     *         >Lightsail Dev Guide</a>.
     *         </p>
     *         </li>
     */
    public final Boolean useLatestRestorableAutoSnapshot() {
        return useLatestRestorableAutoSnapshot;
    }

    /**
     * <p>
     * The name of the new manual snapshot to be created as a copy.
     * </p>
     * 
     * @return The name of the new manual snapshot to be created as a copy.
     */
    public final String targetSnapshotName() {
        return targetSnapshotName;
    }

    /**
     * <p>
     * The AWS Region where the source manual or automatic snapshot is located.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRegion} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceRegionAsString}.
     * </p>
     * 
     * @return The AWS Region where the source manual or automatic snapshot is located.
     * @see RegionName
     */
    public final RegionName sourceRegion() {
        return RegionName.fromValue(sourceRegion);
    }

    /**
     * <p>
     * The AWS Region where the source manual or automatic snapshot is located.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRegion} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceRegionAsString}.
     * </p>
     * 
     * @return The AWS Region where the source manual or automatic snapshot is located.
     * @see RegionName
     */
    public final String sourceRegionAsString() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableAutoSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest) obj;
        return Objects.equals(sourceSnapshotName(), other.sourceSnapshotName())
                && Objects.equals(sourceResourceName(), other.sourceResourceName())
                && Objects.equals(restoreDate(), other.restoreDate())
                && Objects.equals(useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot())
                && Objects.equals(targetSnapshotName(), other.targetSnapshotName())
                && Objects.equals(sourceRegionAsString(), other.sourceRegionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopySnapshotRequest").add("SourceSnapshotName", sourceSnapshotName())
                .add("SourceResourceName", sourceResourceName()).add("RestoreDate", restoreDate())
                .add("UseLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshot())
                .add("TargetSnapshotName", targetSnapshotName()).add("SourceRegion", sourceRegionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceSnapshotName":
            return Optional.ofNullable(clazz.cast(sourceSnapshotName()));
        case "sourceResourceName":
            return Optional.ofNullable(clazz.cast(sourceResourceName()));
        case "restoreDate":
            return Optional.ofNullable(clazz.cast(restoreDate()));
        case "useLatestRestorableAutoSnapshot":
            return Optional.ofNullable(clazz.cast(useLatestRestorableAutoSnapshot()));
        case "targetSnapshotName":
            return Optional.ofNullable(clazz.cast(targetSnapshotName()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopySnapshotRequest> {
        /**
         * <p>
         * The name of the source manual snapshot to copy.
         * </p>
         * <p>
         * Constraint:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Define this parameter only when copying a manual snapshot as another manual snapshot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceSnapshotName
         *        The name of the source manual snapshot to copy.</p>
         *        <p>
         *        Constraint:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Define this parameter only when copying a manual snapshot as another manual snapshot.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotName(String sourceSnapshotName);

        /**
         * <p>
         * The name of the source instance or disk from which the source automatic snapshot was created.
         * </p>
         * <p>
         * Constraint:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see
         * the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceResourceName
         *        The name of the source instance or disk from which the source automatic snapshot was created.</p>
         *        <p>
         *        Constraint:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Define this parameter only when copying an automatic snapshot as a manual snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceName(String sourceResourceName);

        /**
         * <p>
         * The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation to
         * identify the dates of the available automatic snapshots.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be specified in <code>YYYY-MM-DD</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         * parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are
         * mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see
         * the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restoreDate
         *        The date of the source automatic snapshot to copy. Use the <code>get auto snapshots</code> operation
         *        to identify the dates of the available automatic snapshots.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be specified in <code>YYYY-MM-DD</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         *        parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code>
         *        parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when copying an automatic snapshot as a manual snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDate(String restoreDate);

        /**
         * <p>
         * A Boolean value to indicate whether to use the latest available automatic snapshot of the specified source
         * instance or disk.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>restore date</code> parameter. The
         * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         * exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when copying an automatic snapshot as a manual snapshot. For more information, see
         * the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         * >Lightsail Dev Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param useLatestRestorableAutoSnapshot
         *        A Boolean value to indicate whether to use the latest available automatic snapshot of the specified
         *        source instance or disk.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>restore date</code> parameter. The
         *        <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when copying an automatic snapshot as a manual snapshot. For more
         *        information, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-keeping-automatic-snapshots"
         *        >Lightsail Dev Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot);

        /**
         * <p>
         * The name of the new manual snapshot to be created as a copy.
         * </p>
         * 
         * @param targetSnapshotName
         *        The name of the new manual snapshot to be created as a copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotName(String targetSnapshotName);

        /**
         * <p>
         * The AWS Region where the source manual or automatic snapshot is located.
         * </p>
         * 
         * @param sourceRegion
         *        The AWS Region where the source manual or automatic snapshot is located.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The AWS Region where the source manual or automatic snapshot is located.
         * </p>
         * 
         * @param sourceRegion
         *        The AWS Region where the source manual or automatic snapshot is located.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder sourceRegion(RegionName sourceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String sourceSnapshotName;

        private String sourceResourceName;

        private String restoreDate;

        private Boolean useLatestRestorableAutoSnapshot;

        private String targetSnapshotName;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            sourceSnapshotName(model.sourceSnapshotName);
            sourceResourceName(model.sourceResourceName);
            restoreDate(model.restoreDate);
            useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
            targetSnapshotName(model.targetSnapshotName);
            sourceRegion(model.sourceRegion);
        }

        public final String getSourceSnapshotName() {
            return sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getSourceResourceName() {
            return sourceResourceName;
        }

        @Override
        public final Builder sourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
            return this;
        }

        public final void setSourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
        }

        public final String getRestoreDate() {
            return restoreDate;
        }

        @Override
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return useLatestRestorableAutoSnapshot;
        }

        @Override
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        public final String getTargetSnapshotName() {
            return targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public final Builder sourceRegion(RegionName sourceRegion) {
            this.sourceRegion(sourceRegion == null ? null : sourceRegion.toString());
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
