/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiskSnapshotResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDiskSnapshotResponse.Builder, GetDiskSnapshotResponse> {
    private static final SdkField<DiskSnapshot> DISK_SNAPSHOT_FIELD = SdkField.<DiskSnapshot> builder(MarshallingType.SDK_POJO)
            .memberName("diskSnapshot").getter(getter(GetDiskSnapshotResponse::diskSnapshot))
            .setter(setter(Builder::diskSnapshot)).constructor(DiskSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_SNAPSHOT_FIELD));

    private final DiskSnapshot diskSnapshot;

    private GetDiskSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.diskSnapshot = builder.diskSnapshot;
    }

    /**
     * <p>
     * An object containing information about the disk snapshot.
     * </p>
     * 
     * @return An object containing information about the disk snapshot.
     */
    public final DiskSnapshot diskSnapshot() {
        return diskSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskSnapshotResponse)) {
            return false;
        }
        GetDiskSnapshotResponse other = (GetDiskSnapshotResponse) obj;
        return Objects.equals(diskSnapshot(), other.diskSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDiskSnapshotResponse").add("DiskSnapshot", diskSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskSnapshot":
            return Optional.ofNullable(clazz.cast(diskSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiskSnapshotResponse, T> g) {
        return obj -> g.apply((GetDiskSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDiskSnapshotResponse> {
        /**
         * <p>
         * An object containing information about the disk snapshot.
         * </p>
         * 
         * @param diskSnapshot
         *        An object containing information about the disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshot(DiskSnapshot diskSnapshot);

        /**
         * <p>
         * An object containing information about the disk snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link DiskSnapshot.Builder} avoiding the need to
         * create one manually via {@link DiskSnapshot#builder()}.
         *
         * When the {@link Consumer} completes, {@link DiskSnapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #diskSnapshot(DiskSnapshot)}.
         * 
         * @param diskSnapshot
         *        a consumer that will call methods on {@link DiskSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskSnapshot(DiskSnapshot)
         */
        default Builder diskSnapshot(Consumer<DiskSnapshot.Builder> diskSnapshot) {
            return diskSnapshot(DiskSnapshot.builder().applyMutation(diskSnapshot).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private DiskSnapshot diskSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskSnapshotResponse model) {
            super(model);
            diskSnapshot(model.diskSnapshot);
        }

        public final DiskSnapshot.Builder getDiskSnapshot() {
            return diskSnapshot != null ? diskSnapshot.toBuilder() : null;
        }

        @Override
        public final Builder diskSnapshot(DiskSnapshot diskSnapshot) {
            this.diskSnapshot = diskSnapshot;
            return this;
        }

        public final void setDiskSnapshot(DiskSnapshot.BuilderImpl diskSnapshot) {
            this.diskSnapshot = diskSnapshot != null ? diskSnapshot.build() : null;
        }

        @Override
        public GetDiskSnapshotResponse build() {
            return new GetDiskSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
