/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load balancer SSL/TLS certificate.
 * </p>
 * <p>
 * TLS is just an updated, more secure version of Secure Socket Layer (SSL).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificate.Builder, LoadBalancerTlsCertificate> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LoadBalancerTlsCertificate::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LoadBalancerTlsCertificate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportCode").getter(getter(LoadBalancerTlsCertificate::supportCode))
            .setter(setter(Builder::supportCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(LoadBalancerTlsCertificate::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(LoadBalancerTlsCertificate::location)).setter(setter(Builder::location))
            .constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(LoadBalancerTlsCertificate::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(LoadBalancerTlsCertificate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadBalancerName").getter(getter(LoadBalancerTlsCertificate::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<Boolean> IS_ATTACHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAttached").getter(getter(LoadBalancerTlsCertificate::isAttached)).setter(setter(Builder::isAttached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAttached").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LoadBalancerTlsCertificate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(LoadBalancerTlsCertificate::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<List<LoadBalancerTlsCertificateDomainValidationRecord>> DOMAIN_VALIDATION_RECORDS_FIELD = SdkField
            .<List<LoadBalancerTlsCertificateDomainValidationRecord>> builder(MarshallingType.LIST)
            .memberName("domainValidationRecords")
            .getter(getter(LoadBalancerTlsCertificate::domainValidationRecords))
            .setter(setter(Builder::domainValidationRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerTlsCertificateDomainValidationRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerTlsCertificateDomainValidationRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(LoadBalancerTlsCertificate::failureReasonAsString))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("issuedAt").getter(getter(LoadBalancerTlsCertificate::issuedAt)).setter(setter(Builder::issuedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuedAt").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("issuer")
            .getter(getter(LoadBalancerTlsCertificate::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyAlgorithm").getter(getter(LoadBalancerTlsCertificate::keyAlgorithm))
            .setter(setter(Builder::keyAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyAlgorithm").build()).build();

    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("notAfter").getter(getter(LoadBalancerTlsCertificate::notAfter)).setter(setter(Builder::notAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notAfter").build()).build();

    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("notBefore").getter(getter(LoadBalancerTlsCertificate::notBefore)).setter(setter(Builder::notBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notBefore").build()).build();

    private static final SdkField<LoadBalancerTlsCertificateRenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField
            .<LoadBalancerTlsCertificateRenewalSummary> builder(MarshallingType.SDK_POJO).memberName("renewalSummary")
            .getter(getter(LoadBalancerTlsCertificate::renewalSummary)).setter(setter(Builder::renewalSummary))
            .constructor(LoadBalancerTlsCertificateRenewalSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalSummary").build()).build();

    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revocationReason").getter(getter(LoadBalancerTlsCertificate::revocationReasonAsString))
            .setter(setter(Builder::revocationReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationReason").build()).build();

    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("revokedAt").getter(getter(LoadBalancerTlsCertificate::revokedAt)).setter(setter(Builder::revokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedAt").build()).build();

    private static final SdkField<String> SERIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("serial")
            .getter(getter(LoadBalancerTlsCertificate::serial)).setter(setter(Builder::serial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serial").build()).build();

    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signatureAlgorithm").getter(getter(LoadBalancerTlsCertificate::signatureAlgorithm))
            .setter(setter(Builder::signatureAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build())
            .build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("subject")
            .getter(getter(LoadBalancerTlsCertificate::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()).build();

    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subjectAlternativeNames")
            .getter(getter(LoadBalancerTlsCertificate::subjectAlternativeNames))
            .setter(setter(Builder::subjectAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectAlternativeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, LOAD_BALANCER_NAME_FIELD,
            IS_ATTACHED_FIELD, STATUS_FIELD, DOMAIN_NAME_FIELD, DOMAIN_VALIDATION_RECORDS_FIELD, FAILURE_REASON_FIELD,
            ISSUED_AT_FIELD, ISSUER_FIELD, KEY_ALGORITHM_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, RENEWAL_SUMMARY_FIELD,
            REVOCATION_REASON_FIELD, REVOKED_AT_FIELD, SERIAL_FIELD, SIGNATURE_ALGORITHM_FIELD, SUBJECT_FIELD,
            SUBJECT_ALTERNATIVE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final List<Tag> tags;

    private final String loadBalancerName;

    private final Boolean isAttached;

    private final String status;

    private final String domainName;

    private final List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords;

    private final String failureReason;

    private final Instant issuedAt;

    private final String issuer;

    private final String keyAlgorithm;

    private final Instant notAfter;

    private final Instant notBefore;

    private final LoadBalancerTlsCertificateRenewalSummary renewalSummary;

    private final String revocationReason;

    private final Instant revokedAt;

    private final String serial;

    private final String signatureAlgorithm;

    private final String subject;

    private final List<String> subjectAlternativeNames;

    private LoadBalancerTlsCertificate(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.loadBalancerName = builder.loadBalancerName;
        this.isAttached = builder.isAttached;
        this.status = builder.status;
        this.domainName = builder.domainName;
        this.domainValidationRecords = builder.domainValidationRecords;
        this.failureReason = builder.failureReason;
        this.issuedAt = builder.issuedAt;
        this.issuer = builder.issuer;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.renewalSummary = builder.renewalSummary;
        this.revocationReason = builder.revocationReason;
        this.revokedAt = builder.revokedAt;
        this.serial = builder.serial;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.subject = builder.subject;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
    }

    /**
     * <p>
     * The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).
     * </p>
     * 
     * @return The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SSL/TLS certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SSL/TLS certificate.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about your Lightsail load
     * balancer or SSL/TLS certificate. This code enables our support team to look up your Lightsail information more
     * easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about your Lightsail
     *         load balancer or SSL/TLS certificate. This code enables our support team to look up your Lightsail
     *         information more easily.
     */
    public final String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The time when you created your SSL/TLS certificate.
     * </p>
     * 
     * @return The time when you created your SSL/TLS certificate.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Region and Availability Zone where you created your certificate.
     * </p>
     * 
     * @return The AWS Region and Availability Zone where you created your certificate.
     */
    public final ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>StaticIp</code> </b> - A static IP address
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Domain</code> </b> - A DNS zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PeeredVpc</code> </b> - A peered VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail load
     * balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Disk</code> </b> - A Lightsail block storage disk
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>StaticIp</code> </b> - A static IP address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Domain</code> </b> - A DNS zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PeeredVpc</code> </b> - A peered VPC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail
     *         load balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Disk</code> </b> - A Lightsail block storage disk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>StaticIp</code> </b> - A static IP address
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Domain</code> </b> - A DNS zone
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PeeredVpc</code> </b> - A peered VPC
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail load
     * balancer
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Disk</code> </b> - A Lightsail block storage disk
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>StaticIp</code> </b> - A static IP address
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Domain</code> </b> - A DNS zone
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PeeredVpc</code> </b> - A peered VPC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail
     *         load balancer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Disk</code> </b> - A Lightsail block storage disk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
     *         </p>
     *         </li>
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values for the resource. For more information about tags in Lightsail, see the
     *         <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
     *         Guide</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The load balancer name where your SSL/TLS certificate is attached.
     * </p>
     * 
     * @return The load balancer name where your SSL/TLS certificate is attached.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
     * </p>
     * 
     * @return When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
     */
    public final Boolean isAttached() {
        return isAttached;
    }

    /**
     * <p>
     * The validation status of the SSL/TLS certificate. Valid values are below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LoadBalancerTlsCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The validation status of the SSL/TLS certificate. Valid values are below.
     * @see LoadBalancerTlsCertificateStatus
     */
    public final LoadBalancerTlsCertificateStatus status() {
        return LoadBalancerTlsCertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The validation status of the SSL/TLS certificate. Valid values are below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LoadBalancerTlsCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The validation status of the SSL/TLS certificate. Valid values are below.
     * @see LoadBalancerTlsCertificateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The domain name for your SSL/TLS certificate.
     * </p>
     * 
     * @return The domain name for your SSL/TLS certificate.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * Returns true if the DomainValidationRecords property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDomainValidationRecords() {
        return domainValidationRecords != null && !(domainValidationRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainValidationRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
     */
    public final List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords() {
        return domainValidationRecords;
    }

    /**
     * <p>
     * The validation failure reason, if any, of the certificate.
     * </p>
     * <p>
     * The following failure reasons are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not available
     * for Lightsail certificates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to process
     * this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the
     * Alexa top 1000 websites. To provide the required information, use the <a
     * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
     * </p>
     * <note>
     * <p>
     * You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
     * cloudfront.net, or elasticbeanstalk.com.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
     * reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
     * problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>
     * website. If your domain is reported as suspicious, see <a
     * href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for Hacked Websites</a> to
     * learn what you can do.
     * </p>
     * <p>
     * If you believe that the result is a false positive, notify the organization that is reporting the domain.
     * VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list
     * itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.
     * </p>
     * <p>
     * If you see this error and your domain is not included in the VirusTotal list, visit the <a
     * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request is not
     * valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a
     * certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all
     * domain names in the request are for valid top-level domains. For example, you cannot request a certificate for
     * <code>example.invalidpublicdomain</code> because <code>invalidpublicdomain</code> is not a valid top-level
     * domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one or more
     * of the domain names in the certificate request. Try to request a certificate again, correcting any spelling
     * errors or typos that were in the failed request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link LoadBalancerTlsCertificateFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The validation failure reason, if any, of the certificate.</p>
     *         <p>
     *         The following failure reasons are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
     *         available for Lightsail certificates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to
     *         process this certificate request. This can happen as a fraud-protection measure, such as when the domain
     *         ranks within the Alexa top 1000 websites. To provide the required information, use the <a
     *         href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
     *         cloudfront.net, or elasticbeanstalk.com.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
     *         reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To
     *         correct the problem, search for your domain name on the <a
     *         href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
     *         suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
     *         Hacked Websites</a> to learn what you can do.
     *         </p>
     *         <p>
     *         If you believe that the result is a false positive, notify the organization that is reporting the domain.
     *         VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a
     *         block list itself. After you correct the problem and the VirusTotal registry has been updated, request a
     *         new certificate.
     *         </p>
     *         <p>
     *         If you see this error and your domain is not included in the VirusTotal list, visit the <a
     *         href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request
     *         is not valid. Typically, this is because a domain name in the request is not a valid top-level domain.
     *         Try to request a certificate again, correcting any spelling errors or typos that were in the failed
     *         request, and ensure that all domain names in the request are for valid top-level domains. For example,
     *         you cannot request a certificate for <code>example.invalidpublicdomain</code> because
     *         <code>invalidpublicdomain</code> is not a valid top-level domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one
     *         or more of the domain names in the certificate request. Try to request a certificate again, correcting
     *         any spelling errors or typos that were in the failed request.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateFailureReason
     */
    public final LoadBalancerTlsCertificateFailureReason failureReason() {
        return LoadBalancerTlsCertificateFailureReason.fromValue(failureReason);
    }

    /**
     * <p>
     * The validation failure reason, if any, of the certificate.
     * </p>
     * <p>
     * The following failure reasons are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not available
     * for Lightsail certificates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to process
     * this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within the
     * Alexa top 1000 websites. To provide the required information, use the <a
     * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
     * </p>
     * <note>
     * <p>
     * You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
     * cloudfront.net, or elasticbeanstalk.com.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
     * reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct the
     * problem, search for your domain name on the <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>
     * website. If your domain is reported as suspicious, see <a
     * href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for Hacked Websites</a> to
     * learn what you can do.
     * </p>
     * <p>
     * If you believe that the result is a false positive, notify the organization that is reporting the domain.
     * VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block list
     * itself. After you correct the problem and the VirusTotal registry has been updated, request a new certificate.
     * </p>
     * <p>
     * If you see this error and your domain is not included in the VirusTotal list, visit the <a
     * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request is not
     * valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to request a
     * certificate again, correcting any spelling errors or typos that were in the failed request, and ensure that all
     * domain names in the request are for valid top-level domains. For example, you cannot request a certificate for
     * <code>example.invalidpublicdomain</code> because <code>invalidpublicdomain</code> is not a valid top-level
     * domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one or more
     * of the domain names in the certificate request. Try to request a certificate again, correcting any spelling
     * errors or typos that were in the failed request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureReason}
     * will return {@link LoadBalancerTlsCertificateFailureReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #failureReasonAsString}.
     * </p>
     * 
     * @return The validation failure reason, if any, of the certificate.</p>
     *         <p>
     *         The following failure reasons are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
     *         available for Lightsail certificates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to
     *         process this certificate request. This can happen as a fraud-protection measure, such as when the domain
     *         ranks within the Alexa top 1000 websites. To provide the required information, use the <a
     *         href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
     *         </p>
     *         <note>
     *         <p>
     *         You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
     *         cloudfront.net, or elasticbeanstalk.com.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
     *         reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To
     *         correct the problem, search for your domain name on the <a
     *         href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
     *         suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
     *         Hacked Websites</a> to learn what you can do.
     *         </p>
     *         <p>
     *         If you believe that the result is a false positive, notify the organization that is reporting the domain.
     *         VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a
     *         block list itself. After you correct the problem and the VirusTotal registry has been updated, request a
     *         new certificate.
     *         </p>
     *         <p>
     *         If you see this error and your domain is not included in the VirusTotal list, visit the <a
     *         href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request
     *         is not valid. Typically, this is because a domain name in the request is not a valid top-level domain.
     *         Try to request a certificate again, correcting any spelling errors or typos that were in the failed
     *         request, and ensure that all domain names in the request are for valid top-level domains. For example,
     *         you cannot request a certificate for <code>example.invalidpublicdomain</code> because
     *         <code>invalidpublicdomain</code> is not a valid top-level domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one
     *         or more of the domain names in the certificate request. Try to request a certificate again, correcting
     *         any spelling errors or typos that were in the failed request.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateFailureReason
     */
    public final String failureReasonAsString() {
        return failureReason;
    }

    /**
     * <p>
     * The time when the SSL/TLS certificate was issued.
     * </p>
     * 
     * @return The time when the SSL/TLS certificate was issued.
     */
    public final Instant issuedAt() {
        return issuedAt;
    }

    /**
     * <p>
     * The issuer of the certificate.
     * </p>
     * 
     * @return The issuer of the certificate.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The algorithm used to generate the key pair (the public and private key).
     * </p>
     * 
     * @return The algorithm used to generate the key pair (the public and private key).
     */
    public final String keyAlgorithm() {
        return keyAlgorithm;
    }

    /**
     * <p>
     * The timestamp when the SSL/TLS certificate expires.
     * </p>
     * 
     * @return The timestamp when the SSL/TLS certificate expires.
     */
    public final Instant notAfter() {
        return notAfter;
    }

    /**
     * <p>
     * The timestamp when the SSL/TLS certificate is first valid.
     * </p>
     * 
     * @return The timestamp when the SSL/TLS certificate is first valid.
     */
    public final Instant notBefore() {
        return notBefore;
    }

    /**
     * <p>
     * An object that describes the status of the certificate renewal managed by Lightsail.
     * </p>
     * 
     * @return An object that describes the status of the certificate renewal managed by Lightsail.
     */
    public final LoadBalancerTlsCertificateRenewalSummary renewalSummary() {
        return renewalSummary;
    }

    /**
     * <p>
     * The reason the certificate was revoked. This value is present only when the certificate status is
     * <code>REVOKED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link LoadBalancerTlsCertificateRevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return The reason the certificate was revoked. This value is present only when the certificate status is
     *         <code>REVOKED</code>.
     * @see LoadBalancerTlsCertificateRevocationReason
     */
    public final LoadBalancerTlsCertificateRevocationReason revocationReason() {
        return LoadBalancerTlsCertificateRevocationReason.fromValue(revocationReason);
    }

    /**
     * <p>
     * The reason the certificate was revoked. This value is present only when the certificate status is
     * <code>REVOKED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #revocationReason}
     * will return {@link LoadBalancerTlsCertificateRevocationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #revocationReasonAsString}.
     * </p>
     * 
     * @return The reason the certificate was revoked. This value is present only when the certificate status is
     *         <code>REVOKED</code>.
     * @see LoadBalancerTlsCertificateRevocationReason
     */
    public final String revocationReasonAsString() {
        return revocationReason;
    }

    /**
     * <p>
     * The timestamp when the certificate was revoked. This value is present only when the certificate status is
     * <code>REVOKED</code>.
     * </p>
     * 
     * @return The timestamp when the certificate was revoked. This value is present only when the certificate status is
     *         <code>REVOKED</code>.
     */
    public final Instant revokedAt() {
        return revokedAt;
    }

    /**
     * <p>
     * The serial number of the certificate.
     * </p>
     * 
     * @return The serial number of the certificate.
     */
    public final String serial() {
        return serial;
    }

    /**
     * <p>
     * The algorithm that was used to sign the certificate.
     * </p>
     * 
     * @return The algorithm that was used to sign the certificate.
     */
    public final String signatureAlgorithm() {
        return signatureAlgorithm;
    }

    /**
     * <p>
     * The name of the entity that is associated with the public key contained in the certificate.
     * </p>
     * 
     * @return The name of the entity that is associated with the public key contained in the certificate.
     */
    public final String subject() {
        return subject;
    }

    /**
     * Returns true if the SubjectAlternativeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSubjectAlternativeNames() {
        return subjectAlternativeNames != null && !(subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains (e.g.,
     * <code>blog.example.com</code>) for the certificate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubjectAlternativeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains
     *         (e.g., <code>blog.example.com</code>) for the certificate.
     */
    public final List<String> subjectAlternativeNames() {
        return subjectAlternativeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(isAttached());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainValidationRecords() ? domainValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(keyAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(revocationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(serial());
        hashCode = 31 * hashCode + Objects.hashCode(signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjectAlternativeNames() ? subjectAlternativeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificate)) {
            return false;
        }
        LoadBalancerTlsCertificate other = (LoadBalancerTlsCertificate) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(isAttached(), other.isAttached()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(domainName(), other.domainName())
                && hasDomainValidationRecords() == other.hasDomainValidationRecords()
                && Objects.equals(domainValidationRecords(), other.domainValidationRecords())
                && Objects.equals(failureReasonAsString(), other.failureReasonAsString())
                && Objects.equals(issuedAt(), other.issuedAt()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(keyAlgorithm(), other.keyAlgorithm()) && Objects.equals(notAfter(), other.notAfter())
                && Objects.equals(notBefore(), other.notBefore()) && Objects.equals(renewalSummary(), other.renewalSummary())
                && Objects.equals(revocationReasonAsString(), other.revocationReasonAsString())
                && Objects.equals(revokedAt(), other.revokedAt()) && Objects.equals(serial(), other.serial())
                && Objects.equals(signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(subject(), other.subject())
                && hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames()
                && Objects.equals(subjectAlternativeNames(), other.subjectAlternativeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerTlsCertificate").add("Name", name()).add("Arn", arn())
                .add("SupportCode", supportCode()).add("CreatedAt", createdAt()).add("Location", location())
                .add("ResourceType", resourceTypeAsString()).add("Tags", hasTags() ? tags() : null)
                .add("LoadBalancerName", loadBalancerName()).add("IsAttached", isAttached()).add("Status", statusAsString())
                .add("DomainName", domainName())
                .add("DomainValidationRecords", hasDomainValidationRecords() ? domainValidationRecords() : null)
                .add("FailureReason", failureReasonAsString()).add("IssuedAt", issuedAt()).add("Issuer", issuer())
                .add("KeyAlgorithm", keyAlgorithm()).add("NotAfter", notAfter()).add("NotBefore", notBefore())
                .add("RenewalSummary", renewalSummary()).add("RevocationReason", revocationReasonAsString())
                .add("RevokedAt", revokedAt()).add("Serial", serial()).add("SignatureAlgorithm", signatureAlgorithm())
                .add("Subject", subject())
                .add("SubjectAlternativeNames", hasSubjectAlternativeNames() ? subjectAlternativeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "supportCode":
            return Optional.ofNullable(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "isAttached":
            return Optional.ofNullable(clazz.cast(isAttached()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainValidationRecords":
            return Optional.ofNullable(clazz.cast(domainValidationRecords()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReasonAsString()));
        case "issuedAt":
            return Optional.ofNullable(clazz.cast(issuedAt()));
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "keyAlgorithm":
            return Optional.ofNullable(clazz.cast(keyAlgorithm()));
        case "notAfter":
            return Optional.ofNullable(clazz.cast(notAfter()));
        case "notBefore":
            return Optional.ofNullable(clazz.cast(notBefore()));
        case "renewalSummary":
            return Optional.ofNullable(clazz.cast(renewalSummary()));
        case "revocationReason":
            return Optional.ofNullable(clazz.cast(revocationReasonAsString()));
        case "revokedAt":
            return Optional.ofNullable(clazz.cast(revokedAt()));
        case "serial":
            return Optional.ofNullable(clazz.cast(serial()));
        case "signatureAlgorithm":
            return Optional.ofNullable(clazz.cast(signatureAlgorithm()));
        case "subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "subjectAlternativeNames":
            return Optional.ofNullable(clazz.cast(subjectAlternativeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificate, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificate> {
        /**
         * <p>
         * The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).
         * </p>
         * 
         * @param name
         *        The name of the SSL/TLS certificate (e.g., <code>my-certificate</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SSL/TLS certificate.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about your Lightsail
         * load balancer or SSL/TLS certificate. This code enables our support team to look up your Lightsail
         * information more easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about your
         *        Lightsail load balancer or SSL/TLS certificate. This code enables our support team to look up your
         *        Lightsail information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The time when you created your SSL/TLS certificate.
         * </p>
         * 
         * @param createdAt
         *        The time when you created your SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Region and Availability Zone where you created your certificate.
         * </p>
         * 
         * @param location
         *        The AWS Region and Availability Zone where you created your certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The AWS Region and Availability Zone where you created your certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>StaticIp</code> </b> - A static IP address
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Domain</code> </b> - A DNS zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PeeredVpc</code> </b> - A peered VPC
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail load
         * balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Disk</code> </b> - A Lightsail block storage disk
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>StaticIp</code> </b> - A static IP address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Domain</code> </b> - A DNS zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PeeredVpc</code> </b> - A peered VPC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail
         *        load balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Disk</code> </b> - A Lightsail block storage disk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>StaticIp</code> </b> - A static IP address
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Domain</code> </b> - A DNS zone
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PeeredVpc</code> </b> - A peered VPC
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail load
         * balancer
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Disk</code> </b> - A Lightsail block storage disk
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type (e.g., <code>LoadBalancerTlsCertificate</code>).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>Instance</code> </b> - A Lightsail instance (a virtual private server)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>StaticIp</code> </b> - A static IP address
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>KeyPair</code> </b> - The key pair used to connect to a Lightsail instance
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>InstanceSnapshot</code> </b> - A Lightsail instance snapshot
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Domain</code> </b> - A DNS zone
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PeeredVpc</code> </b> - A peered VPC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>LoadBalancer</code> </b> - A Lightsail load balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>LoadBalancerTlsCertificate</code> </b> - An SSL/TLS certificate associated with a Lightsail
         *        load balancer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Disk</code> </b> - A Lightsail block storage disk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>DiskSnapshot</code> </b> - A block storage disk snapshot
         *        </p>
         *        </li>
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The load balancer name where your SSL/TLS certificate is attached.
         * </p>
         * 
         * @param loadBalancerName
         *        The load balancer name where your SSL/TLS certificate is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
         * </p>
         * 
         * @param isAttached
         *        When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAttached(Boolean isAttached);

        /**
         * <p>
         * The validation status of the SSL/TLS certificate. Valid values are below.
         * </p>
         * 
         * @param status
         *        The validation status of the SSL/TLS certificate. Valid values are below.
         * @see LoadBalancerTlsCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The validation status of the SSL/TLS certificate. Valid values are below.
         * </p>
         * 
         * @param status
         *        The validation status of the SSL/TLS certificate. Valid values are below.
         * @see LoadBalancerTlsCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateStatus
         */
        Builder status(LoadBalancerTlsCertificateStatus status);

        /**
         * <p>
         * The domain name for your SSL/TLS certificate.
         * </p>
         * 
         * @param domainName
         *        The domain name for your SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         * </p>
         * 
         * @param domainValidationRecords
         *        An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationRecords(Collection<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         * </p>
         * 
         * @param domainValidationRecords
         *        An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationRecords(LoadBalancerTlsCertificateDomainValidationRecord... domainValidationRecords);

        /**
         * <p>
         * An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing the records.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LoadBalancerTlsCertificateDomainValidationRecord>.Builder} avoiding the need to create one manually via
         * {@link List<LoadBalancerTlsCertificateDomainValidationRecord>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LoadBalancerTlsCertificateDomainValidationRecord>.Builder#build()} is called immediately and its result is
         * passed to {@link #domainValidationRecords(List<LoadBalancerTlsCertificateDomainValidationRecord>)}.
         * 
         * @param domainValidationRecords
         *        a consumer that will call methods on {@link List
         *        <LoadBalancerTlsCertificateDomainValidationRecord>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationRecords(List<LoadBalancerTlsCertificateDomainValidationRecord>)
         */
        Builder domainValidationRecords(
                Consumer<LoadBalancerTlsCertificateDomainValidationRecord.Builder>... domainValidationRecords);

        /**
         * <p>
         * The validation failure reason, if any, of the certificate.
         * </p>
         * <p>
         * The following failure reasons are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
         * available for Lightsail certificates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to process
         * this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within
         * the Alexa top 1000 websites. To provide the required information, use the <a
         * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
         * </p>
         * <note>
         * <p>
         * You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
         * cloudfront.net, or elasticbeanstalk.com.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
         * reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct
         * the problem, search for your domain name on the <a
         * href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
         * suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
         * Hacked Websites</a> to learn what you can do.
         * </p>
         * <p>
         * If you believe that the result is a false positive, notify the organization that is reporting the domain.
         * VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block
         * list itself. After you correct the problem and the VirusTotal registry has been updated, request a new
         * certificate.
         * </p>
         * <p>
         * If you see this error and your domain is not included in the VirusTotal list, visit the <a
         * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request is
         * not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to
         * request a certificate again, correcting any spelling errors or typos that were in the failed request, and
         * ensure that all domain names in the request are for valid top-level domains. For example, you cannot request
         * a certificate for <code>example.invalidpublicdomain</code> because <code>invalidpublicdomain</code> is not a
         * valid top-level domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one or
         * more of the domain names in the certificate request. Try to request a certificate again, correcting any
         * spelling errors or typos that were in the failed request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureReason
         *        The validation failure reason, if any, of the certificate.</p>
         *        <p>
         *        The following failure reasons are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
         *        available for Lightsail certificates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to
         *        process this certificate request. This can happen as a fraud-protection measure, such as when the
         *        domain ranks within the Alexa top 1000 websites. To provide the required information, use the <a
         *        href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
         *        cloudfront.net, or elasticbeanstalk.com.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request
         *        was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>.
         *        To correct the problem, search for your domain name on the <a
         *        href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
         *        suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help
         *        for Hacked Websites</a> to learn what you can do.
         *        </p>
         *        <p>
         *        If you believe that the result is a false positive, notify the organization that is reporting the
         *        domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain
         *        from a block list itself. After you correct the problem and the VirusTotal registry has been updated,
         *        request a new certificate.
         *        </p>
         *        <p>
         *        If you see this error and your domain is not included in the VirusTotal list, visit the <a
         *        href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate
         *        request is not valid. Typically, this is because a domain name in the request is not a valid top-level
         *        domain. Try to request a certificate again, correcting any spelling errors or typos that were in the
         *        failed request, and ensure that all domain names in the request are for valid top-level domains. For
         *        example, you cannot request a certificate for <code>example.invalidpublicdomain</code> because
         *        <code>invalidpublicdomain</code> is not a valid top-level domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in
         *        one or more of the domain names in the certificate request. Try to request a certificate again,
         *        correcting any spelling errors or typos that were in the failed request.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateFailureReason
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The validation failure reason, if any, of the certificate.
         * </p>
         * <p>
         * The following failure reasons are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
         * available for Lightsail certificates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to process
         * this certificate request. This can happen as a fraud-protection measure, such as when the domain ranks within
         * the Alexa top 1000 websites. To provide the required information, use the <a
         * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
         * </p>
         * <note>
         * <p>
         * You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
         * cloudfront.net, or elasticbeanstalk.com.
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request was
         * reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>. To correct
         * the problem, search for your domain name on the <a
         * href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
         * suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help for
         * Hacked Websites</a> to learn what you can do.
         * </p>
         * <p>
         * If you believe that the result is a false positive, notify the organization that is reporting the domain.
         * VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain from a block
         * list itself. After you correct the problem and the VirusTotal registry has been updated, request a new
         * certificate.
         * </p>
         * <p>
         * If you see this error and your domain is not included in the VirusTotal list, visit the <a
         * href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate request is
         * not valid. Typically, this is because a domain name in the request is not a valid top-level domain. Try to
         * request a certificate again, correcting any spelling errors or typos that were in the failed request, and
         * ensure that all domain names in the request are for valid top-level domains. For example, you cannot request
         * a certificate for <code>example.invalidpublicdomain</code> because <code>invalidpublicdomain</code> is not a
         * valid top-level domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in one or
         * more of the domain names in the certificate request. Try to request a certificate again, correcting any
         * spelling errors or typos that were in the failed request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureReason
         *        The validation failure reason, if any, of the certificate.</p>
         *        <p>
         *        The following failure reasons are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>NO_AVAILABLE_CONTACTS</code> </b> - This failure applies to email validation, which is not
         *        available for Lightsail certificates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>ADDITIONAL_VERIFICATION_REQUIRED</code> </b> - Lightsail requires additional information to
         *        process this certificate request. This can happen as a fraud-protection measure, such as when the
         *        domain ranks within the Alexa top 1000 websites. To provide the required information, use the <a
         *        href="https://console.aws.amazon.com/support/home">AWS Support Center</a> to contact AWS Support.
         *        </p>
         *        <note>
         *        <p>
         *        You cannot request a certificate for Amazon-owned domain names such as those ending in amazonaws.com,
         *        cloudfront.net, or elasticbeanstalk.com.
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <b> <code>DOMAIN_NOT_ALLOWED</code> </b> - One or more of the domain names in the certificate request
         *        was reported as an unsafe domain by <a href="https://www.virustotal.com/gui/home/url">VirusTotal</a>.
         *        To correct the problem, search for your domain name on the <a
         *        href="https://www.virustotal.com/gui/home/url">VirusTotal</a> website. If your domain is reported as
         *        suspicious, see <a href="https://developers.google.com/web/fundamentals/security/hacked">Google Help
         *        for Hacked Websites</a> to learn what you can do.
         *        </p>
         *        <p>
         *        If you believe that the result is a false positive, notify the organization that is reporting the
         *        domain. VirusTotal is an aggregate of several antivirus and URL scanners and cannot remove your domain
         *        from a block list itself. After you correct the problem and the VirusTotal registry has been updated,
         *        request a new certificate.
         *        </p>
         *        <p>
         *        If you see this error and your domain is not included in the VirusTotal list, visit the <a
         *        href="https://console.aws.amazon.com/support/home">AWS Support Center</a> and create a case.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>INVALID_PUBLIC_DOMAIN</code> </b> - One or more of the domain names in the certificate
         *        request is not valid. Typically, this is because a domain name in the request is not a valid top-level
         *        domain. Try to request a certificate again, correcting any spelling errors or typos that were in the
         *        failed request, and ensure that all domain names in the request are for valid top-level domains. For
         *        example, you cannot request a certificate for <code>example.invalidpublicdomain</code> because
         *        <code>invalidpublicdomain</code> is not a valid top-level domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>OTHER</code> </b> - Typically, this failure occurs when there is a typographical error in
         *        one or more of the domain names in the certificate request. Try to request a certificate again,
         *        correcting any spelling errors or typos that were in the failed request.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateFailureReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateFailureReason
         */
        Builder failureReason(LoadBalancerTlsCertificateFailureReason failureReason);

        /**
         * <p>
         * The time when the SSL/TLS certificate was issued.
         * </p>
         * 
         * @param issuedAt
         *        The time when the SSL/TLS certificate was issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuedAt(Instant issuedAt);

        /**
         * <p>
         * The issuer of the certificate.
         * </p>
         * 
         * @param issuer
         *        The issuer of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The algorithm used to generate the key pair (the public and private key).
         * </p>
         * 
         * @param keyAlgorithm
         *        The algorithm used to generate the key pair (the public and private key).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAlgorithm(String keyAlgorithm);

        /**
         * <p>
         * The timestamp when the SSL/TLS certificate expires.
         * </p>
         * 
         * @param notAfter
         *        The timestamp when the SSL/TLS certificate expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notAfter(Instant notAfter);

        /**
         * <p>
         * The timestamp when the SSL/TLS certificate is first valid.
         * </p>
         * 
         * @param notBefore
         *        The timestamp when the SSL/TLS certificate is first valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notBefore(Instant notBefore);

        /**
         * <p>
         * An object that describes the status of the certificate renewal managed by Lightsail.
         * </p>
         * 
         * @param renewalSummary
         *        An object that describes the status of the certificate renewal managed by Lightsail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalSummary(LoadBalancerTlsCertificateRenewalSummary renewalSummary);

        /**
         * <p>
         * An object that describes the status of the certificate renewal managed by Lightsail.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link LoadBalancerTlsCertificateRenewalSummary.Builder} avoiding the need to create one manually via
         * {@link LoadBalancerTlsCertificateRenewalSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancerTlsCertificateRenewalSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #renewalSummary(LoadBalancerTlsCertificateRenewalSummary)}.
         * 
         * @param renewalSummary
         *        a consumer that will call methods on {@link LoadBalancerTlsCertificateRenewalSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renewalSummary(LoadBalancerTlsCertificateRenewalSummary)
         */
        default Builder renewalSummary(Consumer<LoadBalancerTlsCertificateRenewalSummary.Builder> renewalSummary) {
            return renewalSummary(LoadBalancerTlsCertificateRenewalSummary.builder().applyMutation(renewalSummary).build());
        }

        /**
         * <p>
         * The reason the certificate was revoked. This value is present only when the certificate status is
         * <code>REVOKED</code>.
         * </p>
         * 
         * @param revocationReason
         *        The reason the certificate was revoked. This value is present only when the certificate status is
         *        <code>REVOKED</code>.
         * @see LoadBalancerTlsCertificateRevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRevocationReason
         */
        Builder revocationReason(String revocationReason);

        /**
         * <p>
         * The reason the certificate was revoked. This value is present only when the certificate status is
         * <code>REVOKED</code>.
         * </p>
         * 
         * @param revocationReason
         *        The reason the certificate was revoked. This value is present only when the certificate status is
         *        <code>REVOKED</code>.
         * @see LoadBalancerTlsCertificateRevocationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRevocationReason
         */
        Builder revocationReason(LoadBalancerTlsCertificateRevocationReason revocationReason);

        /**
         * <p>
         * The timestamp when the certificate was revoked. This value is present only when the certificate status is
         * <code>REVOKED</code>.
         * </p>
         * 
         * @param revokedAt
         *        The timestamp when the certificate was revoked. This value is present only when the certificate status
         *        is <code>REVOKED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokedAt(Instant revokedAt);

        /**
         * <p>
         * The serial number of the certificate.
         * </p>
         * 
         * @param serial
         *        The serial number of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serial(String serial);

        /**
         * <p>
         * The algorithm that was used to sign the certificate.
         * </p>
         * 
         * @param signatureAlgorithm
         *        The algorithm that was used to sign the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureAlgorithm(String signatureAlgorithm);

        /**
         * <p>
         * The name of the entity that is associated with the public key contained in the certificate.
         * </p>
         * 
         * @param subject
         *        The name of the entity that is associated with the public key contained in the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains
         * (e.g., <code>blog.example.com</code>) for the certificate.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and
         *        subdomains (e.g., <code>blog.example.com</code>) for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames);

        /**
         * <p>
         * An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and subdomains
         * (e.g., <code>blog.example.com</code>) for the certificate.
         * </p>
         * 
         * @param subjectAlternativeNames
         *        An array of strings that specify the alternate domains (e.g., <code>example2.com</code>) and
         *        subdomains (e.g., <code>blog.example.com</code>) for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectAlternativeNames(String... subjectAlternativeNames);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String loadBalancerName;

        private Boolean isAttached;

        private String status;

        private String domainName;

        private List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords = DefaultSdkAutoConstructList
                .getInstance();

        private String failureReason;

        private Instant issuedAt;

        private String issuer;

        private String keyAlgorithm;

        private Instant notAfter;

        private Instant notBefore;

        private LoadBalancerTlsCertificateRenewalSummary renewalSummary;

        private String revocationReason;

        private Instant revokedAt;

        private String serial;

        private String signatureAlgorithm;

        private String subject;

        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificate model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            tags(model.tags);
            loadBalancerName(model.loadBalancerName);
            isAttached(model.isAttached);
            status(model.status);
            domainName(model.domainName);
            domainValidationRecords(model.domainValidationRecords);
            failureReason(model.failureReason);
            issuedAt(model.issuedAt);
            issuer(model.issuer);
            keyAlgorithm(model.keyAlgorithm);
            notAfter(model.notAfter);
            notBefore(model.notBefore);
            renewalSummary(model.renewalSummary);
            revocationReason(model.revocationReason);
            revokedAt(model.revokedAt);
            serial(model.serial);
            signatureAlgorithm(model.signatureAlgorithm);
            subject(model.subject);
            subjectAlternativeNames(model.subjectAlternativeNames);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Boolean getIsAttached() {
            return isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LoadBalancerTlsCertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final List<LoadBalancerTlsCertificateDomainValidationRecord.Builder> getDomainValidationRecords() {
            List<LoadBalancerTlsCertificateDomainValidationRecord.Builder> result = LoadBalancerTlsCertificateDomainValidationRecordListCopier
                    .copyToBuilder(this.domainValidationRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder domainValidationRecords(
                Collection<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords) {
            this.domainValidationRecords = LoadBalancerTlsCertificateDomainValidationRecordListCopier
                    .copy(domainValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(LoadBalancerTlsCertificateDomainValidationRecord... domainValidationRecords) {
            domainValidationRecords(Arrays.asList(domainValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(
                Consumer<LoadBalancerTlsCertificateDomainValidationRecord.Builder>... domainValidationRecords) {
            domainValidationRecords(Stream.of(domainValidationRecords)
                    .map(c -> LoadBalancerTlsCertificateDomainValidationRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationRecords(
                Collection<LoadBalancerTlsCertificateDomainValidationRecord.BuilderImpl> domainValidationRecords) {
            this.domainValidationRecords = LoadBalancerTlsCertificateDomainValidationRecordListCopier
                    .copyFromBuilder(domainValidationRecords);
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(LoadBalancerTlsCertificateFailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getIssuedAt() {
            return issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getKeyAlgorithm() {
            return keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final Instant getNotAfter() {
            return notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final LoadBalancerTlsCertificateRenewalSummary.Builder getRenewalSummary() {
            return renewalSummary != null ? renewalSummary.toBuilder() : null;
        }

        @Override
        public final Builder renewalSummary(LoadBalancerTlsCertificateRenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(LoadBalancerTlsCertificateRenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        public final String getRevocationReason() {
            return revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(LoadBalancerTlsCertificateRevocationReason revocationReason) {
            this.revocationReason(revocationReason == null ? null : revocationReason.toString());
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final Instant getRevokedAt() {
            return revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getSerial() {
            return serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        public final String getSignatureAlgorithm() {
            return signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String... subjectAlternativeNames) {
            subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
        }

        @Override
        public LoadBalancerTlsCertificate build() {
            return new LoadBalancerTlsCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
