/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerImagesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerImagesResponse.Builder, GetContainerImagesResponse> {
    private static final SdkField<List<ContainerImage>> CONTAINER_IMAGES_FIELD = SdkField
            .<List<ContainerImage>> builder(MarshallingType.LIST)
            .memberName("containerImages")
            .getter(getter(GetContainerImagesResponse::containerImages))
            .setter(setter(Builder::containerImages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_IMAGES_FIELD));

    private final List<ContainerImage> containerImages;

    private GetContainerImagesResponse(BuilderImpl builder) {
        super(builder);
        this.containerImages = builder.containerImages;
    }

    /**
     * Returns true if the ContainerImages property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasContainerImages() {
        return containerImages != null && !(containerImages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe container images that are registered to the container service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContainerImages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe container images that are registered to the container service.
     */
    public final List<ContainerImage> containerImages() {
        return containerImages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerImages() ? containerImages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerImagesResponse)) {
            return false;
        }
        GetContainerImagesResponse other = (GetContainerImagesResponse) obj;
        return hasContainerImages() == other.hasContainerImages() && Objects.equals(containerImages(), other.containerImages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerImagesResponse")
                .add("ContainerImages", hasContainerImages() ? containerImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerImages":
            return Optional.ofNullable(clazz.cast(containerImages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerImagesResponse, T> g) {
        return obj -> g.apply((GetContainerImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContainerImagesResponse> {
        /**
         * <p>
         * An array of objects that describe container images that are registered to the container service.
         * </p>
         * 
         * @param containerImages
         *        An array of objects that describe container images that are registered to the container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImages(Collection<ContainerImage> containerImages);

        /**
         * <p>
         * An array of objects that describe container images that are registered to the container service.
         * </p>
         * 
         * @param containerImages
         *        An array of objects that describe container images that are registered to the container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImages(ContainerImage... containerImages);

        /**
         * <p>
         * An array of objects that describe container images that are registered to the container service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerImage>.Builder} avoiding the need
         * to create one manually via {@link List<ContainerImage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerImage>.Builder#build()} is called immediately and
         * its result is passed to {@link #containerImages(List<ContainerImage>)}.
         * 
         * @param containerImages
         *        a consumer that will call methods on {@link List<ContainerImage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerImages(List<ContainerImage>)
         */
        Builder containerImages(Consumer<ContainerImage.Builder>... containerImages);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContainerImage> containerImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerImagesResponse model) {
            super(model);
            containerImages(model.containerImages);
        }

        public final List<ContainerImage.Builder> getContainerImages() {
            List<ContainerImage.Builder> result = ContainerImageListCopier.copyToBuilder(this.containerImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder containerImages(Collection<ContainerImage> containerImages) {
            this.containerImages = ContainerImageListCopier.copy(containerImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(ContainerImage... containerImages) {
            containerImages(Arrays.asList(containerImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerImages(Consumer<ContainerImage.Builder>... containerImages) {
            containerImages(Stream.of(containerImages).map(c -> ContainerImage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setContainerImages(Collection<ContainerImage.BuilderImpl> containerImages) {
            this.containerImages = ContainerImageListCopier.copyFromBuilder(containerImages);
        }

        @Override
        public GetContainerImagesResponse build() {
            return new GetContainerImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
