/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutInstancePublicPortsRequest extends LightsailRequest implements
        ToCopyableBuilder<PutInstancePublicPortsRequest.Builder, PutInstancePublicPortsRequest> {
    private static final SdkField<List<PortInfo>> PORT_INFOS_FIELD = SdkField
            .<List<PortInfo>> builder(MarshallingType.LIST)
            .memberName("portInfos")
            .getter(getter(PutInstancePublicPortsRequest::portInfos))
            .setter(setter(Builder::portInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(PutInstancePublicPortsRequest::instanceName))
            .setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_INFOS_FIELD,
            INSTANCE_NAME_FIELD));

    private final List<PortInfo> portInfos;

    private final String instanceName;

    private PutInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfos = builder.portInfos;
        this.instanceName = builder.instanceName;
    }

    /**
     * Returns true if the PortInfos property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPortInfos() {
        return portInfos != null && !(portInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects to describe the ports to open for the specified instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortInfos()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects to describe the ports to open for the specified instance.
     */
    public final List<PortInfo> portInfos() {
        return portInfos;
    }

    /**
     * <p>
     * The name of the instance for which to open ports.
     * </p>
     * 
     * @return The name of the instance for which to open ports.
     */
    public final String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPortInfos() ? portInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInstancePublicPortsRequest)) {
            return false;
        }
        PutInstancePublicPortsRequest other = (PutInstancePublicPortsRequest) obj;
        return hasPortInfos() == other.hasPortInfos() && Objects.equals(portInfos(), other.portInfos())
                && Objects.equals(instanceName(), other.instanceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutInstancePublicPortsRequest").add("PortInfos", hasPortInfos() ? portInfos() : null)
                .add("InstanceName", instanceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portInfos":
            return Optional.ofNullable(clazz.cast(portInfos()));
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInstancePublicPortsRequest, T> g) {
        return obj -> g.apply((PutInstancePublicPortsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutInstancePublicPortsRequest> {
        /**
         * <p>
         * An array of objects to describe the ports to open for the specified instance.
         * </p>
         * 
         * @param portInfos
         *        An array of objects to describe the ports to open for the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(Collection<PortInfo> portInfos);

        /**
         * <p>
         * An array of objects to describe the ports to open for the specified instance.
         * </p>
         * 
         * @param portInfos
         *        An array of objects to describe the ports to open for the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfos(PortInfo... portInfos);

        /**
         * <p>
         * An array of objects to describe the ports to open for the specified instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortInfo>.Builder} avoiding the need to
         * create one manually via {@link List<PortInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #portInfos(List<PortInfo>)}.
         * 
         * @param portInfos
         *        a consumer that will call methods on {@link List<PortInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portInfos(List<PortInfo>)
         */
        Builder portInfos(Consumer<PortInfo.Builder>... portInfos);

        /**
         * <p>
         * The name of the instance for which to open ports.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance for which to open ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<PortInfo> portInfos = DefaultSdkAutoConstructList.getInstance();

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInstancePublicPortsRequest model) {
            super(model);
            portInfos(model.portInfos);
            instanceName(model.instanceName);
        }

        public final List<PortInfo.Builder> getPortInfos() {
            List<PortInfo.Builder> result = PortInfoListCopier.copyToBuilder(this.portInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder portInfos(Collection<PortInfo> portInfos) {
            this.portInfos = PortInfoListCopier.copy(portInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(PortInfo... portInfos) {
            portInfos(Arrays.asList(portInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portInfos(Consumer<PortInfo.Builder>... portInfos) {
            portInfos(Stream.of(portInfos).map(c -> PortInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortInfos(Collection<PortInfo.BuilderImpl> portInfos) {
            this.portInfos = PortInfoListCopier.copyFromBuilder(portInfos);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInstancePublicPortsRequest build() {
            return new PutInstancePublicPortsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
