/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStaticIpResponse extends LightsailResponse implements
        ToCopyableBuilder<GetStaticIpResponse.Builder, GetStaticIpResponse> {
    private static final SdkField<StaticIp> STATIC_IP_FIELD = SdkField.<StaticIp> builder(MarshallingType.SDK_POJO)
            .memberName("staticIp").getter(getter(GetStaticIpResponse::staticIp)).setter(setter(Builder::staticIp))
            .constructor(StaticIp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_IP_FIELD));

    private final StaticIp staticIp;

    private GetStaticIpResponse(BuilderImpl builder) {
        super(builder);
        this.staticIp = builder.staticIp;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the requested static IP.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the requested static IP.
     */
    public final StaticIp staticIp() {
        return staticIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(staticIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpResponse)) {
            return false;
        }
        GetStaticIpResponse other = (GetStaticIpResponse) obj;
        return Objects.equals(staticIp(), other.staticIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStaticIpResponse").add("StaticIp", staticIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "staticIp":
            return Optional.ofNullable(clazz.cast(staticIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStaticIpResponse, T> g) {
        return obj -> g.apply((GetStaticIpResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStaticIpResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the requested static IP.
         * </p>
         * 
         * @param staticIp
         *        An array of key-value pairs containing information about the requested static IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIp(StaticIp staticIp);

        /**
         * <p>
         * An array of key-value pairs containing information about the requested static IP.
         * </p>
         * This is a convenience that creates an instance of the {@link StaticIp.Builder} avoiding the need to create
         * one manually via {@link StaticIp#builder()}.
         *
         * When the {@link Consumer} completes, {@link StaticIp.Builder#build()} is called immediately and its result is
         * passed to {@link #staticIp(StaticIp)}.
         * 
         * @param staticIp
         *        a consumer that will call methods on {@link StaticIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticIp(StaticIp)
         */
        default Builder staticIp(Consumer<StaticIp.Builder> staticIp) {
            return staticIp(StaticIp.builder().applyMutation(staticIp).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private StaticIp staticIp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpResponse model) {
            super(model);
            staticIp(model.staticIp);
        }

        public final StaticIp.Builder getStaticIp() {
            return staticIp != null ? staticIp.toBuilder() : null;
        }

        @Override
        public final Builder staticIp(StaticIp staticIp) {
            this.staticIp = staticIp;
            return this;
        }

        public final void setStaticIp(StaticIp.BuilderImpl staticIp) {
            this.staticIp = staticIp != null ? staticIp.build() : null;
        }

        @Override
        public GetStaticIpResponse build() {
            return new GetStaticIpResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
