/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBucketRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateBucketRequest.Builder, CreateBucketRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(CreateBucketRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(CreateBucketRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateBucketRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_OBJECT_VERSIONING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableObjectVersioning").getter(getter(CreateBucketRequest::enableObjectVersioning))
            .setter(setter(Builder::enableObjectVersioning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableObjectVersioning").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUNDLE_ID_FIELD, TAGS_FIELD, ENABLE_OBJECT_VERSIONING_FIELD));

    private final String bucketName;

    private final String bundleId;

    private final List<Tag> tags;

    private final Boolean enableObjectVersioning;

    private CreateBucketRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.bundleId = builder.bundleId;
        this.tags = builder.tags;
        this.enableObjectVersioning = builder.enableObjectVersioning;
    }

    /**
     * <p>
     * The name for the bucket.
     * </p>
     * <p>
     * For more information about bucket names, see <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket
     * naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
     * </p>
     * 
     * @return The name for the bucket.</p>
     *         <p>
     *         For more information about bucket names, see <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail"
     *         >Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The ID of the bundle to use for the bucket.
     * </p>
     * <p>
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
     * </p>
     * <p>
     * Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
     * </p>
     * <p>
     * Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket is created.
     * </p>
     * 
     * @return The ID of the bundle to use for the bucket.</p>
     *         <p>
     *         A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
     *         </p>
     *         <p>
     *         Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
     *         </p>
     *         <p>
     *         Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket is created.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the bucket during creation.
     * </p>
     * <p>
     * Use the <a>TagResource</a> action to tag the bucket after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values to add to the bucket during creation.</p>
     *         <p>
     *         Use the <a>TagResource</a> action to tag the bucket after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to enable versioning of objects in the bucket.
     * </p>
     * <p>
     * For more information about versioning, see <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning"
     * >Enabling and suspending bucket object versioning in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer
     * Guide</i>.
     * </p>
     * 
     * @return A Boolean value that indicates whether to enable versioning of objects in the bucket.</p>
     *         <p>
     *         For more information about versioning, see <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning"
     *         >Enabling and suspending bucket object versioning in Amazon Lightsail</a> in the <i>Amazon Lightsail
     *         Developer Guide</i>.
     */
    public final Boolean enableObjectVersioning() {
        return enableObjectVersioning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableObjectVersioning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBucketRequest)) {
            return false;
        }
        CreateBucketRequest other = (CreateBucketRequest) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bundleId(), other.bundleId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(enableObjectVersioning(), other.enableObjectVersioning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBucketRequest").add("BucketName", bucketName()).add("BundleId", bundleId())
                .add("Tags", hasTags() ? tags() : null).add("EnableObjectVersioning", enableObjectVersioning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "enableObjectVersioning":
            return Optional.ofNullable(clazz.cast(enableObjectVersioning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBucketRequest, T> g) {
        return obj -> g.apply((CreateBucketRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBucketRequest> {
        /**
         * <p>
         * The name for the bucket.
         * </p>
         * <p>
         * For more information about bucket names, see <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail">Bucket
         * naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
         * </p>
         * 
         * @param bucketName
         *        The name for the bucket.</p>
         *        <p>
         *        For more information about bucket names, see <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail"
         *        >Bucket naming rules in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The ID of the bundle to use for the bucket.
         * </p>
         * <p>
         * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         * </p>
         * <p>
         * Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
         * </p>
         * <p>
         * Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket is created.
         * </p>
         * 
         * @param bundleId
         *        The ID of the bundle to use for the bucket.</p>
         *        <p>
         *        A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         *        </p>
         *        <p>
         *        Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
         *        </p>
         *        <p>
         *        Use the <a>UpdateBucketBundle</a> action to change the bundle after the bucket is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The tag keys and optional values to add to the bucket during creation.
         * </p>
         * <p>
         * Use the <a>TagResource</a> action to tag the bucket after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the bucket during creation.</p>
         *        <p>
         *        Use the <a>TagResource</a> action to tag the bucket after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the bucket during creation.
         * </p>
         * <p>
         * Use the <a>TagResource</a> action to tag the bucket after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the bucket during creation.</p>
         *        <p>
         *        Use the <a>TagResource</a> action to tag the bucket after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the bucket during creation.
         * </p>
         * <p>
         * Use the <a>TagResource</a> action to tag the bucket after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A Boolean value that indicates whether to enable versioning of objects in the bucket.
         * </p>
         * <p>
         * For more information about versioning, see <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning"
         * >Enabling and suspending bucket object versioning in Amazon Lightsail</a> in the <i>Amazon Lightsail
         * Developer Guide</i>.
         * </p>
         * 
         * @param enableObjectVersioning
         *        A Boolean value that indicates whether to enable versioning of objects in the bucket.</p>
         *        <p>
         *        For more information about versioning, see <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning"
         *        >Enabling and suspending bucket object versioning in Amazon Lightsail</a> in the <i>Amazon Lightsail
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableObjectVersioning(Boolean enableObjectVersioning);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String bucketName;

        private String bundleId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableObjectVersioning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBucketRequest model) {
            super(model);
            bucketName(model.bucketName);
            bundleId(model.bundleId);
            tags(model.tags);
            enableObjectVersioning(model.enableObjectVersioning);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableObjectVersioning() {
            return enableObjectVersioning;
        }

        @Override
        public final Builder enableObjectVersioning(Boolean enableObjectVersioning) {
            this.enableObjectVersioning = enableObjectVersioning;
            return this;
        }

        public final void setEnableObjectVersioning(Boolean enableObjectVersioning) {
            this.enableObjectVersioning = enableObjectVersioning;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBucketRequest build() {
            return new CreateBucketRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
