/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRelationalDatabaseSnapshotRequest.Builder, GetRelationalDatabaseSnapshotRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseSnapshotName")
            .getter(getter(GetRelationalDatabaseSnapshotRequest::relationalDatabaseSnapshotName))
            .setter(setter(Builder::relationalDatabaseSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshotName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD));

    private final String relationalDatabaseSnapshotName;

    private GetRelationalDatabaseSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseSnapshotName = builder.relationalDatabaseSnapshotName;
    }

    /**
     * <p>
     * The name of the database snapshot for which to get information.
     * </p>
     * 
     * @return The name of the database snapshot for which to get information.
     */
    public final String relationalDatabaseSnapshotName() {
        return relationalDatabaseSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseSnapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseSnapshotRequest)) {
            return false;
        }
        GetRelationalDatabaseSnapshotRequest other = (GetRelationalDatabaseSnapshotRequest) obj;
        return Objects.equals(relationalDatabaseSnapshotName(), other.relationalDatabaseSnapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabaseSnapshotRequest")
                .add("RelationalDatabaseSnapshotName", relationalDatabaseSnapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseSnapshotName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseSnapshotRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseSnapshotRequest> {
        /**
         * <p>
         * The name of the database snapshot for which to get information.
         * </p>
         * 
         * @param relationalDatabaseSnapshotName
         *        The name of the database snapshot for which to get information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseSnapshotRequest model) {
            super(model);
            relationalDatabaseSnapshotName(model.relationalDatabaseSnapshotName);
        }

        public final String getRelationalDatabaseSnapshotName() {
            return relationalDatabaseSnapshotName;
        }

        public final void setRelationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
        }

        @Override
        @Transient
        public final Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseSnapshotRequest build() {
            return new GetRelationalDatabaseSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
