/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseLogStreamsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabaseLogStreamsResponse.Builder, GetRelationalDatabaseLogStreamsResponse> {
    private static final SdkField<List<String>> LOG_STREAMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logStreams")
            .getter(getter(GetRelationalDatabaseLogStreamsResponse::logStreams))
            .setter(setter(Builder::logStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAMS_FIELD));

    private final List<String> logStreams;

    private GetRelationalDatabaseLogStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.logStreams = builder.logStreams;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogStreams property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogStreams() {
        return logStreams != null && !(logStreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object describing the result of your get relational database log streams request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogStreams} method.
     * </p>
     * 
     * @return An object describing the result of your get relational database log streams request.
     */
    public final List<String> logStreams() {
        return logStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogStreams() ? logStreams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogStreamsResponse)) {
            return false;
        }
        GetRelationalDatabaseLogStreamsResponse other = (GetRelationalDatabaseLogStreamsResponse) obj;
        return hasLogStreams() == other.hasLogStreams() && Objects.equals(logStreams(), other.logStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabaseLogStreamsResponse")
                .add("LogStreams", hasLogStreams() ? logStreams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logStreams":
            return Optional.ofNullable(clazz.cast(logStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogStreamsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseLogStreamsResponse> {
        /**
         * <p>
         * An object describing the result of your get relational database log streams request.
         * </p>
         * 
         * @param logStreams
         *        An object describing the result of your get relational database log streams request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(Collection<String> logStreams);

        /**
         * <p>
         * An object describing the result of your get relational database log streams request.
         * </p>
         * 
         * @param logStreams
         *        An object describing the result of your get relational database log streams request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(String... logStreams);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<String> logStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogStreamsResponse model) {
            super(model);
            logStreams(model.logStreams);
        }

        public final Collection<String> getLogStreams() {
            if (logStreams instanceof SdkAutoConstructList) {
                return null;
            }
            return logStreams;
        }

        public final void setLogStreams(Collection<String> logStreams) {
            this.logStreams = StringListCopier.copy(logStreams);
        }

        @Override
        @Transient
        public final Builder logStreams(Collection<String> logStreams) {
            this.logStreams = StringListCopier.copy(logStreams);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logStreams(String... logStreams) {
            logStreams(Arrays.asList(logStreams));
            return this;
        }

        @Override
        public GetRelationalDatabaseLogStreamsResponse build() {
            return new GetRelationalDatabaseLogStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
