/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a domain recordset entry.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainEntry implements SdkPojo, Serializable, ToCopyableBuilder<DomainEntry.Builder, DomainEntry> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DomainEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DomainEntry::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(DomainEntry::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<Boolean> IS_ALIAS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAlias").getter(getter(DomainEntry::isAlias)).setter(setter(Builder::isAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAlias").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DomainEntry::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("options")
            .getter(getter(DomainEntry::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            TARGET_FIELD, IS_ALIAS_FIELD, TYPE_FIELD, OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String target;

    private final Boolean isAlias;

    private final String type;

    private final Map<String, String> options;

    private DomainEntry(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.target = builder.target;
        this.isAlias = builder.isAlias;
        this.type = builder.type;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the domain recordset entry.
     * </p>
     * 
     * @return The ID of the domain recordset entry.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
     * <code>ns-111.awsdns-22.com.</code>).
     * </p>
     * <p>
     * For Lightsail load balancers, the value looks like
     * <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For Lightsail distributions,
     * the value looks like <code>exampled1182ne.cloudfront.net</code>. For Lightsail container services, the value
     * looks like <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to also set
     * <code>isAlias</code> to <code>true</code> when setting up an A record for a Lightsail load balancer,
     * distribution, or container service.
     * </p>
     * 
     * @return The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
     *         <code>ns-111.awsdns-22.com.</code>).</p>
     *         <p>
     *         For Lightsail load balancers, the value looks like
     *         <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For Lightsail
     *         distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>. For Lightsail container
     *         services, the value looks like
     *         <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to also set
     *         <code>isAlias</code> to <code>true</code> when setting up an A record for a Lightsail load balancer,
     *         distribution, or container service.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * When <code>true</code>, specifies whether the domain entry is an alias used by the Lightsail load balancer. You
     * can include an alias (A type) record in your request, which points to a load balancer DNS name and routes traffic
     * to your load balancer.
     * </p>
     * 
     * @return When <code>true</code>, specifies whether the domain entry is an alias used by the Lightsail load
     *         balancer. You can include an alias (A type) record in your request, which points to a load balancer DNS
     *         name and routes traffic to your load balancer.
     */
    public final Boolean isAlias() {
        return isAlias;
    }

    /**
     * <p>
     * The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name (CNAME), mail
     * exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     * </p>
     * <p>
     * The following domain entry types can be used:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>A</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AAAA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CNAME</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MX</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SOA</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SRV</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TXT</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name (CNAME),
     *         mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text
     *         (TXT).</p>
     *         <p>
     *         The following domain entry types can be used:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>A</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AAAA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CNAME</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MX</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SOA</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SRV</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TXT</code>
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * Returns true if the Options property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     *
     * @deprecated
     */
    @Deprecated
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * (Deprecated) The options for the domain entry.
     * </p>
     * <note>
     * <p>
     * In releases prior to November 29, 2017, this parameter was not included in the API response. It is now
     * deprecated.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Deprecated) The options for the domain entry.</p> <note>
     *         <p>
     *         In releases prior to November 29, 2017, this parameter was not included in the API response. It is now
     *         deprecated.
     *         </p>
     * @deprecated
     */
    @Deprecated
    public final Map<String, String> options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(isAlias());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainEntry)) {
            return false;
        }
        DomainEntry other = (DomainEntry) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(target(), other.target()) && Objects.equals(isAlias(), other.isAlias())
                && Objects.equals(type(), other.type()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainEntry").add("Id", id()).add("Name", name()).add("Target", target())
                .add("IsAlias", isAlias()).add("Type", type()).add("Options", hasOptions() ? options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "isAlias":
            return Optional.ofNullable(clazz.cast(isAlias()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainEntry, T> g) {
        return obj -> g.apply((DomainEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainEntry> {
        /**
         * <p>
         * The ID of the domain recordset entry.
         * </p>
         * 
         * @param id
         *        The ID of the domain recordset entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param name
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
         * <code>ns-111.awsdns-22.com.</code>).
         * </p>
         * <p>
         * For Lightsail load balancers, the value looks like
         * <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For Lightsail
         * distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>. For Lightsail container
         * services, the value looks like
         * <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to also set
         * <code>isAlias</code> to <code>true</code> when setting up an A record for a Lightsail load balancer,
         * distribution, or container service.
         * </p>
         * 
         * @param target
         *        The target IP address (e.g., <code>192.0.2.0</code>), or AWS name server (e.g.,
         *        <code>ns-111.awsdns-22.com.</code>).</p>
         *        <p>
         *        For Lightsail load balancers, the value looks like
         *        <code>ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com</code>. For Lightsail
         *        distributions, the value looks like <code>exampled1182ne.cloudfront.net</code>. For Lightsail
         *        container services, the value looks like
         *        <code>container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com</code>. Be sure to also set
         *        <code>isAlias</code> to <code>true</code> when setting up an A record for a Lightsail load balancer,
         *        distribution, or container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * When <code>true</code>, specifies whether the domain entry is an alias used by the Lightsail load balancer.
         * You can include an alias (A type) record in your request, which points to a load balancer DNS name and routes
         * traffic to your load balancer.
         * </p>
         * 
         * @param isAlias
         *        When <code>true</code>, specifies whether the domain entry is an alias used by the Lightsail load
         *        balancer. You can include an alias (A type) record in your request, which points to a load balancer
         *        DNS name and routes traffic to your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAlias(Boolean isAlias);

        /**
         * <p>
         * The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name (CNAME), mail
         * exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
         * </p>
         * <p>
         * The following domain entry types can be used:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>A</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AAAA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CNAME</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MX</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SOA</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SRV</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TXT</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name
         *        (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or
         *        text (TXT).</p>
         *        <p>
         *        The following domain entry types can be used:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>A</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AAAA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CNAME</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MX</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SOA</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SRV</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TXT</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * (Deprecated) The options for the domain entry.
         * </p>
         * <note>
         * <p>
         * In releases prior to November 29, 2017, this parameter was not included in the API response. It is now
         * deprecated.
         * </p>
         * </note>
         * 
         * @param options
         *        (Deprecated) The options for the domain entry.</p> <note>
         *        <p>
         *        In releases prior to November 29, 2017, this parameter was not included in the API response. It is now
         *        deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder options(Map<String, String> options);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String target;

        private Boolean isAlias;

        private String type;

        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainEntry model) {
            id(model.id);
            name(model.name);
            target(model.target);
            isAlias(model.isAlias);
            type(model.type);
            options(model.options);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final Boolean getIsAlias() {
            return isAlias;
        }

        @Override
        public final Builder isAlias(Boolean isAlias) {
            this.isAlias = isAlias;
            return this;
        }

        public final void setIsAlias(Boolean isAlias) {
            this.isAlias = isAlias;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Deprecated
        public final Map<String, String> getOptions() {
            if (options instanceof SdkAutoConstructMap) {
                return null;
            }
            return options;
        }

        @Override
        @Deprecated
        public final Builder options(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
            return this;
        }

        @Deprecated
        public final void setOptions(Map<String, String> options) {
            this.options = DomainEntryOptionsCopier.copy(options);
        }

        @Override
        public DomainEntry build() {
            return new DomainEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
