/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostKeyAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostKeyAttributes> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("algorithm").getter(HostKeyAttributes.getter(HostKeyAttributes::algorithm)).setter(HostKeyAttributes.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicKey").getter(HostKeyAttributes.getter(HostKeyAttributes::publicKey)).setter(HostKeyAttributes.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKey").build()}).build();
    private static final SdkField<Instant> WITNESSED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("witnessedAt").getter(HostKeyAttributes.getter(HostKeyAttributes::witnessedAt)).setter(HostKeyAttributes.setter(Builder::witnessedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("witnessedAt").build()}).build();
    private static final SdkField<String> FINGERPRINT_SHA1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fingerprintSHA1").getter(HostKeyAttributes.getter(HostKeyAttributes::fingerprintSHA1)).setter(HostKeyAttributes.setter(Builder::fingerprintSHA1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fingerprintSHA1").build()}).build();
    private static final SdkField<String> FINGERPRINT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fingerprintSHA256").getter(HostKeyAttributes.getter(HostKeyAttributes::fingerprintSHA256)).setter(HostKeyAttributes.setter(Builder::fingerprintSHA256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fingerprintSHA256").build()}).build();
    private static final SdkField<Instant> NOT_VALID_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidBefore").getter(HostKeyAttributes.getter(HostKeyAttributes::notValidBefore)).setter(HostKeyAttributes.setter(Builder::notValidBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidBefore").build()}).build();
    private static final SdkField<Instant> NOT_VALID_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidAfter").getter(HostKeyAttributes.getter(HostKeyAttributes::notValidAfter)).setter(HostKeyAttributes.setter(Builder::notValidAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, PUBLIC_KEY_FIELD, WITNESSED_AT_FIELD, FINGERPRINT_SHA1_FIELD, FINGERPRINT_SHA256_FIELD, NOT_VALID_BEFORE_FIELD, NOT_VALID_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String publicKey;
    private final Instant witnessedAt;
    private final String fingerprintSHA1;
    private final String fingerprintSHA256;
    private final Instant notValidBefore;
    private final Instant notValidAfter;

    private HostKeyAttributes(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.publicKey = builder.publicKey;
        this.witnessedAt = builder.witnessedAt;
        this.fingerprintSHA1 = builder.fingerprintSHA1;
        this.fingerprintSHA256 = builder.fingerprintSHA256;
        this.notValidBefore = builder.notValidBefore;
        this.notValidAfter = builder.notValidAfter;
    }

    public final String algorithm() {
        return this.algorithm;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public final Instant witnessedAt() {
        return this.witnessedAt;
    }

    public final String fingerprintSHA1() {
        return this.fingerprintSHA1;
    }

    public final String fingerprintSHA256() {
        return this.fingerprintSHA256;
    }

    public final Instant notValidBefore() {
        return this.notValidBefore;
    }

    public final Instant notValidAfter() {
        return this.notValidAfter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.witnessedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprintSHA1());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprintSHA256());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidAfter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostKeyAttributes)) {
            return false;
        }
        HostKeyAttributes other = (HostKeyAttributes)obj;
        return Objects.equals(this.algorithm(), other.algorithm()) && Objects.equals(this.publicKey(), other.publicKey()) && Objects.equals(this.witnessedAt(), other.witnessedAt()) && Objects.equals(this.fingerprintSHA1(), other.fingerprintSHA1()) && Objects.equals(this.fingerprintSHA256(), other.fingerprintSHA256()) && Objects.equals(this.notValidBefore(), other.notValidBefore()) && Objects.equals(this.notValidAfter(), other.notValidAfter());
    }

    public final String toString() {
        return ToString.builder((String)"HostKeyAttributes").add("Algorithm", (Object)this.algorithm()).add("PublicKey", (Object)this.publicKey()).add("WitnessedAt", (Object)this.witnessedAt()).add("FingerprintSHA1", (Object)this.fingerprintSHA1()).add("FingerprintSHA256", (Object)this.fingerprintSHA256()).add("NotValidBefore", (Object)this.notValidBefore()).add("NotValidAfter", (Object)this.notValidAfter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithm()));
            }
            case "publicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
            case "witnessedAt": {
                return Optional.ofNullable(clazz.cast(this.witnessedAt()));
            }
            case "fingerprintSHA1": {
                return Optional.ofNullable(clazz.cast(this.fingerprintSHA1()));
            }
            case "fingerprintSHA256": {
                return Optional.ofNullable(clazz.cast(this.fingerprintSHA256()));
            }
            case "notValidBefore": {
                return Optional.ofNullable(clazz.cast(this.notValidBefore()));
            }
            case "notValidAfter": {
                return Optional.ofNullable(clazz.cast(this.notValidAfter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostKeyAttributes, T> g) {
        return obj -> g.apply((HostKeyAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String publicKey;
        private Instant witnessedAt;
        private String fingerprintSHA1;
        private String fingerprintSHA256;
        private Instant notValidBefore;
        private Instant notValidAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(HostKeyAttributes model) {
            this.algorithm(model.algorithm);
            this.publicKey(model.publicKey);
            this.witnessedAt(model.witnessedAt);
            this.fingerprintSHA1(model.fingerprintSHA1);
            this.fingerprintSHA256(model.fingerprintSHA256);
            this.notValidBefore(model.notValidBefore);
            this.notValidAfter(model.notValidAfter);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        @Transient
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        @Transient
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Instant getWitnessedAt() {
            return this.witnessedAt;
        }

        public final void setWitnessedAt(Instant witnessedAt) {
            this.witnessedAt = witnessedAt;
        }

        @Override
        @Transient
        public final Builder witnessedAt(Instant witnessedAt) {
            this.witnessedAt = witnessedAt;
            return this;
        }

        public final String getFingerprintSHA1() {
            return this.fingerprintSHA1;
        }

        public final void setFingerprintSHA1(String fingerprintSHA1) {
            this.fingerprintSHA1 = fingerprintSHA1;
        }

        @Override
        @Transient
        public final Builder fingerprintSHA1(String fingerprintSHA1) {
            this.fingerprintSHA1 = fingerprintSHA1;
            return this;
        }

        public final String getFingerprintSHA256() {
            return this.fingerprintSHA256;
        }

        public final void setFingerprintSHA256(String fingerprintSHA256) {
            this.fingerprintSHA256 = fingerprintSHA256;
        }

        @Override
        @Transient
        public final Builder fingerprintSHA256(String fingerprintSHA256) {
            this.fingerprintSHA256 = fingerprintSHA256;
            return this;
        }

        public final Instant getNotValidBefore() {
            return this.notValidBefore;
        }

        public final void setNotValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
        }

        @Override
        @Transient
        public final Builder notValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
            return this;
        }

        public final Instant getNotValidAfter() {
            return this.notValidAfter;
        }

        public final void setNotValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
        }

        @Override
        @Transient
        public final Builder notValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
            return this;
        }

        public HostKeyAttributes build() {
            return new HostKeyAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostKeyAttributes> {
        public Builder algorithm(String var1);

        public Builder publicKey(String var1);

        public Builder witnessedAt(Instant var1);

        public Builder fingerprintSHA1(String var1);

        public Builder fingerprintSHA256(String var1);

        public Builder notValidBefore(Instant var1);

        public Builder notValidAfter(Instant var1);
    }
}

