/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the request headers that a Lightsail distribution bases caching on.
 * </p>
 * <p>
 * For the headers that you specify, your distribution caches separate versions of the specified content based on the
 * header values in viewer requests. For example, suppose viewer requests for <code>logo.jpg</code> contain a custom
 * <code>product</code> header that has a value of either <code>acme</code> or <code>apex</code>, and you configure your
 * distribution to cache your content based on values in the <code>product</code> header. Your distribution forwards the
 * <code>product</code> header to the origin and caches the response from the origin once for each header value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeaderObject implements SdkPojo, Serializable, ToCopyableBuilder<HeaderObject.Builder, HeaderObject> {
    private static final SdkField<String> OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("option")
            .getter(getter(HeaderObject::optionAsString)).setter(setter(Builder::option))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("option").build()).build();

    private static final SdkField<List<String>> HEADERS_ALLOW_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("headersAllowList")
            .getter(getter(HeaderObject::headersAllowListAsStrings))
            .setter(setter(Builder::headersAllowListWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headersAllowList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_FIELD,
            HEADERS_ALLOW_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String option;

    private final List<String> headersAllowList;

    private HeaderObject(BuilderImpl builder) {
        this.option = builder.option;
        this.headersAllowList = builder.headersAllowList;
    }

    /**
     * <p>
     * The headers that you want your distribution to forward to your origin and base caching on.
     * </p>
     * <p>
     * You can configure your distribution to do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>all</code> </b> - Forward all headers to your origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>none</code> </b> - Forward only the default headers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>allow-list</code> </b> - Forward only the headers you specify using the <code>headersAllowList</code>
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #option} will
     * return {@link ForwardValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optionAsString}.
     * </p>
     * 
     * @return The headers that you want your distribution to forward to your origin and base caching on.</p>
     *         <p>
     *         You can configure your distribution to do one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>all</code> </b> - Forward all headers to your origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>none</code> </b> - Forward only the default headers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
     *         <code>headersAllowList</code> parameter.
     *         </p>
     *         </li>
     * @see ForwardValues
     */
    public final ForwardValues option() {
        return ForwardValues.fromValue(option);
    }

    /**
     * <p>
     * The headers that you want your distribution to forward to your origin and base caching on.
     * </p>
     * <p>
     * You can configure your distribution to do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>all</code> </b> - Forward all headers to your origin.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>none</code> </b> - Forward only the default headers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>allow-list</code> </b> - Forward only the headers you specify using the <code>headersAllowList</code>
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #option} will
     * return {@link ForwardValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #optionAsString}.
     * </p>
     * 
     * @return The headers that you want your distribution to forward to your origin and base caching on.</p>
     *         <p>
     *         You can configure your distribution to do one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>all</code> </b> - Forward all headers to your origin.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>none</code> </b> - Forward only the default headers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
     *         <code>headersAllowList</code> parameter.
     *         </p>
     *         </li>
     * @see ForwardValues
     */
    public final String optionAsString() {
        return option;
    }

    /**
     * <p>
     * The specific headers to forward to your distribution's origin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeadersAllowList} method.
     * </p>
     * 
     * @return The specific headers to forward to your distribution's origin.
     */
    public final List<HeaderEnum> headersAllowList() {
        return HeaderForwardListCopier.copyStringToEnum(headersAllowList);
    }

    /**
     * For responses, this returns true if the service returned a value for the HeadersAllowList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeadersAllowList() {
        return headersAllowList != null && !(headersAllowList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific headers to forward to your distribution's origin.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeadersAllowList} method.
     * </p>
     * 
     * @return The specific headers to forward to your distribution's origin.
     */
    public final List<String> headersAllowListAsStrings() {
        return headersAllowList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(optionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeadersAllowList() ? headersAllowListAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderObject)) {
            return false;
        }
        HeaderObject other = (HeaderObject) obj;
        return Objects.equals(optionAsString(), other.optionAsString()) && hasHeadersAllowList() == other.hasHeadersAllowList()
                && Objects.equals(headersAllowListAsStrings(), other.headersAllowListAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeaderObject").add("Option", optionAsString())
                .add("HeadersAllowList", hasHeadersAllowList() ? headersAllowListAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "option":
            return Optional.ofNullable(clazz.cast(optionAsString()));
        case "headersAllowList":
            return Optional.ofNullable(clazz.cast(headersAllowListAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HeaderObject, T> g) {
        return obj -> g.apply((HeaderObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeaderObject> {
        /**
         * <p>
         * The headers that you want your distribution to forward to your origin and base caching on.
         * </p>
         * <p>
         * You can configure your distribution to do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>all</code> </b> - Forward all headers to your origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>none</code> </b> - Forward only the default headers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
         * <code>headersAllowList</code> parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param option
         *        The headers that you want your distribution to forward to your origin and base caching on.</p>
         *        <p>
         *        You can configure your distribution to do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>all</code> </b> - Forward all headers to your origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>none</code> </b> - Forward only the default headers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
         *        <code>headersAllowList</code> parameter.
         *        </p>
         *        </li>
         * @see ForwardValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardValues
         */
        Builder option(String option);

        /**
         * <p>
         * The headers that you want your distribution to forward to your origin and base caching on.
         * </p>
         * <p>
         * You can configure your distribution to do one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>all</code> </b> - Forward all headers to your origin.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>none</code> </b> - Forward only the default headers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
         * <code>headersAllowList</code> parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param option
         *        The headers that you want your distribution to forward to your origin and base caching on.</p>
         *        <p>
         *        You can configure your distribution to do one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>all</code> </b> - Forward all headers to your origin.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>none</code> </b> - Forward only the default headers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>allow-list</code> </b> - Forward only the headers you specify using the
         *        <code>headersAllowList</code> parameter.
         *        </p>
         *        </li>
         * @see ForwardValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ForwardValues
         */
        Builder option(ForwardValues option);

        /**
         * <p>
         * The specific headers to forward to your distribution's origin.
         * </p>
         * 
         * @param headersAllowList
         *        The specific headers to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersAllowListWithStrings(Collection<String> headersAllowList);

        /**
         * <p>
         * The specific headers to forward to your distribution's origin.
         * </p>
         * 
         * @param headersAllowList
         *        The specific headers to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersAllowListWithStrings(String... headersAllowList);

        /**
         * <p>
         * The specific headers to forward to your distribution's origin.
         * </p>
         * 
         * @param headersAllowList
         *        The specific headers to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersAllowList(Collection<HeaderEnum> headersAllowList);

        /**
         * <p>
         * The specific headers to forward to your distribution's origin.
         * </p>
         * 
         * @param headersAllowList
         *        The specific headers to forward to your distribution's origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersAllowList(HeaderEnum... headersAllowList);
    }

    static final class BuilderImpl implements Builder {
        private String option;

        private List<String> headersAllowList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderObject model) {
            option(model.option);
            headersAllowListWithStrings(model.headersAllowList);
        }

        public final String getOption() {
            return option;
        }

        public final void setOption(String option) {
            this.option = option;
        }

        @Override
        @Transient
        public final Builder option(String option) {
            this.option = option;
            return this;
        }

        @Override
        @Transient
        public final Builder option(ForwardValues option) {
            this.option(option == null ? null : option.toString());
            return this;
        }

        public final Collection<String> getHeadersAllowList() {
            if (headersAllowList instanceof SdkAutoConstructList) {
                return null;
            }
            return headersAllowList;
        }

        public final void setHeadersAllowList(Collection<String> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copy(headersAllowList);
        }

        @Override
        @Transient
        public final Builder headersAllowListWithStrings(Collection<String> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copy(headersAllowList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headersAllowListWithStrings(String... headersAllowList) {
            headersAllowListWithStrings(Arrays.asList(headersAllowList));
            return this;
        }

        @Override
        @Transient
        public final Builder headersAllowList(Collection<HeaderEnum> headersAllowList) {
            this.headersAllowList = HeaderForwardListCopier.copyEnumToString(headersAllowList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headersAllowList(HeaderEnum... headersAllowList) {
            headersAllowList(Arrays.asList(headersAllowList));
            return this;
        }

        @Override
        public HeaderObject build() {
            return new HeaderObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
