/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterContainerImageRequest extends LightsailRequest implements
        ToCopyableBuilder<RegisterContainerImageRequest.Builder, RegisterContainerImageRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(RegisterContainerImageRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(RegisterContainerImageRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("digest")
            .getter(getter(RegisterContainerImageRequest::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            LABEL_FIELD, DIGEST_FIELD));

    private final String serviceName;

    private final String label;

    private final String digest;

    private RegisterContainerImageRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.label = builder.label;
        this.digest = builder.digest;
    }

    /**
     * <p>
     * The name of the container service for which to register a container image.
     * </p>
     * 
     * @return The name of the container service for which to register a container image.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The label for the container image when it's registered to the container service.
     * </p>
     * <p>
     * Use a descriptive label that you can use to track the different versions of your registered container images.
     * </p>
     * <p>
     * Use the <code>GetContainerImages</code> action to return the container images registered to a Lightsail container
     * service. The label is the <code>&lt;imagelabel&gt;</code> portion of the following image name example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>:container-service-1.&lt;imagelabel&gt;.1</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the name of your container service is <code>mycontainerservice</code>, and the label that you specify is
     * <code>mystaticwebsite</code>, then the name of the registered container image will be
     * <code>:mycontainerservice.mystaticwebsite.1</code>.
     * </p>
     * <p>
     * The number at the end of these image name examples represents the version of the registered container image. If
     * you push and register another container image to the same Lightsail container service, with the same label, then
     * the version number for the new registered container image will be <code>2</code>. If you push and register
     * another container image, the version number will be <code>3</code>, and so on.
     * </p>
     * 
     * @return The label for the container image when it's registered to the container service.</p>
     *         <p>
     *         Use a descriptive label that you can use to track the different versions of your registered container
     *         images.
     *         </p>
     *         <p>
     *         Use the <code>GetContainerImages</code> action to return the container images registered to a Lightsail
     *         container service. The label is the <code>&lt;imagelabel&gt;</code> portion of the following image name
     *         example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>:container-service-1.&lt;imagelabel&gt;.1</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the name of your container service is <code>mycontainerservice</code>, and the label that you specify
     *         is <code>mystaticwebsite</code>, then the name of the registered container image will be
     *         <code>:mycontainerservice.mystaticwebsite.1</code>.
     *         </p>
     *         <p>
     *         The number at the end of these image name examples represents the version of the registered container
     *         image. If you push and register another container image to the same Lightsail container service, with the
     *         same label, then the version number for the new registered container image will be <code>2</code>. If you
     *         push and register another container image, the version number will be <code>3</code>, and so on.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The digest of the container image to be registered.
     * </p>
     * 
     * @return The digest of the container image to be registered.
     */
    public final String digest() {
        return digest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerImageRequest)) {
            return false;
        }
        RegisterContainerImageRequest other = (RegisterContainerImageRequest) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(label(), other.label())
                && Objects.equals(digest(), other.digest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterContainerImageRequest").add("ServiceName", serviceName()).add("Label", label())
                .add("Digest", digest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "digest":
            return Optional.ofNullable(clazz.cast(digest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterContainerImageRequest, T> g) {
        return obj -> g.apply((RegisterContainerImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterContainerImageRequest> {
        /**
         * <p>
         * The name of the container service for which to register a container image.
         * </p>
         * 
         * @param serviceName
         *        The name of the container service for which to register a container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The label for the container image when it's registered to the container service.
         * </p>
         * <p>
         * Use a descriptive label that you can use to track the different versions of your registered container images.
         * </p>
         * <p>
         * Use the <code>GetContainerImages</code> action to return the container images registered to a Lightsail
         * container service. The label is the <code>&lt;imagelabel&gt;</code> portion of the following image name
         * example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>:container-service-1.&lt;imagelabel&gt;.1</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the name of your container service is <code>mycontainerservice</code>, and the label that you specify is
         * <code>mystaticwebsite</code>, then the name of the registered container image will be
         * <code>:mycontainerservice.mystaticwebsite.1</code>.
         * </p>
         * <p>
         * The number at the end of these image name examples represents the version of the registered container image.
         * If you push and register another container image to the same Lightsail container service, with the same
         * label, then the version number for the new registered container image will be <code>2</code>. If you push and
         * register another container image, the version number will be <code>3</code>, and so on.
         * </p>
         * 
         * @param label
         *        The label for the container image when it's registered to the container service.</p>
         *        <p>
         *        Use a descriptive label that you can use to track the different versions of your registered container
         *        images.
         *        </p>
         *        <p>
         *        Use the <code>GetContainerImages</code> action to return the container images registered to a
         *        Lightsail container service. The label is the <code>&lt;imagelabel&gt;</code> portion of the following
         *        image name example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>:container-service-1.&lt;imagelabel&gt;.1</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the name of your container service is <code>mycontainerservice</code>, and the label that you
         *        specify is <code>mystaticwebsite</code>, then the name of the registered container image will be
         *        <code>:mycontainerservice.mystaticwebsite.1</code>.
         *        </p>
         *        <p>
         *        The number at the end of these image name examples represents the version of the registered container
         *        image. If you push and register another container image to the same Lightsail container service, with
         *        the same label, then the version number for the new registered container image will be <code>2</code>.
         *        If you push and register another container image, the version number will be <code>3</code>, and so
         *        on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The digest of the container image to be registered.
         * </p>
         * 
         * @param digest
         *        The digest of the container image to be registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String serviceName;

        private String label;

        private String digest;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterContainerImageRequest model) {
            super(model);
            serviceName(model.serviceName);
            label(model.label);
            digest(model.digest);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        @Transient
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        @Transient
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterContainerImageRequest build() {
            return new RegisterContainerImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
