/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a database snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationalDatabaseSnapshot implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationalDatabaseSnapshot.Builder, RelationalDatabaseSnapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RelationalDatabaseSnapshot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RelationalDatabaseSnapshot::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportCode").getter(getter(RelationalDatabaseSnapshot::supportCode))
            .setter(setter(Builder::supportCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(RelationalDatabaseSnapshot::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(RelationalDatabaseSnapshot::location)).setter(setter(Builder::location))
            .constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(RelationalDatabaseSnapshot::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(RelationalDatabaseSnapshot::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(RelationalDatabaseSnapshot::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(RelationalDatabaseSnapshot::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(RelationalDatabaseSnapshot::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(RelationalDatabaseSnapshot::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> FROM_RELATIONAL_DATABASE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("fromRelationalDatabaseName")
            .getter(getter(RelationalDatabaseSnapshot::fromRelationalDatabaseName))
            .setter(setter(Builder::fromRelationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseName").build())
            .build();

    private static final SdkField<String> FROM_RELATIONAL_DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromRelationalDatabaseArn").getter(getter(RelationalDatabaseSnapshot::fromRelationalDatabaseArn))
            .setter(setter(Builder::fromRelationalDatabaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseArn").build())
            .build();

    private static final SdkField<String> FROM_RELATIONAL_DATABASE_BUNDLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("fromRelationalDatabaseBundleId")
            .getter(getter(RelationalDatabaseSnapshot::fromRelationalDatabaseBundleId))
            .setter(setter(Builder::fromRelationalDatabaseBundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseBundleId")
                    .build()).build();

    private static final SdkField<String> FROM_RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("fromRelationalDatabaseBlueprintId")
            .getter(getter(RelationalDatabaseSnapshot::fromRelationalDatabaseBlueprintId))
            .setter(setter(Builder::fromRelationalDatabaseBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromRelationalDatabaseBlueprintId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, ENGINE_FIELD,
            ENGINE_VERSION_FIELD, SIZE_IN_GB_FIELD, STATE_FIELD, FROM_RELATIONAL_DATABASE_NAME_FIELD,
            FROM_RELATIONAL_DATABASE_ARN_FIELD, FROM_RELATIONAL_DATABASE_BUNDLE_ID_FIELD,
            FROM_RELATIONAL_DATABASE_BLUEPRINT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final List<Tag> tags;

    private final String engine;

    private final String engineVersion;

    private final Integer sizeInGb;

    private final String state;

    private final String fromRelationalDatabaseName;

    private final String fromRelationalDatabaseArn;

    private final String fromRelationalDatabaseBundleId;

    private final String fromRelationalDatabaseBlueprintId;

    private RelationalDatabaseSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.fromRelationalDatabaseName = builder.fromRelationalDatabaseName;
        this.fromRelationalDatabaseArn = builder.fromRelationalDatabaseArn;
        this.fromRelationalDatabaseBundleId = builder.fromRelationalDatabaseBundleId;
        this.fromRelationalDatabaseBlueprintId = builder.fromRelationalDatabaseBlueprintId;
    }

    /**
     * <p>
     * The name of the database snapshot.
     * </p>
     * 
     * @return The name of the database snapshot.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the database snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the database snapshot.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code for the database snapshot. Include this code in your email to support when you have questions
     * about a database snapshot in Lightsail. This code enables our support team to look up your Lightsail information
     * more easily.
     * </p>
     * 
     * @return The support code for the database snapshot. Include this code in your email to support when you have
     *         questions about a database snapshot in Lightsail. This code enables our support team to look up your
     *         Lightsail information more easily.
     */
    public final String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the database snapshot was created.
     * </p>
     * 
     * @return The timestamp when the database snapshot was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Region name and Availability Zone where the database snapshot is located.
     * </p>
     * 
     * @return The Region name and Availability Zone where the database snapshot is located.
     */
    public final ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The Lightsail resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail Developer
     * Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values for the resource. For more information about tags in Lightsail, see the
     *         <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
     *         Developer Guide</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The software of the database snapshot (for example, <code>MySQL</code>)
     * </p>
     * 
     * @return The software of the database snapshot (for example, <code>MySQL</code>)
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The database engine version for the database snapshot (for example, <code>5.7.23</code>).
     * </p>
     * 
     * @return The database engine version for the database snapshot (for example, <code>5.7.23</code>).
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The size of the disk in GB (for example, <code>32</code>) for the database snapshot.
     * </p>
     * 
     * @return The size of the disk in GB (for example, <code>32</code>) for the database snapshot.
     */
    public final Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * <p>
     * The state of the database snapshot.
     * </p>
     * 
     * @return The state of the database snapshot.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The name of the source database from which the database snapshot was created.
     * </p>
     * 
     * @return The name of the source database from which the database snapshot was created.
     */
    public final String fromRelationalDatabaseName() {
        return fromRelationalDatabaseName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
     */
    public final String fromRelationalDatabaseArn() {
        return fromRelationalDatabaseArn;
    }

    /**
     * <p>
     * The bundle ID of the database from which the database snapshot was created.
     * </p>
     * 
     * @return The bundle ID of the database from which the database snapshot was created.
     */
    public final String fromRelationalDatabaseBundleId() {
        return fromRelationalDatabaseBundleId;
    }

    /**
     * <p>
     * The blueprint ID of the database from which the database snapshot was created. A blueprint describes the major
     * engine version of a database.
     * </p>
     * 
     * @return The blueprint ID of the database from which the database snapshot was created. A blueprint describes the
     *         major engine version of a database.
     */
    public final String fromRelationalDatabaseBlueprintId() {
        return fromRelationalDatabaseBlueprintId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(fromRelationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(fromRelationalDatabaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(fromRelationalDatabaseBundleId());
        hashCode = 31 * hashCode + Objects.hashCode(fromRelationalDatabaseBlueprintId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseSnapshot)) {
            return false;
        }
        RelationalDatabaseSnapshot other = (RelationalDatabaseSnapshot) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(sizeInGb(), other.sizeInGb())
                && Objects.equals(state(), other.state())
                && Objects.equals(fromRelationalDatabaseName(), other.fromRelationalDatabaseName())
                && Objects.equals(fromRelationalDatabaseArn(), other.fromRelationalDatabaseArn())
                && Objects.equals(fromRelationalDatabaseBundleId(), other.fromRelationalDatabaseBundleId())
                && Objects.equals(fromRelationalDatabaseBlueprintId(), other.fromRelationalDatabaseBlueprintId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationalDatabaseSnapshot").add("Name", name()).add("Arn", arn())
                .add("SupportCode", supportCode()).add("CreatedAt", createdAt()).add("Location", location())
                .add("ResourceType", resourceTypeAsString()).add("Tags", hasTags() ? tags() : null).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("SizeInGb", sizeInGb()).add("State", state())
                .add("FromRelationalDatabaseName", fromRelationalDatabaseName())
                .add("FromRelationalDatabaseArn", fromRelationalDatabaseArn())
                .add("FromRelationalDatabaseBundleId", fromRelationalDatabaseBundleId())
                .add("FromRelationalDatabaseBlueprintId", fromRelationalDatabaseBlueprintId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "supportCode":
            return Optional.ofNullable(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "fromRelationalDatabaseName":
            return Optional.ofNullable(clazz.cast(fromRelationalDatabaseName()));
        case "fromRelationalDatabaseArn":
            return Optional.ofNullable(clazz.cast(fromRelationalDatabaseArn()));
        case "fromRelationalDatabaseBundleId":
            return Optional.ofNullable(clazz.cast(fromRelationalDatabaseBundleId()));
        case "fromRelationalDatabaseBlueprintId":
            return Optional.ofNullable(clazz.cast(fromRelationalDatabaseBlueprintId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseSnapshot, T> g) {
        return obj -> g.apply((RelationalDatabaseSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationalDatabaseSnapshot> {
        /**
         * <p>
         * The name of the database snapshot.
         * </p>
         * 
         * @param name
         *        The name of the database snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the database snapshot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the database snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code for the database snapshot. Include this code in your email to support when you have
         * questions about a database snapshot in Lightsail. This code enables our support team to look up your
         * Lightsail information more easily.
         * </p>
         * 
         * @param supportCode
         *        The support code for the database snapshot. Include this code in your email to support when you have
         *        questions about a database snapshot in Lightsail. This code enables our support team to look up your
         *        Lightsail information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the database snapshot was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the database snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Region name and Availability Zone where the database snapshot is located.
         * </p>
         * 
         * @param location
         *        The Region name and Availability Zone where the database snapshot is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The Region name and Availability Zone where the database snapshot is located.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The Lightsail resource type.
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type.
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon
         *        Lightsail Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon
         *        Lightsail Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags">Amazon Lightsail
         * Developer Guide</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The software of the database snapshot (for example, <code>MySQL</code>)
         * </p>
         * 
         * @param engine
         *        The software of the database snapshot (for example, <code>MySQL</code>)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The database engine version for the database snapshot (for example, <code>5.7.23</code>).
         * </p>
         * 
         * @param engineVersion
         *        The database engine version for the database snapshot (for example, <code>5.7.23</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The size of the disk in GB (for example, <code>32</code>) for the database snapshot.
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (for example, <code>32</code>) for the database snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The state of the database snapshot.
         * </p>
         * 
         * @param state
         *        The state of the database snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The name of the source database from which the database snapshot was created.
         * </p>
         * 
         * @param fromRelationalDatabaseName
         *        The name of the source database from which the database snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromRelationalDatabaseName(String fromRelationalDatabaseName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
         * </p>
         * 
         * @param fromRelationalDatabaseArn
         *        The Amazon Resource Name (ARN) of the database from which the database snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromRelationalDatabaseArn(String fromRelationalDatabaseArn);

        /**
         * <p>
         * The bundle ID of the database from which the database snapshot was created.
         * </p>
         * 
         * @param fromRelationalDatabaseBundleId
         *        The bundle ID of the database from which the database snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromRelationalDatabaseBundleId(String fromRelationalDatabaseBundleId);

        /**
         * <p>
         * The blueprint ID of the database from which the database snapshot was created. A blueprint describes the
         * major engine version of a database.
         * </p>
         * 
         * @param fromRelationalDatabaseBlueprintId
         *        The blueprint ID of the database from which the database snapshot was created. A blueprint describes
         *        the major engine version of a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromRelationalDatabaseBlueprintId(String fromRelationalDatabaseBlueprintId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String engine;

        private String engineVersion;

        private Integer sizeInGb;

        private String state;

        private String fromRelationalDatabaseName;

        private String fromRelationalDatabaseArn;

        private String fromRelationalDatabaseBundleId;

        private String fromRelationalDatabaseBlueprintId;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseSnapshot model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            tags(model.tags);
            engine(model.engine);
            engineVersion(model.engineVersion);
            sizeInGb(model.sizeInGb);
            state(model.state);
            fromRelationalDatabaseName(model.fromRelationalDatabaseName);
            fromRelationalDatabaseArn(model.fromRelationalDatabaseArn);
            fromRelationalDatabaseBundleId(model.fromRelationalDatabaseBundleId);
            fromRelationalDatabaseBlueprintId(model.fromRelationalDatabaseBlueprintId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        @Transient
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        @Transient
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        @Transient
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getFromRelationalDatabaseName() {
            return fromRelationalDatabaseName;
        }

        public final void setFromRelationalDatabaseName(String fromRelationalDatabaseName) {
            this.fromRelationalDatabaseName = fromRelationalDatabaseName;
        }

        @Override
        @Transient
        public final Builder fromRelationalDatabaseName(String fromRelationalDatabaseName) {
            this.fromRelationalDatabaseName = fromRelationalDatabaseName;
            return this;
        }

        public final String getFromRelationalDatabaseArn() {
            return fromRelationalDatabaseArn;
        }

        public final void setFromRelationalDatabaseArn(String fromRelationalDatabaseArn) {
            this.fromRelationalDatabaseArn = fromRelationalDatabaseArn;
        }

        @Override
        @Transient
        public final Builder fromRelationalDatabaseArn(String fromRelationalDatabaseArn) {
            this.fromRelationalDatabaseArn = fromRelationalDatabaseArn;
            return this;
        }

        public final String getFromRelationalDatabaseBundleId() {
            return fromRelationalDatabaseBundleId;
        }

        public final void setFromRelationalDatabaseBundleId(String fromRelationalDatabaseBundleId) {
            this.fromRelationalDatabaseBundleId = fromRelationalDatabaseBundleId;
        }

        @Override
        @Transient
        public final Builder fromRelationalDatabaseBundleId(String fromRelationalDatabaseBundleId) {
            this.fromRelationalDatabaseBundleId = fromRelationalDatabaseBundleId;
            return this;
        }

        public final String getFromRelationalDatabaseBlueprintId() {
            return fromRelationalDatabaseBlueprintId;
        }

        public final void setFromRelationalDatabaseBlueprintId(String fromRelationalDatabaseBlueprintId) {
            this.fromRelationalDatabaseBlueprintId = fromRelationalDatabaseBlueprintId;
        }

        @Override
        @Transient
        public final Builder fromRelationalDatabaseBlueprintId(String fromRelationalDatabaseBlueprintId) {
            this.fromRelationalDatabaseBlueprintId = fromRelationalDatabaseBlueprintId;
            return this;
        }

        @Override
        public RelationalDatabaseSnapshot build() {
            return new RelationalDatabaseSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
