/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBucketBundleRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateBucketBundleRequest.Builder, UpdateBucketBundleRequest> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bucketName").getter(getter(UpdateBucketBundleRequest::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(UpdateBucketBundleRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            BUNDLE_ID_FIELD));

    private final String bucketName;

    private final String bundleId;

    private UpdateBucketBundleRequest(BuilderImpl builder) {
        super(builder);
        this.bucketName = builder.bucketName;
        this.bundleId = builder.bundleId;
    }

    /**
     * <p>
     * The name of the bucket for which to update the bundle.
     * </p>
     * 
     * @return The name of the bucket for which to update the bundle.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The ID of the new bundle to apply to the bucket.
     * </p>
     * <p>
     * Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
     * </p>
     * 
     * @return The ID of the new bundle to apply to the bucket.</p>
     *         <p>
     *         Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
     */
    public final String bundleId() {
        return bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBucketBundleRequest)) {
            return false;
        }
        UpdateBucketBundleRequest other = (UpdateBucketBundleRequest) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(bundleId(), other.bundleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBucketBundleRequest").add("BucketName", bucketName()).add("BundleId", bundleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBucketBundleRequest, T> g) {
        return obj -> g.apply((UpdateBucketBundleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBucketBundleRequest> {
        /**
         * <p>
         * The name of the bucket for which to update the bundle.
         * </p>
         * 
         * @param bucketName
         *        The name of the bucket for which to update the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The ID of the new bundle to apply to the bucket.
         * </p>
         * <p>
         * Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
         * </p>
         * 
         * @param bundleId
         *        The ID of the new bundle to apply to the bucket.</p>
         *        <p>
         *        Use the <a>GetBucketBundles</a> action to get a list of bundle IDs that you can specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String bucketName;

        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBucketBundleRequest model) {
            super(model);
            bucketName(model.bucketName);
            bundleId(model.bundleId);
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        @Transient
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBucketBundleRequest build() {
            return new UpdateBucketBundleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
