/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerServicePowersResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerServicePowersResponse.Builder, GetContainerServicePowersResponse> {
    private static final SdkField<List<ContainerServicePower>> POWERS_FIELD = SdkField
            .<List<ContainerServicePower>> builder(MarshallingType.LIST)
            .memberName("powers")
            .getter(getter(GetContainerServicePowersResponse::powers))
            .setter(setter(Builder::powers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("powers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerServicePower> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerServicePower::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POWERS_FIELD));

    private final List<ContainerServicePower> powers;

    private GetContainerServicePowersResponse(BuilderImpl builder) {
        super(builder);
        this.powers = builder.powers;
    }

    /**
     * Returns true if the Powers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPowers() {
        return powers != null && !(powers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the powers that can be specified for a container service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPowers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects that describe the powers that can be specified for a container service.
     */
    public final List<ContainerServicePower> powers() {
        return powers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPowers() ? powers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServicePowersResponse)) {
            return false;
        }
        GetContainerServicePowersResponse other = (GetContainerServicePowersResponse) obj;
        return hasPowers() == other.hasPowers() && Objects.equals(powers(), other.powers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerServicePowersResponse").add("Powers", hasPowers() ? powers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "powers":
            return Optional.ofNullable(clazz.cast(powers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerServicePowersResponse, T> g) {
        return obj -> g.apply((GetContainerServicePowersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetContainerServicePowersResponse> {
        /**
         * <p>
         * An array of objects that describe the powers that can be specified for a container service.
         * </p>
         * 
         * @param powers
         *        An array of objects that describe the powers that can be specified for a container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder powers(Collection<ContainerServicePower> powers);

        /**
         * <p>
         * An array of objects that describe the powers that can be specified for a container service.
         * </p>
         * 
         * @param powers
         *        An array of objects that describe the powers that can be specified for a container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder powers(ContainerServicePower... powers);

        /**
         * <p>
         * An array of objects that describe the powers that can be specified for a container service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContainerServicePower>.Builder} avoiding
         * the need to create one manually via {@link List<ContainerServicePower>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerServicePower>.Builder#build()} is called
         * immediately and its result is passed to {@link #powers(List<ContainerServicePower>)}.
         * 
         * @param powers
         *        a consumer that will call methods on {@link List<ContainerServicePower>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #powers(List<ContainerServicePower>)
         */
        Builder powers(Consumer<ContainerServicePower.Builder>... powers);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContainerServicePower> powers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerServicePowersResponse model) {
            super(model);
            powers(model.powers);
        }

        public final List<ContainerServicePower.Builder> getPowers() {
            List<ContainerServicePower.Builder> result = ContainerServicePowerListCopier.copyToBuilder(this.powers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPowers(Collection<ContainerServicePower.BuilderImpl> powers) {
            this.powers = ContainerServicePowerListCopier.copyFromBuilder(powers);
        }

        @Override
        @Transient
        public final Builder powers(Collection<ContainerServicePower> powers) {
            this.powers = ContainerServicePowerListCopier.copy(powers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder powers(ContainerServicePower... powers) {
            powers(Arrays.asList(powers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder powers(Consumer<ContainerServicePower.Builder>... powers) {
            powers(Stream.of(powers).map(c -> ContainerServicePower.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContainerServicePowersResponse build() {
            return new GetContainerServicePowersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
