/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRegionsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRegionsRequest.Builder, GetRegionsRequest> {
    private static final SdkField<Boolean> INCLUDE_AVAILABILITY_ZONES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeAvailabilityZones").getter(getter(GetRegionsRequest::includeAvailabilityZones))
            .setter(setter(Builder::includeAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeAvailabilityZones").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeRelationalDatabaseAvailabilityZones")
            .getter(getter(GetRegionsRequest::includeRelationalDatabaseAvailabilityZones))
            .setter(setter(Builder::includeRelationalDatabaseAvailabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("includeRelationalDatabaseAvailabilityZones").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INCLUDE_AVAILABILITY_ZONES_FIELD, INCLUDE_RELATIONAL_DATABASE_AVAILABILITY_ZONES_FIELD));

    private final Boolean includeAvailabilityZones;

    private final Boolean includeRelationalDatabaseAvailabilityZones;

    private GetRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.includeAvailabilityZones = builder.includeAvailabilityZones;
        this.includeRelationalDatabaseAvailabilityZones = builder.includeRelationalDatabaseAvailabilityZones;
    }

    /**
     * <p>
     * A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability
     * Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
     * </p>
     * 
     * @return A Boolean value indicating whether to also include Availability Zones in your get regions request.
     *         Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
     */
    public final Boolean includeAvailabilityZones() {
        return includeAvailabilityZones;
    }

    /**
     * <p>
     * A Boolean value indicating whether to also include Availability Zones for databases in your get regions request.
     * Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).
     * </p>
     * 
     * @return A Boolean value indicating whether to also include Availability Zones for databases in your get regions
     *         request. Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).
     */
    public final Boolean includeRelationalDatabaseAvailabilityZones() {
        return includeRelationalDatabaseAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeAvailabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(includeRelationalDatabaseAvailabilityZones());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsRequest)) {
            return false;
        }
        GetRegionsRequest other = (GetRegionsRequest) obj;
        return Objects.equals(includeAvailabilityZones(), other.includeAvailabilityZones())
                && Objects.equals(includeRelationalDatabaseAvailabilityZones(),
                        other.includeRelationalDatabaseAvailabilityZones());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRegionsRequest").add("IncludeAvailabilityZones", includeAvailabilityZones())
                .add("IncludeRelationalDatabaseAvailabilityZones", includeRelationalDatabaseAvailabilityZones()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeAvailabilityZones":
            return Optional.ofNullable(clazz.cast(includeAvailabilityZones()));
        case "includeRelationalDatabaseAvailabilityZones":
            return Optional.ofNullable(clazz.cast(includeRelationalDatabaseAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRegionsRequest, T> g) {
        return obj -> g.apply((GetRegionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRegionsRequest> {
        /**
         * <p>
         * A Boolean value indicating whether to also include Availability Zones in your get regions request.
         * Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
         * </p>
         * 
         * @param includeAvailabilityZones
         *        A Boolean value indicating whether to also include Availability Zones in your get regions request.
         *        Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAvailabilityZones(Boolean includeAvailabilityZones);

        /**
         * <p>
         * A Boolean value indicating whether to also include Availability Zones for databases in your get regions
         * request. Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).
         * </p>
         * 
         * @param includeRelationalDatabaseAvailabilityZones
         *        A Boolean value indicating whether to also include Availability Zones for databases in your get
         *        regions request. Availability Zones are indicated with a letter (e.g., <code>us-east-2a</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRelationalDatabaseAvailabilityZones(Boolean includeRelationalDatabaseAvailabilityZones);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private Boolean includeAvailabilityZones;

        private Boolean includeRelationalDatabaseAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsRequest model) {
            super(model);
            includeAvailabilityZones(model.includeAvailabilityZones);
            includeRelationalDatabaseAvailabilityZones(model.includeRelationalDatabaseAvailabilityZones);
        }

        public final Boolean getIncludeAvailabilityZones() {
            return includeAvailabilityZones;
        }

        public final void setIncludeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
        }

        @Override
        @Transient
        public final Builder includeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
            return this;
        }

        public final Boolean getIncludeRelationalDatabaseAvailabilityZones() {
            return includeRelationalDatabaseAvailabilityZones;
        }

        public final void setIncludeRelationalDatabaseAvailabilityZones(Boolean includeRelationalDatabaseAvailabilityZones) {
            this.includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones;
        }

        @Override
        @Transient
        public final Builder includeRelationalDatabaseAvailabilityZones(Boolean includeRelationalDatabaseAvailabilityZones) {
            this.includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRegionsRequest build() {
            return new GetRegionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
