/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskInfo implements SdkPojo, Serializable, ToCopyableBuilder<DiskInfo.Builder, DiskInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DiskInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("path")
            .getter(getter(DiskInfo::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(DiskInfo::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<Boolean> IS_SYSTEM_DISK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSystemDisk").getter(getter(DiskInfo::isSystemDisk)).setter(setter(Builder::isSystemDisk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSystemDisk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD,
            SIZE_IN_GB_FIELD, IS_SYSTEM_DISK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String path;

    private final Integer sizeInGb;

    private final Boolean isSystemDisk;

    private DiskInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.sizeInGb = builder.sizeInGb;
        this.isSystemDisk = builder.isSystemDisk;
    }

    /**
     * <p>
     * The disk name.
     * </p>
     * 
     * @return The disk name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The disk path.
     * </p>
     * 
     * @return The disk path.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The size of the disk in GB (e.g., <code>32</code>).
     * </p>
     * 
     * @return The size of the disk in GB (e.g., <code>32</code>).
     */
    public final Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * <p>
     * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
     * </p>
     * 
     * @return A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
     */
    public final Boolean isSystemDisk() {
        return isSystemDisk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(isSystemDisk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskInfo)) {
            return false;
        }
        DiskInfo other = (DiskInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(path(), other.path())
                && Objects.equals(sizeInGb(), other.sizeInGb()) && Objects.equals(isSystemDisk(), other.isSystemDisk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DiskInfo").add("Name", name()).add("Path", path()).add("SizeInGb", sizeInGb())
                .add("IsSystemDisk", isSystemDisk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "path":
            return Optional.ofNullable(clazz.cast(path()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "isSystemDisk":
            return Optional.ofNullable(clazz.cast(isSystemDisk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskInfo, T> g) {
        return obj -> g.apply((DiskInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskInfo> {
        /**
         * <p>
         * The disk name.
         * </p>
         * 
         * @param name
         *        The disk name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The disk path.
         * </p>
         * 
         * @param path
         *        The disk path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The size of the disk in GB (e.g., <code>32</code>).
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (e.g., <code>32</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         * </p>
         * 
         * @param isSystemDisk
         *        A Boolean value indicating whether this disk is a system disk (has an operating system loaded on it).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSystemDisk(Boolean isSystemDisk);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String path;

        private Integer sizeInGb;

        private Boolean isSystemDisk;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskInfo model) {
            name(model.name);
            path(model.path);
            sizeInGb(model.sizeInGb);
            isSystemDisk(model.isSystemDisk);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        @Transient
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final Boolean getIsSystemDisk() {
            return isSystemDisk;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        @Override
        @Transient
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        @Override
        public DiskInfo build() {
            return new DiskInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
