/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the validation record of each domain name in the SSL/TLS certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateDomainValidationRecord
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificateDomainValidationRecord.Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LoadBalancerTlsCertificateDomainValidationRecord::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(LoadBalancerTlsCertificateDomainValidationRecord::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(LoadBalancerTlsCertificateDomainValidationRecord::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationStatus")
            .getter(getter(LoadBalancerTlsCertificateDomainValidationRecord::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(LoadBalancerTlsCertificateDomainValidationRecord::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            VALUE_FIELD, VALIDATION_STATUS_FIELD, DOMAIN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String value;

    private final String validationStatus;

    private final String domainName;

    private LoadBalancerTlsCertificateDomainValidationRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.validationStatus = builder.validationStatus;
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * A fully qualified domain name in the certificate. For example, <code>example.com</code>.
     * </p>
     * 
     * @return A fully qualified domain name in the certificate. For example, <code>example.com</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of validation record. For example, <code>CNAME</code> for domain validation.
     * </p>
     * 
     * @return The type of validation record. For example, <code>CNAME</code> for domain validation.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The value for that type.
     * </p>
     * 
     * @return The value for that type.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The validation status. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link LoadBalancerTlsCertificateDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status. Valid values are listed below.
     * @see LoadBalancerTlsCertificateDomainStatus
     */
    public final LoadBalancerTlsCertificateDomainStatus validationStatus() {
        return LoadBalancerTlsCertificateDomainStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * The validation status. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link LoadBalancerTlsCertificateDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return The validation status. Valid values are listed below.
     * @see LoadBalancerTlsCertificateDomainStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    /**
     * <p>
     * The domain name against which your SSL/TLS certificate was validated.
     * </p>
     * 
     * @return The domain name against which your SSL/TLS certificate was validated.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateDomainValidationRecord)) {
            return false;
        }
        LoadBalancerTlsCertificateDomainValidationRecord other = (LoadBalancerTlsCertificateDomainValidationRecord) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(value(), other.value())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString())
                && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerTlsCertificateDomainValidationRecord").add("Name", name()).add("Type", type())
                .add("Value", value()).add("ValidationStatus", validationStatusAsString()).add("DomainName", domainName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "validationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateDomainValidationRecord, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateDomainValidationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificateDomainValidationRecord> {
        /**
         * <p>
         * A fully qualified domain name in the certificate. For example, <code>example.com</code>.
         * </p>
         * 
         * @param name
         *        A fully qualified domain name in the certificate. For example, <code>example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of validation record. For example, <code>CNAME</code> for domain validation.
         * </p>
         * 
         * @param type
         *        The type of validation record. For example, <code>CNAME</code> for domain validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The value for that type.
         * </p>
         * 
         * @param value
         *        The value for that type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The validation status. Valid values are listed below.
         * </p>
         * 
         * @param validationStatus
         *        The validation status. Valid values are listed below.
         * @see LoadBalancerTlsCertificateDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDomainStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * The validation status. Valid values are listed below.
         * </p>
         * 
         * @param validationStatus
         *        The validation status. Valid values are listed below.
         * @see LoadBalancerTlsCertificateDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateDomainStatus
         */
        Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus);

        /**
         * <p>
         * The domain name against which your SSL/TLS certificate was validated.
         * </p>
         * 
         * @param domainName
         *        The domain name against which your SSL/TLS certificate was validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String value;

        private String validationStatus;

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateDomainValidationRecord model) {
            name(model.name);
            type(model.type);
            value(model.value);
            validationStatus(model.validationStatus);
            domainName(model.domainName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        @Transient
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder validationStatus(LoadBalancerTlsCertificateDomainStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public LoadBalancerTlsCertificateDomainValidationRecord build() {
            return new LoadBalancerTlsCertificateDomainValidationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
