/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current state of a container service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerServiceStateDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerServiceStateDetail.Builder, ContainerServiceStateDetail> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ContainerServiceStateDetail::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(ContainerServiceStateDetail::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private ContainerServiceStateDetail(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state code of the container service.
     * </p>
     * <p>
     * The following state codes are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
     * <code>UPDATING</code> state:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are being
     * created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The following state codes are possible if your container service is in a <code>PENDING</code> state:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service exceeds the
     * maximum number of certificates allowed for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ContainerServiceStateDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The state code of the container service.</p>
     *         <p>
     *         The following state codes are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
     *         <code>UPDATING</code> state:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are
     *         being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         The following state codes are possible if your container service is in a <code>PENDING</code> state:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service
     *         exceeds the maximum number of certificates allowed for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ContainerServiceStateDetailCode
     */
    public final ContainerServiceStateDetailCode code() {
        return ContainerServiceStateDetailCode.fromValue(code);
    }

    /**
     * <p>
     * The state code of the container service.
     * </p>
     * <p>
     * The following state codes are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
     * <code>UPDATING</code> state:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are being
     * created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * The following state codes are possible if your container service is in a <code>PENDING</code> state:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service exceeds the
     * maximum number of certificates allowed for your account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ContainerServiceStateDetailCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The state code of the container service.</p>
     *         <p>
     *         The following state codes are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
     *         <code>UPDATING</code> state:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are
     *         being created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being
     *         created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         The following state codes are possible if your container service is in a <code>PENDING</code> state:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service
     *         exceeds the maximum number of certificates allowed for your account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     * @see ContainerServiceStateDetailCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A message that provides more information for the state code.
     * </p>
     * <note>
     * <p>
     * The state detail is populated only when a container service is in a <code>PENDING</code>, <code>DEPLOYING</code>,
     * or <code>UPDATING</code> state.
     * </p>
     * </note>
     * 
     * @return A message that provides more information for the state code.</p> <note>
     *         <p>
     *         The state detail is populated only when a container service is in a <code>PENDING</code>,
     *         <code>DEPLOYING</code>, or <code>UPDATING</code> state.
     *         </p>
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerServiceStateDetail)) {
            return false;
        }
        ContainerServiceStateDetail other = (ContainerServiceStateDetail) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerServiceStateDetail").add("Code", codeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerServiceStateDetail, T> g) {
        return obj -> g.apply((ContainerServiceStateDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerServiceStateDetail> {
        /**
         * <p>
         * The state code of the container service.
         * </p>
         * <p>
         * The following state codes are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
         * <code>UPDATING</code> state:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are
         * being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * The following state codes are possible if your container service is in a <code>PENDING</code> state:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service exceeds
         * the maximum number of certificates allowed for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state code of the container service.</p>
         *        <p>
         *        The following state codes are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
         *        <code>UPDATING</code> state:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service
         *        are being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        The following state codes are possible if your container service is in a <code>PENDING</code> state:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service
         *        exceeds the maximum number of certificates allowed for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ContainerServiceStateDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServiceStateDetailCode
         */
        Builder code(String code);

        /**
         * <p>
         * The state code of the container service.
         * </p>
         * <p>
         * The following state codes are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
         * <code>UPDATING</code> state:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service are
         * being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * The following state codes are possible if your container service is in a <code>PENDING</code> state:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service exceeds
         * the maximum number of certificates allowed for your account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param code
         *        The state code of the container service.</p>
         *        <p>
         *        The following state codes are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The following state codes are possible if your container service is in a <code>DEPLOYING</code> or
         *        <code>UPDATING</code> state:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING_SYSTEM_RESOURCES</code> - The system resources for your container service are being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_NETWORK_INFRASTRUCTURE</code> - The network infrastructure for your container service
         *        are being created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING_CERTIFICATE</code> - The SSL/TLS certificate for your container service is being
         *        created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PROVISIONING_SERVICE</code> - Your container service is being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING_DEPLOYMENT</code> - Your deployment is being created on your container service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EVALUATING_HEALTH_CHECK</code> - The health of your deployment is being evaluated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVATING_DEPLOYMENT</code> - Your deployment is being activated.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        The following state codes are possible if your container service is in a <code>PENDING</code> state:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CERTIFICATE_LIMIT_EXCEEDED</code> - The SSL/TLS certificate required for your container service
         *        exceeds the maximum number of certificates allowed for your account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNKNOWN_ERROR</code> - An error was experienced when your container service was being created.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @see ContainerServiceStateDetailCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerServiceStateDetailCode
         */
        Builder code(ContainerServiceStateDetailCode code);

        /**
         * <p>
         * A message that provides more information for the state code.
         * </p>
         * <note>
         * <p>
         * The state detail is populated only when a container service is in a <code>PENDING</code>,
         * <code>DEPLOYING</code>, or <code>UPDATING</code> state.
         * </p>
         * </note>
         * 
         * @param message
         *        A message that provides more information for the state code.</p> <note>
         *        <p>
         *        The state detail is populated only when a container service is in a <code>PENDING</code>,
         *        <code>DEPLOYING</code>, or <code>UPDATING</code> state.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerServiceStateDetail model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        @Transient
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        @Transient
        public final Builder code(ContainerServiceStateDetailCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ContainerServiceStateDetail build() {
            return new ContainerServiceStateDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
