/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoSnapshotsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetAutoSnapshotsResponse.Builder, GetAutoSnapshotsResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(GetAutoSnapshotsResponse::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(GetAutoSnapshotsResponse::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<AutoSnapshotDetails>> AUTO_SNAPSHOTS_FIELD = SdkField
            .<List<AutoSnapshotDetails>> builder(MarshallingType.LIST)
            .memberName("autoSnapshots")
            .getter(getter(GetAutoSnapshotsResponse::autoSnapshots))
            .setter(setter(Builder::autoSnapshots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSnapshots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoSnapshotDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoSnapshotDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, AUTO_SNAPSHOTS_FIELD));

    private final String resourceName;

    private final String resourceType;

    private final List<AutoSnapshotDetails> autoSnapshots;

    private GetAutoSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.autoSnapshots = builder.autoSnapshots;
    }

    /**
     * <p>
     * The name of the source instance or disk for the automatic snapshots.
     * </p>
     * 
     * @return The name of the source instance or disk for the automatic snapshots.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoSnapshots property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAutoSnapshots() {
        return autoSnapshots != null && !(autoSnapshots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the automatic snapshots that are available for the specified source instance or
     * disk.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoSnapshots} method.
     * </p>
     * 
     * @return An array of objects that describe the automatic snapshots that are available for the specified source
     *         instance or disk.
     */
    public final List<AutoSnapshotDetails> autoSnapshots() {
        return autoSnapshots;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoSnapshots() ? autoSnapshots() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoSnapshotsResponse)) {
            return false;
        }
        GetAutoSnapshotsResponse other = (GetAutoSnapshotsResponse) obj;
        return Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasAutoSnapshots() == other.hasAutoSnapshots() && Objects.equals(autoSnapshots(), other.autoSnapshots());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutoSnapshotsResponse").add("ResourceName", resourceName())
                .add("ResourceType", resourceTypeAsString()).add("AutoSnapshots", hasAutoSnapshots() ? autoSnapshots() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "autoSnapshots":
            return Optional.ofNullable(clazz.cast(autoSnapshots()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoSnapshotsResponse, T> g) {
        return obj -> g.apply((GetAutoSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAutoSnapshotsResponse> {
        /**
         * <p>
         * The name of the source instance or disk for the automatic snapshots.
         * </p>
         * 
         * @param resourceName
         *        The name of the source instance or disk for the automatic snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
         * </p>
         * 
         * @param resourceType
         *        The resource type (e.g., <code>Instance</code> or <code>Disk</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * An array of objects that describe the automatic snapshots that are available for the specified source
         * instance or disk.
         * </p>
         * 
         * @param autoSnapshots
         *        An array of objects that describe the automatic snapshots that are available for the specified source
         *        instance or disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSnapshots(Collection<AutoSnapshotDetails> autoSnapshots);

        /**
         * <p>
         * An array of objects that describe the automatic snapshots that are available for the specified source
         * instance or disk.
         * </p>
         * 
         * @param autoSnapshots
         *        An array of objects that describe the automatic snapshots that are available for the specified source
         *        instance or disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSnapshots(AutoSnapshotDetails... autoSnapshots);

        /**
         * <p>
         * An array of objects that describe the automatic snapshots that are available for the specified source
         * instance or disk.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoSnapshotDetails>.Builder} avoiding the
         * need to create one manually via {@link List<AutoSnapshotDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoSnapshotDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #autoSnapshots(List<AutoSnapshotDetails>)}.
         * 
         * @param autoSnapshots
         *        a consumer that will call methods on {@link List<AutoSnapshotDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoSnapshots(List<AutoSnapshotDetails>)
         */
        Builder autoSnapshots(Consumer<AutoSnapshotDetails.Builder>... autoSnapshots);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String resourceName;

        private String resourceType;

        private List<AutoSnapshotDetails> autoSnapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoSnapshotsResponse model) {
            super(model);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            autoSnapshots(model.autoSnapshots);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        @Transient
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<AutoSnapshotDetails.Builder> getAutoSnapshots() {
            List<AutoSnapshotDetails.Builder> result = AutoSnapshotDetailsListCopier.copyToBuilder(this.autoSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoSnapshots(Collection<AutoSnapshotDetails.BuilderImpl> autoSnapshots) {
            this.autoSnapshots = AutoSnapshotDetailsListCopier.copyFromBuilder(autoSnapshots);
        }

        @Override
        @Transient
        public final Builder autoSnapshots(Collection<AutoSnapshotDetails> autoSnapshots) {
            this.autoSnapshots = AutoSnapshotDetailsListCopier.copy(autoSnapshots);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoSnapshots(AutoSnapshotDetails... autoSnapshots) {
            autoSnapshots(Arrays.asList(autoSnapshots));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoSnapshots(Consumer<AutoSnapshotDetails.Builder>... autoSnapshots) {
            autoSnapshots(Stream.of(autoSnapshots).map(c -> AutoSnapshotDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAutoSnapshotsResponse build() {
            return new GetAutoSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
