/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a pending database maintenance action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingMaintenanceAction implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingMaintenanceAction.Builder, PendingMaintenanceAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(PendingMaintenanceAction::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(PendingMaintenanceAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CURRENT_APPLY_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("currentApplyDate").getter(getter(PendingMaintenanceAction::currentApplyDate))
            .setter(setter(Builder::currentApplyDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentApplyDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            DESCRIPTION_FIELD, CURRENT_APPLY_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String description;

    private final Instant currentApplyDate;

    private PendingMaintenanceAction(BuilderImpl builder) {
        this.action = builder.action;
        this.description = builder.description;
        this.currentApplyDate = builder.currentApplyDate;
    }

    /**
     * <p>
     * The type of pending database maintenance action.
     * </p>
     * 
     * @return The type of pending database maintenance action.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * Additional detail about the pending database maintenance action.
     * </p>
     * 
     * @return Additional detail about the pending database maintenance action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The effective date of the pending database maintenance action.
     * </p>
     * 
     * @return The effective date of the pending database maintenance action.
     */
    public final Instant currentApplyDate() {
        return currentApplyDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplyDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenanceAction)) {
            return false;
        }
        PendingMaintenanceAction other = (PendingMaintenanceAction) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(description(), other.description())
                && Objects.equals(currentApplyDate(), other.currentApplyDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingMaintenanceAction").add("Action", action()).add("Description", description())
                .add("CurrentApplyDate", currentApplyDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "currentApplyDate":
            return Optional.ofNullable(clazz.cast(currentApplyDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingMaintenanceAction, T> g) {
        return obj -> g.apply((PendingMaintenanceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingMaintenanceAction> {
        /**
         * <p>
         * The type of pending database maintenance action.
         * </p>
         * 
         * @param action
         *        The type of pending database maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * Additional detail about the pending database maintenance action.
         * </p>
         * 
         * @param description
         *        Additional detail about the pending database maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The effective date of the pending database maintenance action.
         * </p>
         * 
         * @param currentApplyDate
         *        The effective date of the pending database maintenance action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplyDate(Instant currentApplyDate);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String description;

        private Instant currentApplyDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenanceAction model) {
            action(model.action);
            description(model.description);
            currentApplyDate(model.currentApplyDate);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCurrentApplyDate() {
            return currentApplyDate;
        }

        public final void setCurrentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
        }

        @Override
        @Transient
        public final Builder currentApplyDate(Instant currentApplyDate) {
            this.currentApplyDate = currentApplyDate;
            return this;
        }

        @Override
        public PendingMaintenanceAction build() {
            return new PendingMaintenanceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
