/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactMethodsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContactMethodsResponse.Builder, GetContactMethodsResponse> {
    private static final SdkField<List<ContactMethod>> CONTACT_METHODS_FIELD = SdkField
            .<List<ContactMethod>> builder(MarshallingType.LIST)
            .memberName("contactMethods")
            .getter(getter(GetContactMethodsResponse::contactMethods))
            .setter(setter(Builder::contactMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactMethod> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactMethod::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_METHODS_FIELD));

    private final List<ContactMethod> contactMethods;

    private GetContactMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.contactMethods = builder.contactMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactMethods property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContactMethods() {
        return contactMethods != null && !(contactMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the contact methods.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactMethods} method.
     * </p>
     * 
     * @return An array of objects that describe the contact methods.
     */
    public final List<ContactMethod> contactMethods() {
        return contactMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasContactMethods() ? contactMethods() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMethodsResponse)) {
            return false;
        }
        GetContactMethodsResponse other = (GetContactMethodsResponse) obj;
        return hasContactMethods() == other.hasContactMethods() && Objects.equals(contactMethods(), other.contactMethods());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContactMethodsResponse").add("ContactMethods", hasContactMethods() ? contactMethods() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactMethods":
            return Optional.ofNullable(clazz.cast(contactMethods()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactMethodsResponse, T> g) {
        return obj -> g.apply((GetContactMethodsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContactMethodsResponse> {
        /**
         * <p>
         * An array of objects that describe the contact methods.
         * </p>
         * 
         * @param contactMethods
         *        An array of objects that describe the contact methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactMethods(Collection<ContactMethod> contactMethods);

        /**
         * <p>
         * An array of objects that describe the contact methods.
         * </p>
         * 
         * @param contactMethods
         *        An array of objects that describe the contact methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactMethods(ContactMethod... contactMethods);

        /**
         * <p>
         * An array of objects that describe the contact methods.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ContactMethod>.Builder} avoiding the need
         * to create one manually via {@link List<ContactMethod>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContactMethod>.Builder#build()} is called immediately and
         * its result is passed to {@link #contactMethods(List<ContactMethod>)}.
         * 
         * @param contactMethods
         *        a consumer that will call methods on {@link List<ContactMethod>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactMethods(List<ContactMethod>)
         */
        Builder contactMethods(Consumer<ContactMethod.Builder>... contactMethods);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContactMethod> contactMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMethodsResponse model) {
            super(model);
            contactMethods(model.contactMethods);
        }

        public final List<ContactMethod.Builder> getContactMethods() {
            List<ContactMethod.Builder> result = ContactMethodsListCopier.copyToBuilder(this.contactMethods);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactMethods(Collection<ContactMethod.BuilderImpl> contactMethods) {
            this.contactMethods = ContactMethodsListCopier.copyFromBuilder(contactMethods);
        }

        @Override
        @Transient
        public final Builder contactMethods(Collection<ContactMethod> contactMethods) {
            this.contactMethods = ContactMethodsListCopier.copy(contactMethods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contactMethods(ContactMethod... contactMethods) {
            contactMethods(Arrays.asList(contactMethods));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contactMethods(Consumer<ContactMethod.Builder>... contactMethods) {
            contactMethods(Stream.of(contactMethods).map(c -> ContactMethod.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetContactMethodsResponse build() {
            return new GetContactMethodsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
