/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDiskFromSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDiskFromSnapshotRequest.Builder, CreateDiskFromSnapshotRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskName").getter(getter(CreateDiskFromSnapshotRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<String> DISK_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskSnapshotName").getter(getter(CreateDiskFromSnapshotRequest::diskSnapshotName))
            .setter(setter(Builder::diskSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateDiskFromSnapshotRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sizeInGb").getter(getter(CreateDiskFromSnapshotRequest::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateDiskFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField
            .<List<AddOnRequest>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(CreateDiskFromSnapshotRequest::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOnRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceDiskName").getter(getter(CreateDiskFromSnapshotRequest::sourceDiskName))
            .setter(setter(Builder::sourceDiskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDiskName").build()).build();

    private static final SdkField<String> RESTORE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restoreDate").getter(getter(CreateDiskFromSnapshotRequest::restoreDate))
            .setter(setter(Builder::restoreDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restoreDate").build()).build();

    private static final SdkField<Boolean> USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("useLatestRestorableAutoSnapshot")
            .getter(getter(CreateDiskFromSnapshotRequest::useLatestRestorableAutoSnapshot))
            .setter(setter(Builder::useLatestRestorableAutoSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useLatestRestorableAutoSnapshot")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            DISK_SNAPSHOT_NAME_FIELD, AVAILABILITY_ZONE_FIELD, SIZE_IN_GB_FIELD, TAGS_FIELD, ADD_ONS_FIELD,
            SOURCE_DISK_NAME_FIELD, RESTORE_DATE_FIELD, USE_LATEST_RESTORABLE_AUTO_SNAPSHOT_FIELD));

    private final String diskName;

    private final String diskSnapshotName;

    private final String availabilityZone;

    private final Integer sizeInGb;

    private final List<Tag> tags;

    private final List<AddOnRequest> addOns;

    private final String sourceDiskName;

    private final String restoreDate;

    private final Boolean useLatestRestorableAutoSnapshot;

    private CreateDiskFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
        this.availabilityZone = builder.availabilityZone;
        this.sizeInGb = builder.sizeInGb;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.sourceDiskName = builder.sourceDiskName;
        this.restoreDate = builder.restoreDate;
        this.useLatestRestorableAutoSnapshot = builder.useLatestRestorableAutoSnapshot;
    }

    /**
     * <p>
     * The unique Lightsail disk name (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (e.g., <code>my-disk</code>).
     */
    public final String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.
     * </p>
     * <p>
     * Constraint:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>source disk name</code> parameter. The
     * <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage
     *         disk.</p>
     *         <p>
     *         Constraint:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>source disk name</code> parameter. The
     *         <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
     *         </p>
     *         </li>
     */
    public final String diskSnapshotName() {
        return diskSnapshotName;
    }

    /**
     * <p>
     * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     * Availability Zone as the Lightsail instance where you want to create the disk.
     * </p>
     * <p>
     * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     * </p>
     * 
     * @return The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
     *         Availability Zone as the Lightsail instance where you want to create the disk.</p>
     *         <p>
     *         Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The size of the disk in GB (e.g., <code>32</code>).
     * </p>
     * 
     * @return The size of the disk in GB (e.g., <code>32</code>).
     */
    public final Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that represent the add-ons to enable for the new disk.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOns} method.
     * </p>
     * 
     * @return An array of objects that represent the add-ons to enable for the new disk.
     */
    public final List<AddOnRequest> addOns() {
        return addOns;
    }

    /**
     * <p>
     * The name of the source disk from which the source automatic snapshot was created.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
     * <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the source disk from which the source automatic snapshot was created.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
     *         <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final String sourceDiskName() {
        return sourceDiskName;
    }

    /**
     * <p>
     * The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation to
     * identify the dates of the available automatic snapshots.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be specified in <code>YYYY-MM-DD</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code> parameter.
     * The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are mutually
     * exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code>
     *         operation to identify the dates of the available automatic snapshots.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be specified in <code>YYYY-MM-DD</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
     *         parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters
     *         are mutually exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final String restoreDate() {
        return restoreDate;
    }

    /**
     * <p>
     * A Boolean value to indicate whether to use the latest available automatic snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter cannot be defined together with the <code>restore date</code> parameter. The
     * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually exclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots">
     * Amazon Lightsail Developer Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter cannot be defined together with the <code>restore date</code> parameter. The
     *         <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
     *         exclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Define this parameter only when creating a new disk from an automatic snapshot. For more information, see
     *         the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     *         </li>
     */
    public final Boolean useLatestRestorableAutoSnapshot() {
        return useLatestRestorableAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOns() ? addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDate());
        hashCode = 31 * hashCode + Objects.hashCode(useLatestRestorableAutoSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskFromSnapshotRequest)) {
            return false;
        }
        CreateDiskFromSnapshotRequest other = (CreateDiskFromSnapshotRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(diskSnapshotName(), other.diskSnapshotName())
                && Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(sizeInGb(), other.sizeInGb())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasAddOns() == other.hasAddOns()
                && Objects.equals(addOns(), other.addOns()) && Objects.equals(sourceDiskName(), other.sourceDiskName())
                && Objects.equals(restoreDate(), other.restoreDate())
                && Objects.equals(useLatestRestorableAutoSnapshot(), other.useLatestRestorableAutoSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDiskFromSnapshotRequest").add("DiskName", diskName())
                .add("DiskSnapshotName", diskSnapshotName()).add("AvailabilityZone", availabilityZone())
                .add("SizeInGb", sizeInGb()).add("Tags", hasTags() ? tags() : null).add("AddOns", hasAddOns() ? addOns() : null)
                .add("SourceDiskName", sourceDiskName()).add("RestoreDate", restoreDate())
                .add("UseLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "diskSnapshotName":
            return Optional.ofNullable(clazz.cast(diskSnapshotName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        case "sourceDiskName":
            return Optional.ofNullable(clazz.cast(sourceDiskName()));
        case "restoreDate":
            return Optional.ofNullable(clazz.cast(restoreDate()));
        case "useLatestRestorableAutoSnapshot":
            return Optional.ofNullable(clazz.cast(useLatestRestorableAutoSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskFromSnapshotRequest, T> g) {
        return obj -> g.apply((CreateDiskFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDiskFromSnapshotRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage disk.
         * </p>
         * <p>
         * Constraint:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>source disk name</code> parameter. The
         * <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * </ul>
         * 
         * @param diskSnapshotName
         *        The name of the disk snapshot (e.g., <code>my-snapshot</code>) from which to create the new storage
         *        disk.</p>
         *        <p>
         *        Constraint:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>source disk name</code> parameter. The
         *        <code>disk snapshot name</code> and <code>source disk name</code> parameters are mutually exclusive.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotName(String diskSnapshotName);

        /**
         * <p>
         * The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the same
         * Availability Zone as the Lightsail instance where you want to create the disk.
         * </p>
         * <p>
         * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where you want to create the disk (e.g., <code>us-east-2a</code>). Choose the
         *        same Availability Zone as the Lightsail instance where you want to create the disk.</p>
         *        <p>
         *        Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The size of the disk in GB (e.g., <code>32</code>).
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB (e.g., <code>32</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOnRequest> addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * 
         * @param addOns
         *        An array of objects that represent the add-ons to enable for the new disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOnRequest... addOns);

        /**
         * <p>
         * An array of objects that represent the add-ons to enable for the new disk.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AddOnRequest>.Builder} avoiding the
         * need to create one manually via {@link List<AddOnRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddOnRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link #addOns(List<AddOnRequest>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on {@link List<AddOnRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(List<AddOnRequest>)
         */
        Builder addOns(Consumer<AddOnRequest.Builder>... addOns);

        /**
         * <p>
         * The name of the source disk from which the source automatic snapshot was created.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
         * <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceDiskName
         *        The name of the source disk from which the source automatic snapshot was created.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>disk snapshot name</code> parameter. The
         *        <code>source disk name</code> and <code>disk snapshot name</code> parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDiskName(String sourceDiskName);

        /**
         * <p>
         * The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code> operation
         * to identify the dates of the available automatic snapshots.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be specified in <code>YYYY-MM-DD</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         * parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code> parameters are
         * mutually exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param restoreDate
         *        The date of the automatic snapshot to use for the new disk. Use the <code>get auto snapshots</code>
         *        operation to identify the dates of the available automatic snapshots.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be specified in <code>YYYY-MM-DD</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>use latest restorable auto snapshot</code>
         *        parameter. The <code>restore date</code> and <code>use latest restorable auto snapshot</code>
         *        parameters are mutually exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDate(String restoreDate);

        /**
         * <p>
         * A Boolean value to indicate whether to use the latest available automatic snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter cannot be defined together with the <code>restore date</code> parameter. The
         * <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         * exclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the
         * <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param useLatestRestorableAutoSnapshot
         *        A Boolean value to indicate whether to use the latest available automatic snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter cannot be defined together with the <code>restore date</code> parameter. The
         *        <code>use latest restorable auto snapshot</code> and <code>restore date</code> parameters are mutually
         *        exclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Define this parameter only when creating a new disk from an automatic snapshot. For more information,
         *        see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String diskSnapshotName;

        private String availabilityZone;

        private Integer sizeInGb;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private String sourceDiskName;

        private String restoreDate;

        private Boolean useLatestRestorableAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskFromSnapshotRequest model) {
            super(model);
            diskName(model.diskName);
            diskSnapshotName(model.diskSnapshotName);
            availabilityZone(model.availabilityZone);
            sizeInGb(model.sizeInGb);
            tags(model.tags);
            addOns(model.addOns);
            sourceDiskName(model.sourceDiskName);
            restoreDate(model.restoreDate);
            useLatestRestorableAutoSnapshot(model.useLatestRestorableAutoSnapshot);
        }

        public final String getDiskName() {
            return diskName;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        @Override
        @Transient
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final String getDiskSnapshotName() {
            return diskSnapshotName;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        @Transient
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        @Transient
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        @Transient
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(AddOnRequest... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOnRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceDiskName() {
            return sourceDiskName;
        }

        public final void setSourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
        }

        @Override
        @Transient
        public final Builder sourceDiskName(String sourceDiskName) {
            this.sourceDiskName = sourceDiskName;
            return this;
        }

        public final String getRestoreDate() {
            return restoreDate;
        }

        public final void setRestoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
        }

        @Override
        @Transient
        public final Builder restoreDate(String restoreDate) {
            this.restoreDate = restoreDate;
            return this;
        }

        public final Boolean getUseLatestRestorableAutoSnapshot() {
            return useLatestRestorableAutoSnapshot;
        }

        public final void setUseLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
        }

        @Override
        @Transient
        public final Builder useLatestRestorableAutoSnapshot(Boolean useLatestRestorableAutoSnapshot) {
            this.useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskFromSnapshotRequest build() {
            return new CreateDiskFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
