/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateKeyPairResponse extends LightsailResponse implements
        ToCopyableBuilder<CreateKeyPairResponse.Builder, CreateKeyPairResponse> {
    private static final SdkField<KeyPair> KEY_PAIR_FIELD = SdkField.<KeyPair> builder(MarshallingType.SDK_POJO)
            .memberName("keyPair").getter(getter(CreateKeyPairResponse::keyPair)).setter(setter(Builder::keyPair))
            .constructor(KeyPair::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()).build();

    private static final SdkField<String> PUBLIC_KEY_BASE64_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("publicKeyBase64").getter(getter(CreateKeyPairResponse::publicKeyBase64))
            .setter(setter(Builder::publicKeyBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicKeyBase64").build()).build();

    private static final SdkField<String> PRIVATE_KEY_BASE64_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateKeyBase64").getter(getter(CreateKeyPairResponse::privateKeyBase64))
            .setter(setter(Builder::privateKeyBase64))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateKeyBase64").build()).build();

    private static final SdkField<Operation> OPERATION_FIELD = SdkField.<Operation> builder(MarshallingType.SDK_POJO)
            .memberName("operation").getter(getter(CreateKeyPairResponse::operation)).setter(setter(Builder::operation))
            .constructor(Operation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_FIELD,
            PUBLIC_KEY_BASE64_FIELD, PRIVATE_KEY_BASE64_FIELD, OPERATION_FIELD));

    private final KeyPair keyPair;

    private final String publicKeyBase64;

    private final String privateKeyBase64;

    private final Operation operation;

    private CreateKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyPair = builder.keyPair;
        this.publicKeyBase64 = builder.publicKeyBase64;
        this.privateKeyBase64 = builder.privateKeyBase64;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the new key pair you just created.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the new key pair you just created.
     */
    public final KeyPair keyPair() {
        return keyPair;
    }

    /**
     * <p>
     * A base64-encoded public key of the <code>ssh-rsa</code> type.
     * </p>
     * 
     * @return A base64-encoded public key of the <code>ssh-rsa</code> type.
     */
    public final String publicKeyBase64() {
        return publicKeyBase64;
    }

    /**
     * <p>
     * A base64-encoded RSA private key.
     * </p>
     * 
     * @return A base64-encoded RSA private key.
     */
    public final String privateKeyBase64() {
        return privateKeyBase64;
    }

    /**
     * <p>
     * An array of objects that describe the result of the action, such as the status of the request, the timestamp of
     * the request, and the resources affected by the request.
     * </p>
     * 
     * @return An array of objects that describe the result of the action, such as the status of the request, the
     *         timestamp of the request, and the resources affected by the request.
     */
    public final Operation operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(privateKeyBase64());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeyPairResponse)) {
            return false;
        }
        CreateKeyPairResponse other = (CreateKeyPairResponse) obj;
        return Objects.equals(keyPair(), other.keyPair()) && Objects.equals(publicKeyBase64(), other.publicKeyBase64())
                && Objects.equals(privateKeyBase64(), other.privateKeyBase64()) && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateKeyPairResponse").add("KeyPair", keyPair()).add("PublicKeyBase64", publicKeyBase64())
                .add("PrivateKeyBase64", privateKeyBase64()).add("Operation", operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPair":
            return Optional.ofNullable(clazz.cast(keyPair()));
        case "publicKeyBase64":
            return Optional.ofNullable(clazz.cast(publicKeyBase64()));
        case "privateKeyBase64":
            return Optional.ofNullable(clazz.cast(privateKeyBase64()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKeyPairResponse, T> g) {
        return obj -> g.apply((CreateKeyPairResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateKeyPairResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the new key pair you just created.
         * </p>
         * 
         * @param keyPair
         *        An array of key-value pairs containing information about the new key pair you just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPair(KeyPair keyPair);

        /**
         * <p>
         * An array of key-value pairs containing information about the new key pair you just created.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyPair.Builder} avoiding the need to
         * create one manually via {@link KeyPair#builder()}.
         *
         * When the {@link Consumer} completes, {@link KeyPair.Builder#build()} is called immediately and its result is
         * passed to {@link #keyPair(KeyPair)}.
         * 
         * @param keyPair
         *        a consumer that will call methods on {@link KeyPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyPair(KeyPair)
         */
        default Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return keyPair(KeyPair.builder().applyMutation(keyPair).build());
        }

        /**
         * <p>
         * A base64-encoded public key of the <code>ssh-rsa</code> type.
         * </p>
         * 
         * @param publicKeyBase64
         *        A base64-encoded public key of the <code>ssh-rsa</code> type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyBase64(String publicKeyBase64);

        /**
         * <p>
         * A base64-encoded RSA private key.
         * </p>
         * 
         * @param privateKeyBase64
         *        A base64-encoded RSA private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKeyBase64(String privateKeyBase64);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * 
         * @param operation
         *        An array of objects that describe the result of the action, such as the status of the request, the
         *        timestamp of the request, and the resources affected by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * An array of objects that describe the result of the action, such as the status of the request, the timestamp
         * of the request, and the resources affected by the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Operation.Builder} avoiding the need to
         * create one manually via {@link Operation#builder()}.
         *
         * When the {@link Consumer} completes, {@link Operation.Builder#build()} is called immediately and its result
         * is passed to {@link #operation(Operation)}.
         * 
         * @param operation
         *        a consumer that will call methods on {@link Operation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operation(Operation)
         */
        default Builder operation(Consumer<Operation.Builder> operation) {
            return operation(Operation.builder().applyMutation(operation).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private KeyPair keyPair;

        private String publicKeyBase64;

        private String privateKeyBase64;

        private Operation operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeyPairResponse model) {
            super(model);
            keyPair(model.keyPair);
            publicKeyBase64(model.publicKeyBase64);
            privateKeyBase64(model.privateKeyBase64);
            operation(model.operation);
        }

        public final KeyPair.Builder getKeyPair() {
            return keyPair != null ? keyPair.toBuilder() : null;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        @Override
        @Transient
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final String getPublicKeyBase64() {
            return publicKeyBase64;
        }

        public final void setPublicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
        }

        @Override
        @Transient
        public final Builder publicKeyBase64(String publicKeyBase64) {
            this.publicKeyBase64 = publicKeyBase64;
            return this;
        }

        public final String getPrivateKeyBase64() {
            return privateKeyBase64;
        }

        public final void setPrivateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
        }

        @Override
        @Transient
        public final Builder privateKeyBase64(String privateKeyBase64) {
            this.privateKeyBase64 = privateKeyBase64;
            return this;
        }

        public final Operation.Builder getOperation() {
            return operation != null ? operation.toBuilder() : null;
        }

        public final void setOperation(Operation.BuilderImpl operation) {
            this.operation = operation != null ? operation.build() : null;
        }

        @Override
        @Transient
        public final Builder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public CreateKeyPairResponse build() {
            return new CreateKeyPairResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
