/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoadBalancerRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateLoadBalancerRequest.Builder, CreateLoadBalancerRequest> {
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loadBalancerName").getter(getter(CreateLoadBalancerRequest::loadBalancerName))
            .setter(setter(Builder::loadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()).build();

    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("instancePort").getter(getter(CreateLoadBalancerRequest::instancePort))
            .setter(setter(Builder::instancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instancePort").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthCheckPath").getter(getter(CreateLoadBalancerRequest::healthCheckPath))
            .setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()).build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(CreateLoadBalancerRequest::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final SdkField<String> CERTIFICATE_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateDomainName").getter(getter(CreateLoadBalancerRequest::certificateDomainName))
            .setter(setter(Builder::certificateDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateDomainName").build())
            .build();

    private static final SdkField<List<String>> CERTIFICATE_ALTERNATIVE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("certificateAlternativeNames")
            .getter(getter(CreateLoadBalancerRequest::certificateAlternativeNames))
            .setter(setter(Builder::certificateAlternativeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateAlternativeNames")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateLoadBalancerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(CreateLoadBalancerRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_NAME_FIELD,
            INSTANCE_PORT_FIELD, HEALTH_CHECK_PATH_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_DOMAIN_NAME_FIELD,
            CERTIFICATE_ALTERNATIVE_NAMES_FIELD, TAGS_FIELD, IP_ADDRESS_TYPE_FIELD));

    private final String loadBalancerName;

    private final Integer instancePort;

    private final String healthCheckPath;

    private final String certificateName;

    private final String certificateDomainName;

    private final List<String> certificateAlternativeNames;

    private final List<Tag> tags;

    private final String ipAddressType;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerName = builder.loadBalancerName;
        this.instancePort = builder.instancePort;
        this.healthCheckPath = builder.healthCheckPath;
        this.certificateName = builder.certificateName;
        this.certificateDomainName = builder.certificateDomainName;
        this.certificateAlternativeNames = builder.certificateAlternativeNames;
        this.tags = builder.tags;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * The name of your load balancer.
     * </p>
     * 
     * @return The name of your load balancer.
     */
    public final String loadBalancerName() {
        return loadBalancerName;
    }

    /**
     * <p>
     * The instance port where you're creating your load balancer.
     * </p>
     * 
     * @return The instance port where you're creating your load balancer.
     */
    public final Integer instancePort() {
        return instancePort;
    }

    /**
     * <p>
     * The path you provided to perform the load balancer health check. If you didn't specify a health check path,
     * Lightsail uses the root path of your website (e.g., <code>"/"</code>).
     * </p>
     * <p>
     * You may want to specify a custom health check path other than the root of your application if your home page
     * loads slowly or has a lot of media or scripting on it.
     * </p>
     * 
     * @return The path you provided to perform the load balancer health check. If you didn't specify a health check
     *         path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
     *         <p>
     *         You may want to specify a custom health check path other than the root of your application if your home
     *         page loads slowly or has a lot of media or scripting on it.
     */
    public final String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The name of the SSL/TLS certificate.
     * </p>
     * <p>
     * If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
     * vice-versa).
     * </p>
     * 
     * @return The name of the SSL/TLS certificate.</p>
     *         <p>
     *         If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
     *         vice-versa).
     */
    public final String certificateName() {
        return certificateName;
    }

    /**
     * <p>
     * The domain name with which your certificate is associated (e.g., <code>example.com</code>).
     * </p>
     * <p>
     * If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
     * vice-versa).
     * </p>
     * 
     * @return The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
     *         <p>
     *         If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
     *         vice-versa).
     */
    public final String certificateDomainName() {
        return certificateDomainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateAlternativeNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCertificateAlternativeNames() {
        return certificateAlternativeNames != null && !(certificateAlternativeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
     * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>, <code>blog.example.com</code>
     * ).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateAlternativeNames} method.
     * </p>
     * 
     * @return The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
     *         <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
     *         <code>blog.example.com</code>).
     */
    public final List<String> certificateAlternativeNames() {
        return certificateAlternativeNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The IP address type for the load balancer.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the load balancer.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the load balancer.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the load balancer.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateAlternativeNames() ? certificateAlternativeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest) obj;
        return Objects.equals(loadBalancerName(), other.loadBalancerName())
                && Objects.equals(instancePort(), other.instancePort())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(certificateName(), other.certificateName())
                && Objects.equals(certificateDomainName(), other.certificateDomainName())
                && hasCertificateAlternativeNames() == other.hasCertificateAlternativeNames()
                && Objects.equals(certificateAlternativeNames(), other.certificateAlternativeNames())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLoadBalancerRequest").add("LoadBalancerName", loadBalancerName())
                .add("InstancePort", instancePort()).add("HealthCheckPath", healthCheckPath())
                .add("CertificateName", certificateName()).add("CertificateDomainName", certificateDomainName())
                .add("CertificateAlternativeNames", hasCertificateAlternativeNames() ? certificateAlternativeNames() : null)
                .add("Tags", hasTags() ? tags() : null).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancerName":
            return Optional.ofNullable(clazz.cast(loadBalancerName()));
        case "instancePort":
            return Optional.ofNullable(clazz.cast(instancePort()));
        case "healthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        case "certificateDomainName":
            return Optional.ofNullable(clazz.cast(certificateDomainName()));
        case "certificateAlternativeNames":
            return Optional.ofNullable(clazz.cast(certificateAlternativeNames()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        /**
         * <p>
         * The name of your load balancer.
         * </p>
         * 
         * @param loadBalancerName
         *        The name of your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerName(String loadBalancerName);

        /**
         * <p>
         * The instance port where you're creating your load balancer.
         * </p>
         * 
         * @param instancePort
         *        The instance port where you're creating your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePort(Integer instancePort);

        /**
         * <p>
         * The path you provided to perform the load balancer health check. If you didn't specify a health check path,
         * Lightsail uses the root path of your website (e.g., <code>"/"</code>).
         * </p>
         * <p>
         * You may want to specify a custom health check path other than the root of your application if your home page
         * loads slowly or has a lot of media or scripting on it.
         * </p>
         * 
         * @param healthCheckPath
         *        The path you provided to perform the load balancer health check. If you didn't specify a health check
         *        path, Lightsail uses the root path of your website (e.g., <code>"/"</code>).</p>
         *        <p>
         *        You may want to specify a custom health check path other than the root of your application if your
         *        home page loads slowly or has a lot of media or scripting on it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The name of the SSL/TLS certificate.
         * </p>
         * <p>
         * If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
         * vice-versa).
         * </p>
         * 
         * @param certificateName
         *        The name of the SSL/TLS certificate.</p>
         *        <p>
         *        If you specify <code>certificateName</code>, then <code>certificateDomainName</code> is required (and
         *        vice-versa).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        /**
         * <p>
         * The domain name with which your certificate is associated (e.g., <code>example.com</code>).
         * </p>
         * <p>
         * If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
         * vice-versa).
         * </p>
         * 
         * @param certificateDomainName
         *        The domain name with which your certificate is associated (e.g., <code>example.com</code>).</p>
         *        <p>
         *        If you specify <code>certificateDomainName</code>, then <code>certificateName</code> is required (and
         *        vice-versa).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDomainName(String certificateDomainName);

        /**
         * <p>
         * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         * <code>blog.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         *        <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         *        <code>blog.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames);

        /**
         * <p>
         * The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         * <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         * <code>blog.example.com</code>).
         * </p>
         * 
         * @param certificateAlternativeNames
         *        The optional alternative domains and subdomains to use with your SSL/TLS certificate (e.g.,
         *        <code>www.example.com</code>, <code>example.com</code>, <code>m.example.com</code>,
         *        <code>blog.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAlternativeNames(String... certificateAlternativeNames);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The IP address type for the load balancer.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the load balancer.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the load balancer.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the load balancer.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String loadBalancerName;

        private Integer instancePort;

        private String healthCheckPath;

        private String certificateName;

        private String certificateDomainName;

        private List<String> certificateAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            loadBalancerName(model.loadBalancerName);
            instancePort(model.instancePort);
            healthCheckPath(model.healthCheckPath);
            certificateName(model.certificateName);
            certificateDomainName(model.certificateDomainName);
            certificateAlternativeNames(model.certificateAlternativeNames);
            tags(model.tags);
            ipAddressType(model.ipAddressType);
        }

        public final String getLoadBalancerName() {
            return loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        @Transient
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final Integer getInstancePort() {
            return instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        @Transient
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        @Transient
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        @Transient
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final String getCertificateDomainName() {
            return certificateDomainName;
        }

        public final void setCertificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
        }

        @Override
        @Transient
        public final Builder certificateDomainName(String certificateDomainName) {
            this.certificateDomainName = certificateDomainName;
            return this;
        }

        public final Collection<String> getCertificateAlternativeNames() {
            if (certificateAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateAlternativeNames;
        }

        public final void setCertificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
        }

        @Override
        @Transient
        public final Builder certificateAlternativeNames(Collection<String> certificateAlternativeNames) {
            this.certificateAlternativeNames = DomainNameListCopier.copy(certificateAlternativeNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder certificateAlternativeNames(String... certificateAlternativeNames) {
            certificateAlternativeNames(Arrays.asList(certificateAlternativeNames));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
