/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableAddOnRequest extends LightsailRequest implements
        ToCopyableBuilder<EnableAddOnRequest.Builder, EnableAddOnRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(EnableAddOnRequest::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<AddOnRequest> ADD_ON_REQUEST_FIELD = SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
            .memberName("addOnRequest").getter(getter(EnableAddOnRequest::addOnRequest)).setter(setter(Builder::addOnRequest))
            .constructor(AddOnRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOnRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD,
            ADD_ON_REQUEST_FIELD));

    private final String resourceName;

    private final AddOnRequest addOnRequest;

    private EnableAddOnRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.addOnRequest = builder.addOnRequest;
    }

    /**
     * <p>
     * The name of the source resource for which to enable or modify the add-on.
     * </p>
     * 
     * @return The name of the source resource for which to enable or modify the add-on.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * An array of strings representing the add-on to enable or modify.
     * </p>
     * 
     * @return An array of strings representing the add-on to enable or modify.
     */
    public final AddOnRequest addOnRequest() {
        return addOnRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(addOnRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAddOnRequest)) {
            return false;
        }
        EnableAddOnRequest other = (EnableAddOnRequest) obj;
        return Objects.equals(resourceName(), other.resourceName()) && Objects.equals(addOnRequest(), other.addOnRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableAddOnRequest").add("ResourceName", resourceName()).add("AddOnRequest", addOnRequest())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "addOnRequest":
            return Optional.ofNullable(clazz.cast(addOnRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableAddOnRequest, T> g) {
        return obj -> g.apply((EnableAddOnRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableAddOnRequest> {
        /**
         * <p>
         * The name of the source resource for which to enable or modify the add-on.
         * </p>
         * 
         * @param resourceName
         *        The name of the source resource for which to enable or modify the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * An array of strings representing the add-on to enable or modify.
         * </p>
         * 
         * @param addOnRequest
         *        An array of strings representing the add-on to enable or modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOnRequest(AddOnRequest addOnRequest);

        /**
         * <p>
         * An array of strings representing the add-on to enable or modify.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddOnRequest.Builder} avoiding the need
         * to create one manually via {@link AddOnRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link AddOnRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #addOnRequest(AddOnRequest)}.
         * 
         * @param addOnRequest
         *        a consumer that will call methods on {@link AddOnRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOnRequest(AddOnRequest)
         */
        default Builder addOnRequest(Consumer<AddOnRequest.Builder> addOnRequest) {
            return addOnRequest(AddOnRequest.builder().applyMutation(addOnRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String resourceName;

        private AddOnRequest addOnRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAddOnRequest model) {
            super(model);
            resourceName(model.resourceName);
            addOnRequest(model.addOnRequest);
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        @Transient
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final AddOnRequest.Builder getAddOnRequest() {
            return addOnRequest != null ? addOnRequest.toBuilder() : null;
        }

        public final void setAddOnRequest(AddOnRequest.BuilderImpl addOnRequest) {
            this.addOnRequest = addOnRequest != null ? addOnRequest.build() : null;
        }

        @Override
        @Transient
        public final Builder addOnRequest(AddOnRequest addOnRequest) {
            this.addOnRequest = addOnRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAddOnRequest build() {
            return new EnableAddOnRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
