/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketMetricDataResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBucketMetricDataResponse.Builder, GetBucketMetricDataResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metricName").getter(getter(GetBucketMetricDataResponse::metricNameAsString))
            .setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<List<MetricDatapoint>> METRIC_DATA_FIELD = SdkField
            .<List<MetricDatapoint>> builder(MarshallingType.LIST)
            .memberName("metricData")
            .getter(getter(GetBucketMetricDataResponse::metricData))
            .setter(setter(Builder::metricData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatapoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatapoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_DATA_FIELD));

    private final String metricName;

    private final List<MetricDatapoint> metricData;

    private GetBucketMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The name of the metric returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link BucketMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric returned.
     * @see BucketMetricName
     */
    public final BucketMetricName metricName() {
        return BucketMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The name of the metric returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link BucketMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The name of the metric returned.
     * @see BucketMetricName
     */
    public final String metricNameAsString() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricData property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetricData() {
        return metricData != null && !(metricData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the metric data returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricData} method.
     * </p>
     * 
     * @return An array of objects that describe the metric data returned.
     */
    public final List<MetricDatapoint> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricData() ? metricData() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketMetricDataResponse)) {
            return false;
        }
        GetBucketMetricDataResponse other = (GetBucketMetricDataResponse) obj;
        return Objects.equals(metricNameAsString(), other.metricNameAsString()) && hasMetricData() == other.hasMetricData()
                && Objects.equals(metricData(), other.metricData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketMetricDataResponse").add("MetricName", metricNameAsString())
                .add("MetricData", hasMetricData() ? metricData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "metricData":
            return Optional.ofNullable(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketMetricDataResponse, T> g) {
        return obj -> g.apply((GetBucketMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketMetricDataResponse> {
        /**
         * <p>
         * The name of the metric returned.
         * </p>
         * 
         * @param metricName
         *        The name of the metric returned.
         * @see BucketMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The name of the metric returned.
         * </p>
         * 
         * @param metricName
         *        The name of the metric returned.
         * @see BucketMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BucketMetricName
         */
        Builder metricName(BucketMetricName metricName);

        /**
         * <p>
         * An array of objects that describe the metric data returned.
         * </p>
         * 
         * @param metricData
         *        An array of objects that describe the metric data returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatapoint> metricData);

        /**
         * <p>
         * An array of objects that describe the metric data returned.
         * </p>
         * 
         * @param metricData
         *        An array of objects that describe the metric data returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatapoint... metricData);

        /**
         * <p>
         * An array of objects that describe the metric data returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MetricDatapoint>.Builder} avoiding
         * the need to create one manually via {@link List<MetricDatapoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatapoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricData(List<MetricDatapoint>)}.
         * 
         * @param metricData
         *        a consumer that will call methods on {@link List<MetricDatapoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricData(List<MetricDatapoint>)
         */
        Builder metricData(Consumer<MetricDatapoint.Builder>... metricData);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String metricName;

        private List<MetricDatapoint> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketMetricDataResponse model) {
            super(model);
            metricName(model.metricName);
            metricData(model.metricData);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        @Transient
        public final Builder metricName(BucketMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final List<MetricDatapoint.Builder> getMetricData() {
            List<MetricDatapoint.Builder> result = MetricDatapointListCopier.copyToBuilder(this.metricData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        @Transient
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricData(MetricDatapoint... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatapoint.Builder>... metricData) {
            metricData(Stream.of(metricData).map(c -> MetricDatapoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetBucketMetricDataResponse build() {
            return new GetBucketMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
