/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContainerLogResponse extends LightsailResponse implements
        ToCopyableBuilder<GetContainerLogResponse.Builder, GetContainerLogResponse> {
    private static final SdkField<List<ContainerServiceLogEvent>> LOG_EVENTS_FIELD = SdkField
            .<List<ContainerServiceLogEvent>> builder(MarshallingType.LIST)
            .memberName("logEvents")
            .getter(getter(GetContainerLogResponse::logEvents))
            .setter(setter(Builder::logEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerServiceLogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerServiceLogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextPageToken").getter(getter(GetContainerLogResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_EVENTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<ContainerServiceLogEvent> logEvents;

    private final String nextPageToken;

    private GetContainerLogResponse(BuilderImpl builder) {
        super(builder);
        this.logEvents = builder.logEvents;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogEvents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogEvents() {
        return logEvents != null && !(logEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the log events of a container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogEvents} method.
     * </p>
     * 
     * @return An array of objects that describe the log events of a container.
     */
    public final List<ContainerServiceLogEvent> logEvents() {
        return logEvents;
    }

    /**
     * <p>
     * The token to advance to the next page of results from your request.
     * </p>
     * <p>
     * A next page token is not returned if there are no more results to display.
     * </p>
     * <p>
     * To get the next page of results, perform another <code>GetContainerLog</code> request and specify the next page
     * token using the <code>pageToken</code> parameter.
     * </p>
     * 
     * @return The token to advance to the next page of results from your request.</p>
     *         <p>
     *         A next page token is not returned if there are no more results to display.
     *         </p>
     *         <p>
     *         To get the next page of results, perform another <code>GetContainerLog</code> request and specify the
     *         next page token using the <code>pageToken</code> parameter.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLogEvents() ? logEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerLogResponse)) {
            return false;
        }
        GetContainerLogResponse other = (GetContainerLogResponse) obj;
        return hasLogEvents() == other.hasLogEvents() && Objects.equals(logEvents(), other.logEvents())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContainerLogResponse").add("LogEvents", hasLogEvents() ? logEvents() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logEvents":
            return Optional.ofNullable(clazz.cast(logEvents()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContainerLogResponse, T> g) {
        return obj -> g.apply((GetContainerLogResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContainerLogResponse> {
        /**
         * <p>
         * An array of objects that describe the log events of a container.
         * </p>
         * 
         * @param logEvents
         *        An array of objects that describe the log events of a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(Collection<ContainerServiceLogEvent> logEvents);

        /**
         * <p>
         * An array of objects that describe the log events of a container.
         * </p>
         * 
         * @param logEvents
         *        An array of objects that describe the log events of a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(ContainerServiceLogEvent... logEvents);

        /**
         * <p>
         * An array of objects that describe the log events of a container.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ContainerServiceLogEvent>.Builder}
         * avoiding the need to create one manually via {@link List<ContainerServiceLogEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ContainerServiceLogEvent>.Builder#build()} is called
         * immediately and its result is passed to {@link #logEvents(List<ContainerServiceLogEvent>)}.
         * 
         * @param logEvents
         *        a consumer that will call methods on {@link List<ContainerServiceLogEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logEvents(List<ContainerServiceLogEvent>)
         */
        Builder logEvents(Consumer<ContainerServiceLogEvent.Builder>... logEvents);

        /**
         * <p>
         * The token to advance to the next page of results from your request.
         * </p>
         * <p>
         * A next page token is not returned if there are no more results to display.
         * </p>
         * <p>
         * To get the next page of results, perform another <code>GetContainerLog</code> request and specify the next
         * page token using the <code>pageToken</code> parameter.
         * </p>
         * 
         * @param nextPageToken
         *        The token to advance to the next page of results from your request.</p>
         *        <p>
         *        A next page token is not returned if there are no more results to display.
         *        </p>
         *        <p>
         *        To get the next page of results, perform another <code>GetContainerLog</code> request and specify the
         *        next page token using the <code>pageToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<ContainerServiceLogEvent> logEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContainerLogResponse model) {
            super(model);
            logEvents(model.logEvents);
            nextPageToken(model.nextPageToken);
        }

        public final List<ContainerServiceLogEvent.Builder> getLogEvents() {
            List<ContainerServiceLogEvent.Builder> result = ContainerServiceLogEventListCopier.copyToBuilder(this.logEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogEvents(Collection<ContainerServiceLogEvent.BuilderImpl> logEvents) {
            this.logEvents = ContainerServiceLogEventListCopier.copyFromBuilder(logEvents);
        }

        @Override
        @Transient
        public final Builder logEvents(Collection<ContainerServiceLogEvent> logEvents) {
            this.logEvents = ContainerServiceLogEventListCopier.copy(logEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logEvents(ContainerServiceLogEvent... logEvents) {
            logEvents(Arrays.asList(logEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logEvents(Consumer<ContainerServiceLogEvent.Builder>... logEvents) {
            logEvents(Stream.of(logEvents).map(c -> ContainerServiceLogEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetContainerLogResponse build() {
            return new GetContainerLogResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
