/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiskResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDiskResponse.Builder, GetDiskResponse> {
    private static final SdkField<Disk> DISK_FIELD = SdkField.<Disk> builder(MarshallingType.SDK_POJO).memberName("disk")
            .getter(getter(GetDiskResponse::disk)).setter(setter(Builder::disk)).constructor(Disk::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_FIELD));

    private final Disk disk;

    private GetDiskResponse(BuilderImpl builder) {
        super(builder);
        this.disk = builder.disk;
    }

    /**
     * <p>
     * An object containing information about the disk.
     * </p>
     * 
     * @return An object containing information about the disk.
     */
    public final Disk disk() {
        return disk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(disk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiskResponse)) {
            return false;
        }
        GetDiskResponse other = (GetDiskResponse) obj;
        return Objects.equals(disk(), other.disk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDiskResponse").add("Disk", disk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "disk":
            return Optional.ofNullable(clazz.cast(disk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiskResponse, T> g) {
        return obj -> g.apply((GetDiskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDiskResponse> {
        /**
         * <p>
         * An object containing information about the disk.
         * </p>
         * 
         * @param disk
         *        An object containing information about the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disk(Disk disk);

        /**
         * <p>
         * An object containing information about the disk.
         * </p>
         * This is a convenience method that creates an instance of the {@link Disk.Builder} avoiding the need to create
         * one manually via {@link Disk#builder()}.
         *
         * When the {@link Consumer} completes, {@link Disk.Builder#build()} is called immediately and its result is
         * passed to {@link #disk(Disk)}.
         * 
         * @param disk
         *        a consumer that will call methods on {@link Disk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disk(Disk)
         */
        default Builder disk(Consumer<Disk.Builder> disk) {
            return disk(Disk.builder().applyMutation(disk).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private Disk disk;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiskResponse model) {
            super(model);
            disk(model.disk);
        }

        public final Disk.Builder getDisk() {
            return disk != null ? disk.toBuilder() : null;
        }

        public final void setDisk(Disk.BuilderImpl disk) {
            this.disk = disk != null ? disk.build() : null;
        }

        @Override
        @Transient
        public final Builder disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public GetDiskResponse build() {
            return new GetDiskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
