/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of Lightsail's managed renewal for the certificate.
 * </p>
 * <p>
 * The renewal status of the certificate.
 * </p>
 * <p>
 * The following renewal status are possible:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names in the
 * certificate. No further action is required.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names in the
 * certificate. You must take action to validate these domain names or the certificate won't be renewed. If you used DNS
 * validation, check to make sure your certificate's domain validation records exist in your domain's DNS, and that your
 * certificate remains in use.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
 * certificate. No further action is required.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired, and
 * Lightsail did not renew the certificate. You can request a new certificate using the <code>CreateCertificate</code>
 * action.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateRenewalSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificateRenewalSummary.Builder, LoadBalancerTlsCertificateRenewalSummary> {
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("renewalStatus").getter(getter(LoadBalancerTlsCertificateRenewalSummary::renewalStatusAsString))
            .setter(setter(Builder::renewalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatus").build()).build();

    private static final SdkField<List<LoadBalancerTlsCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField
            .<List<LoadBalancerTlsCertificateDomainValidationOption>> builder(MarshallingType.LIST)
            .memberName("domainValidationOptions")
            .getter(getter(LoadBalancerTlsCertificateRenewalSummary::domainValidationOptions))
            .setter(setter(Builder::domainValidationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerTlsCertificateDomainValidationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerTlsCertificateDomainValidationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_STATUS_FIELD,
            DOMAIN_VALIDATION_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String renewalStatus;

    private final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions;

    private LoadBalancerTlsCertificateRenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    /**
     * <p>
     * The renewal status of the certificate.
     * </p>
     * <p>
     * The following renewal status are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names of
     * the certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names of
     * the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check
     * to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate
     * remains in use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
     * certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired, and
     * Lightsail did not renew the certificate. You can request a new certificate using the
     * <code>CreateCertificate</code> action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The renewal status of the certificate.</p>
     *         <p>
     *         The following renewal status are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain
     *         names of the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
     *         names of the certificate. You must take action to validate these domain names or the certificate won't be
     *         renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and
     *         that your certificate remains in use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed
     *         the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
     *         expired, and Lightsail did not renew the certificate. You can request a new certificate using the
     *         <code>CreateCertificate</code> action.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public final LoadBalancerTlsCertificateRenewalStatus renewalStatus() {
        return LoadBalancerTlsCertificateRenewalStatus.fromValue(renewalStatus);
    }

    /**
     * <p>
     * The renewal status of the certificate.
     * </p>
     * <p>
     * The following renewal status are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names of
     * the certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names of
     * the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check
     * to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate
     * remains in use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
     * certificate. No further action is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired, and
     * Lightsail did not renew the certificate. You can request a new certificate using the
     * <code>CreateCertificate</code> action.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The renewal status of the certificate.</p>
     *         <p>
     *         The following renewal status are possible:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain
     *         names of the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
     *         names of the certificate. You must take action to validate these domain names or the certificate won't be
     *         renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and
     *         that your certificate remains in use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed
     *         the certificate. No further action is required.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
     *         expired, and Lightsail did not renew the certificate. You can request a new certificate using the
     *         <code>CreateCertificate</code> action.
     *         </p>
     *         </li>
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public final String renewalStatusAsString() {
        return renewalStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainValidationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainValidationOptions() {
        return domainValidationOptions != null && !(domainValidationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the validation of each domain name in the certificate, as it pertains to Lightsail's
     * managed renewal. This is different from the initial validation that occurs as a result of the RequestCertificate
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainValidationOptions} method.
     * </p>
     * 
     * @return Contains information about the validation of each domain name in the certificate, as it pertains to
     *         Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
     *         RequestCertificate request.
     */
    public final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions() {
        return domainValidationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainValidationOptions() ? domainValidationOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateRenewalSummary)) {
            return false;
        }
        LoadBalancerTlsCertificateRenewalSummary other = (LoadBalancerTlsCertificateRenewalSummary) obj;
        return Objects.equals(renewalStatusAsString(), other.renewalStatusAsString())
                && hasDomainValidationOptions() == other.hasDomainValidationOptions()
                && Objects.equals(domainValidationOptions(), other.domainValidationOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerTlsCertificateRenewalSummary").add("RenewalStatus", renewalStatusAsString())
                .add("DomainValidationOptions", hasDomainValidationOptions() ? domainValidationOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "renewalStatus":
            return Optional.ofNullable(clazz.cast(renewalStatusAsString()));
        case "domainValidationOptions":
            return Optional.ofNullable(clazz.cast(domainValidationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateRenewalSummary, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateRenewalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificateRenewalSummary> {
        /**
         * <p>
         * The renewal status of the certificate.
         * </p>
         * <p>
         * The following renewal status are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names
         * of the certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names
         * of the certificate. You must take action to validate these domain names or the certificate won't be renewed.
         * Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your
         * certificate remains in use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
         * certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired,
         * and Lightsail did not renew the certificate. You can request a new certificate using the
         * <code>CreateCertificate</code> action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param renewalStatus
         *        The renewal status of the certificate.</p>
         *        <p>
         *        The following renewal status are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the
         *        domain names of the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
         *        names of the certificate. You must take action to validate these domain names or the certificate won't
         *        be renewed. Check to make sure your certificate's domain validation records exist in your domain's
         *        DNS, and that your certificate remains in use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail
         *        renewed the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
         *        expired, and Lightsail did not renew the certificate. You can request a new certificate using the
         *        <code>CreateCertificate</code> action.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(String renewalStatus);

        /**
         * <p>
         * The renewal status of the certificate.
         * </p>
         * <p>
         * The following renewal status are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the domain names
         * of the certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain names
         * of the certificate. You must take action to validate these domain names or the certificate won't be renewed.
         * Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your
         * certificate remains in use.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail renewed the
         * certificate. No further action is required.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate expired,
         * and Lightsail did not renew the certificate. You can request a new certificate using the
         * <code>CreateCertificate</code> action.
         * </p>
         * </li>
         * </ul>
         * 
         * @param renewalStatus
         *        The renewal status of the certificate.</p>
         *        <p>
         *        The following renewal status are possible:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>PendingAutoRenewal</code> </b> - Lightsail is attempting to automatically validate the
         *        domain names of the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>PendingValidation</code> </b> - Lightsail couldn't automatically validate one or more domain
         *        names of the certificate. You must take action to validate these domain names or the certificate won't
         *        be renewed. Check to make sure your certificate's domain validation records exist in your domain's
         *        DNS, and that your certificate remains in use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Success</code> </b> - All domain names in the certificate are validated, and Lightsail
         *        renewed the certificate. No further action is required.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>Failed</code> </b> - One or more domain names were not validated before the certificate
         *        expired, and Lightsail did not renew the certificate. You can request a new certificate using the
         *        <code>CreateCertificate</code> action.
         *        </p>
         *        </li>
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder} avoiding the need to create one manually via
         * {@link List<LoadBalancerTlsCertificateDomainValidationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder#build()} is called immediately and its result is
         * passed to {@link #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)}.
         * 
         * @param domainValidationOptions
         *        a consumer that will call methods on {@link List
         *        <LoadBalancerTlsCertificateDomainValidationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)
         */
        Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions);
    }

    static final class BuilderImpl implements Builder {
        private String renewalStatus;

        private List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateRenewalSummary model) {
            renewalStatus(model.renewalStatus);
            domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return renewalStatus;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        @Override
        @Transient
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus == null ? null : renewalStatus.toString());
            return this;
        }

        public final List<LoadBalancerTlsCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            List<LoadBalancerTlsCertificateDomainValidationOption.Builder> result = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copyFromBuilder(domainValidationOptions);
        }

        @Override
        @Transient
        public final Builder domainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copy(domainValidationOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions) {
            domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions) {
            domainValidationOptions(Stream.of(domainValidationOptions)
                    .map(c -> LoadBalancerTlsCertificateDomainValidationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LoadBalancerTlsCertificateRenewalSummary build() {
            return new LoadBalancerTlsCertificateRenewalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
