/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterContainerImageResponse extends LightsailResponse implements
        ToCopyableBuilder<RegisterContainerImageResponse.Builder, RegisterContainerImageResponse> {
    private static final SdkField<ContainerImage> CONTAINER_IMAGE_FIELD = SdkField
            .<ContainerImage> builder(MarshallingType.SDK_POJO).memberName("containerImage")
            .getter(getter(RegisterContainerImageResponse::containerImage)).setter(setter(Builder::containerImage))
            .constructor(ContainerImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerImage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_IMAGE_FIELD));

    private final ContainerImage containerImage;

    private RegisterContainerImageResponse(BuilderImpl builder) {
        super(builder);
        this.containerImage = builder.containerImage;
    }

    /**
     * Returns the value of the ContainerImage property for this object.
     * 
     * @return The value of the ContainerImage property for this object.
     */
    public final ContainerImage containerImage() {
        return containerImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterContainerImageResponse)) {
            return false;
        }
        RegisterContainerImageResponse other = (RegisterContainerImageResponse) obj;
        return Objects.equals(containerImage(), other.containerImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterContainerImageResponse").add("ContainerImage", containerImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containerImage":
            return Optional.ofNullable(clazz.cast(containerImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterContainerImageResponse, T> g) {
        return obj -> g.apply((RegisterContainerImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterContainerImageResponse> {
        /**
         * Sets the value of the ContainerImage property for this object.
         *
         * @param containerImage
         *        The new value for the ContainerImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerImage(ContainerImage containerImage);

        /**
         * Sets the value of the ContainerImage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContainerImage.Builder} avoiding the need
         * to create one manually via {@link ContainerImage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerImage.Builder#build()} is called immediately and its
         * result is passed to {@link #containerImage(ContainerImage)}.
         * 
         * @param containerImage
         *        a consumer that will call methods on {@link ContainerImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerImage(ContainerImage)
         */
        default Builder containerImage(Consumer<ContainerImage.Builder> containerImage) {
            return containerImage(ContainerImage.builder().applyMutation(containerImage).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private ContainerImage containerImage;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterContainerImageResponse model) {
            super(model);
            containerImage(model.containerImage);
        }

        public final ContainerImage.Builder getContainerImage() {
            return containerImage != null ? containerImage.toBuilder() : null;
        }

        public final void setContainerImage(ContainerImage.BuilderImpl containerImage) {
            this.containerImage = containerImage != null ? containerImage.build() : null;
        }

        @Override
        public final Builder containerImage(ContainerImage containerImage) {
            this.containerImage = containerImage;
            return this;
        }

        @Override
        public RegisterContainerImageResponse build() {
            return new RegisterContainerImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
