/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseBundlesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetRelationalDatabaseBundlesRequest> {
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pageToken").getter(GetRelationalDatabaseBundlesRequest.getter(GetRelationalDatabaseBundlesRequest::pageToken)).setter(GetRelationalDatabaseBundlesRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_TOKEN_FIELD));
    private final String pageToken;

    private GetRelationalDatabaseBundlesRequest(BuilderImpl builder) {
        super(builder);
        this.pageToken = builder.pageToken;
    }

    public final String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseBundlesRequest)) {
            return false;
        }
        GetRelationalDatabaseBundlesRequest other = (GetRelationalDatabaseBundlesRequest)((Object)obj);
        return Objects.equals(this.pageToken(), other.pageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseBundlesRequest").add("PageToken", (Object)this.pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseBundlesRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseBundlesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseBundlesRequest model) {
            super(model);
            this.pageToken(model.pageToken);
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseBundlesRequest build() {
            return new GetRelationalDatabaseBundlesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseBundlesRequest> {
        public Builder pageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

