/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDistributionBundlesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDistributionBundlesResponse.Builder, GetDistributionBundlesResponse> {
    private static final SdkField<List<DistributionBundle>> BUNDLES_FIELD = SdkField
            .<List<DistributionBundle>> builder(MarshallingType.LIST)
            .memberName("bundles")
            .getter(getter(GetDistributionBundlesResponse::bundles))
            .setter(setter(Builder::bundles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DistributionBundle> builder(MarshallingType.SDK_POJO)
                                            .constructor(DistributionBundle::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLES_FIELD));

    private final List<DistributionBundle> bundles;

    private GetDistributionBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Bundles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBundles() {
        return bundles != null && !(bundles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes a distribution bundle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBundles} method.
     * </p>
     * 
     * @return An object that describes a distribution bundle.
     */
    public final List<DistributionBundle> bundles() {
        return bundles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBundles() ? bundles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDistributionBundlesResponse)) {
            return false;
        }
        GetDistributionBundlesResponse other = (GetDistributionBundlesResponse) obj;
        return hasBundles() == other.hasBundles() && Objects.equals(bundles(), other.bundles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDistributionBundlesResponse").add("Bundles", hasBundles() ? bundles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bundles":
            return Optional.ofNullable(clazz.cast(bundles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDistributionBundlesResponse, T> g) {
        return obj -> g.apply((GetDistributionBundlesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDistributionBundlesResponse> {
        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * 
         * @param bundles
         *        An object that describes a distribution bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(Collection<DistributionBundle> bundles);

        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * 
         * @param bundles
         *        An object that describes a distribution bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundles(DistributionBundle... bundles);

        /**
         * <p>
         * An object that describes a distribution bundle.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DistributionBundle>.Builder}
         * avoiding the need to create one manually via {@link List<DistributionBundle>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DistributionBundle>.Builder#build()} is called immediately
         * and its result is passed to {@link #bundles(List<DistributionBundle>)}.
         * 
         * @param bundles
         *        a consumer that will call methods on {@link List<DistributionBundle>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bundles(List<DistributionBundle>)
         */
        Builder bundles(Consumer<DistributionBundle.Builder>... bundles);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<DistributionBundle> bundles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDistributionBundlesResponse model) {
            super(model);
            bundles(model.bundles);
        }

        public final List<DistributionBundle.Builder> getBundles() {
            List<DistributionBundle.Builder> result = DistributionBundleListCopier.copyToBuilder(this.bundles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBundles(Collection<DistributionBundle.BuilderImpl> bundles) {
            this.bundles = DistributionBundleListCopier.copyFromBuilder(bundles);
        }

        @Override
        public final Builder bundles(Collection<DistributionBundle> bundles) {
            this.bundles = DistributionBundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(DistributionBundle... bundles) {
            bundles(Arrays.asList(bundles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Consumer<DistributionBundle.Builder>... bundles) {
            bundles(Stream.of(bundles).map(c -> DistributionBundle.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDistributionBundlesResponse build() {
            return new GetDistributionBundlesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
