/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the access log configuration for a bucket in the Amazon Lightsail object storage service.
 * </p>
 * <p>
 * For more information about bucket access logs, see <a
 * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-bucket-access-logs">Logging bucket
 * requests using access logging in Amazon Lightsail</a> in the <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BucketAccessLogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BucketAccessLogConfig.Builder, BucketAccessLogConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(BucketAccessLogConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(BucketAccessLogConfig::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prefix")
            .getter(getter(BucketAccessLogConfig::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DESTINATION_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String destination;

    private final String prefix;

    private BucketAccessLogConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.destination = builder.destination;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * A Boolean value that indicates whether bucket access logging is enabled for the bucket.
     * </p>
     * 
     * @return A Boolean value that indicates whether bucket access logging is enabled for the bucket.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in the same
     * account, and in the same AWS Region as the source bucket.
     * </p>
     * <note>
     * <p>
     * This parameter is required when enabling the access log for a bucket, and should be omitted when disabling the
     * access log.
     * </p>
     * </note>
     * 
     * @return The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in the
     *         same account, and in the same AWS Region as the source bucket.</p> <note>
     *         <p>
     *         This parameter is required when enabling the access log for a bucket, and should be omitted when
     *         disabling the access log.
     *         </p>
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The optional object prefix for the bucket access log.
     * </p>
     * <p>
     * The prefix is an optional addition to the object key that organizes your access log files in the destination
     * bucket. For example, if you specify a <code>logs/</code> prefix, then each log object will begin with the
     * <code>logs/</code> prefix in its key (for example, <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).
     * </p>
     * <note>
     * <p>
     * This parameter can be optionally specified when enabling the access log for a bucket, and should be omitted when
     * disabling the access log.
     * </p>
     * </note>
     * 
     * @return The optional object prefix for the bucket access log.</p>
     *         <p>
     *         The prefix is an optional addition to the object key that organizes your access log files in the
     *         destination bucket. For example, if you specify a <code>logs/</code> prefix, then each log object will
     *         begin with the <code>logs/</code> prefix in its key (for example,
     *         <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).
     *         </p>
     *         <note>
     *         <p>
     *         This parameter can be optionally specified when enabling the access log for a bucket, and should be
     *         omitted when disabling the access log.
     *         </p>
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketAccessLogConfig)) {
            return false;
        }
        BucketAccessLogConfig other = (BucketAccessLogConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(destination(), other.destination())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BucketAccessLogConfig").add("Enabled", enabled()).add("Destination", destination())
                .add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BucketAccessLogConfig, T> g) {
        return obj -> g.apply((BucketAccessLogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BucketAccessLogConfig> {
        /**
         * <p>
         * A Boolean value that indicates whether bucket access logging is enabled for the bucket.
         * </p>
         * 
         * @param enabled
         *        A Boolean value that indicates whether bucket access logging is enabled for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in the same
         * account, and in the same AWS Region as the source bucket.
         * </p>
         * <note>
         * <p>
         * This parameter is required when enabling the access log for a bucket, and should be omitted when disabling
         * the access log.
         * </p>
         * </note>
         * 
         * @param destination
         *        The name of the bucket where the access logs are saved. The destination can be a Lightsail bucket in
         *        the same account, and in the same AWS Region as the source bucket.</p> <note>
         *        <p>
         *        This parameter is required when enabling the access log for a bucket, and should be omitted when
         *        disabling the access log.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The optional object prefix for the bucket access log.
         * </p>
         * <p>
         * The prefix is an optional addition to the object key that organizes your access log files in the destination
         * bucket. For example, if you specify a <code>logs/</code> prefix, then each log object will begin with the
         * <code>logs/</code> prefix in its key (for example, <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).
         * </p>
         * <note>
         * <p>
         * This parameter can be optionally specified when enabling the access log for a bucket, and should be omitted
         * when disabling the access log.
         * </p>
         * </note>
         * 
         * @param prefix
         *        The optional object prefix for the bucket access log.</p>
         *        <p>
         *        The prefix is an optional addition to the object key that organizes your access log files in the
         *        destination bucket. For example, if you specify a <code>logs/</code> prefix, then each log object will
         *        begin with the <code>logs/</code> prefix in its key (for example,
         *        <code>logs/2021-11-01-21-32-16-E568B2907131C0C0</code>).
         *        </p>
         *        <note>
         *        <p>
         *        This parameter can be optionally specified when enabling the access log for a bucket, and should be
         *        omitted when disabling the access log.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String destination;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketAccessLogConfig model) {
            enabled(model.enabled);
            destination(model.destination);
            prefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public BucketAccessLogConfig build() {
            return new BucketAccessLogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
