/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ContainerServiceStateDetailCode {
    CREATING_SYSTEM_RESOURCES("CREATING_SYSTEM_RESOURCES"),

    CREATING_NETWORK_INFRASTRUCTURE("CREATING_NETWORK_INFRASTRUCTURE"),

    PROVISIONING_CERTIFICATE("PROVISIONING_CERTIFICATE"),

    PROVISIONING_SERVICE("PROVISIONING_SERVICE"),

    CREATING_DEPLOYMENT("CREATING_DEPLOYMENT"),

    EVALUATING_HEALTH_CHECK("EVALUATING_HEALTH_CHECK"),

    ACTIVATING_DEPLOYMENT("ACTIVATING_DEPLOYMENT"),

    CERTIFICATE_LIMIT_EXCEEDED("CERTIFICATE_LIMIT_EXCEEDED"),

    UNKNOWN_ERROR("UNKNOWN_ERROR"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerServiceStateDetailCode> VALUE_MAP = EnumUtils.uniqueIndex(
            ContainerServiceStateDetailCode.class, ContainerServiceStateDetailCode::toString);

    private final String value;

    private ContainerServiceStateDetailCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ContainerServiceStateDetailCode corresponding to the value
     */
    public static ContainerServiceStateDetailCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ContainerServiceStateDetailCode}s
     */
    public static Set<ContainerServiceStateDetailCode> knownValues() {
        Set<ContainerServiceStateDetailCode> knownValues = EnumSet.allOf(ContainerServiceStateDetailCode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
