/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a contact method.
 * </p>
 * <p>
 * A contact method is a way to send you notifications. For more information, see <a
 * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications">Notifications in Amazon
 * Lightsail</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactMethod implements SdkPojo, Serializable, ToCopyableBuilder<ContactMethod.Builder, ContactMethod> {
    private static final SdkField<String> CONTACT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contactEndpoint").getter(getter(ContactMethod::contactEndpoint))
            .setter(setter(Builder::contactEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactEndpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ContactMethod::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(ContactMethod::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ContactMethod::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ContactMethod::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(ContactMethod::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).memberName("location").getter(getter(ContactMethod::location))
            .setter(setter(Builder::location)).constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ContactMethod::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportCode").getter(getter(ContactMethod::supportCode)).setter(setter(Builder::supportCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ENDPOINT_FIELD,
            STATUS_FIELD, PROTOCOL_FIELD, NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD,
            SUPPORT_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactEndpoint;

    private final String status;

    private final String protocol;

    private final String name;

    private final String arn;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String supportCode;

    private ContactMethod(BuilderImpl builder) {
        this.contactEndpoint = builder.contactEndpoint;
        this.status = builder.status;
        this.protocol = builder.protocol;
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.supportCode = builder.supportCode;
    }

    /**
     * <p>
     * The destination of the contact method, such as an email address or a mobile phone number.
     * </p>
     * 
     * @return The destination of the contact method, such as an email address or a mobile phone number.
     */
    public final String contactEndpoint() {
        return contactEndpoint;
    }

    /**
     * <p>
     * The current status of the contact method.
     * </p>
     * <p>
     * A contact method has the following possible status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has not yet
     * expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Valid</code> - The contact method has been verified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InValid</code> - An attempt was made to verify the contact method, but the verification has expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactMethodStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the contact method.</p>
     *         <p>
     *         A contact method has the following possible status:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has
     *         not yet expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Valid</code> - The contact method has been verified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InValid</code> - An attempt was made to verify the contact method, but the verification has
     *         expired.
     *         </p>
     *         </li>
     * @see ContactMethodStatus
     */
    public final ContactMethodStatus status() {
        return ContactMethodStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the contact method.
     * </p>
     * <p>
     * A contact method has the following possible status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has not yet
     * expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Valid</code> - The contact method has been verified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>InValid</code> - An attempt was made to verify the contact method, but the verification has expired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactMethodStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the contact method.</p>
     *         <p>
     *         A contact method has the following possible status:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has
     *         not yet expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Valid</code> - The contact method has been verified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>InValid</code> - An attempt was made to verify the contact method, but the verification has
     *         expired.
     *         </p>
     *         </li>
     * @see ContactMethodStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The protocol of the contact method, such as email or SMS (text messaging).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the contact method, such as email or SMS (text messaging).
     * @see ContactProtocol
     */
    public final ContactProtocol protocol() {
        return ContactProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol of the contact method, such as email or SMS (text messaging).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ContactProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the contact method, such as email or SMS (text messaging).
     * @see ContactProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The name of the contact method.
     * </p>
     * 
     * @return The name of the contact method.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact method.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp when the contact method was created.
     * </p>
     * 
     * @return The timestamp when the contact method was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An object that describes the location of the contact method, such as the Amazon Web Services Region and
     * Availability Zone.
     * </p>
     * 
     * @return An object that describes the location of the contact method, such as the Amazon Web Services Region and
     *         Availability Zone.
     */
    public final ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>ContactMethod</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>ContactMethod</code>).
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>ContactMethod</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>ContactMethod</code>).
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about your Lightsail contact
     * method. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about your Lightsail
     *         contact method. This code enables our support team to look up your Lightsail information more easily.
     */
    public final String supportCode() {
        return supportCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactMethod)) {
            return false;
        }
        ContactMethod other = (ContactMethod) obj;
        return Objects.equals(contactEndpoint(), other.contactEndpoint())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(supportCode(), other.supportCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactMethod").add("ContactEndpoint", contactEndpoint()).add("Status", statusAsString())
                .add("Protocol", protocolAsString()).add("Name", name()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Location", location()).add("ResourceType", resourceTypeAsString()).add("SupportCode", supportCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contactEndpoint":
            return Optional.ofNullable(clazz.cast(contactEndpoint()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "supportCode":
            return Optional.ofNullable(clazz.cast(supportCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactMethod, T> g) {
        return obj -> g.apply((ContactMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactMethod> {
        /**
         * <p>
         * The destination of the contact method, such as an email address or a mobile phone number.
         * </p>
         * 
         * @param contactEndpoint
         *        The destination of the contact method, such as an email address or a mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactEndpoint(String contactEndpoint);

        /**
         * <p>
         * The current status of the contact method.
         * </p>
         * <p>
         * A contact method has the following possible status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has not
         * yet expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Valid</code> - The contact method has been verified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InValid</code> - An attempt was made to verify the contact method, but the verification has expired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the contact method.</p>
         *        <p>
         *        A contact method has the following possible status:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PendingVerification</code> - The contact method has not yet been verified, and the verification
         *        has not yet expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Valid</code> - The contact method has been verified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InValid</code> - An attempt was made to verify the contact method, but the verification has
         *        expired.
         *        </p>
         *        </li>
         * @see ContactMethodStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMethodStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the contact method.
         * </p>
         * <p>
         * A contact method has the following possible status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PendingVerification</code> - The contact method has not yet been verified, and the verification has not
         * yet expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Valid</code> - The contact method has been verified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>InValid</code> - An attempt was made to verify the contact method, but the verification has expired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the contact method.</p>
         *        <p>
         *        A contact method has the following possible status:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PendingVerification</code> - The contact method has not yet been verified, and the verification
         *        has not yet expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Valid</code> - The contact method has been verified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>InValid</code> - An attempt was made to verify the contact method, but the verification has
         *        expired.
         *        </p>
         *        </li>
         * @see ContactMethodStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactMethodStatus
         */
        Builder status(ContactMethodStatus status);

        /**
         * <p>
         * The protocol of the contact method, such as email or SMS (text messaging).
         * </p>
         * 
         * @param protocol
         *        The protocol of the contact method, such as email or SMS (text messaging).
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol of the contact method, such as email or SMS (text messaging).
         * </p>
         * 
         * @param protocol
         *        The protocol of the contact method, such as email or SMS (text messaging).
         * @see ContactProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactProtocol
         */
        Builder protocol(ContactProtocol protocol);

        /**
         * <p>
         * The name of the contact method.
         * </p>
         * 
         * @param name
         *        The name of the contact method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact method.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the contact method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp when the contact method was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the contact method was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An object that describes the location of the contact method, such as the Amazon Web Services Region and
         * Availability Zone.
         * </p>
         * 
         * @param location
         *        An object that describes the location of the contact method, such as the Amazon Web Services Region
         *        and Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * An object that describes the location of the contact method, such as the Amazon Web Services Region and
         * Availability Zone.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceLocation.Builder} avoiding the
         * need to create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>ContactMethod</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>ContactMethod</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>ContactMethod</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>ContactMethod</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about your Lightsail
         * contact method. This code enables our support team to look up your Lightsail information more easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about your
         *        Lightsail contact method. This code enables our support team to look up your Lightsail information
         *        more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);
    }

    static final class BuilderImpl implements Builder {
        private String contactEndpoint;

        private String status;

        private String protocol;

        private String name;

        private String arn;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String supportCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactMethod model) {
            contactEndpoint(model.contactEndpoint);
            status(model.status);
            protocol(model.protocol);
            name(model.name);
            arn(model.arn);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            supportCode(model.supportCode);
        }

        public final String getContactEndpoint() {
            return contactEndpoint;
        }

        public final void setContactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
        }

        @Override
        public final Builder contactEndpoint(String contactEndpoint) {
            this.contactEndpoint = contactEndpoint;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContactMethodStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ContactProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        @Override
        public ContactMethod build() {
            return new ContactMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
