/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketBundlesRequest extends LightsailRequest implements
        ToCopyableBuilder<GetBucketBundlesRequest.Builder, GetBucketBundlesRequest> {
    private static final SdkField<Boolean> INCLUDE_INACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeInactive").getter(getter(GetBucketBundlesRequest::includeInactive))
            .setter(setter(Builder::includeInactive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeInactive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_INACTIVE_FIELD));

    private final Boolean includeInactive;

    private GetBucketBundlesRequest(BuilderImpl builder) {
        super(builder);
        this.includeInactive = builder.includeInactive;
    }

    /**
     * <p>
     * A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.
     * </p>
     * 
     * @return A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.
     */
    public final Boolean includeInactive() {
        return includeInactive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(includeInactive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketBundlesRequest)) {
            return false;
        }
        GetBucketBundlesRequest other = (GetBucketBundlesRequest) obj;
        return Objects.equals(includeInactive(), other.includeInactive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketBundlesRequest").add("IncludeInactive", includeInactive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeInactive":
            return Optional.ofNullable(clazz.cast(includeInactive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketBundlesRequest, T> g) {
        return obj -> g.apply((GetBucketBundlesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketBundlesRequest> {
        /**
         * <p>
         * A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.
         * </p>
         * 
         * @param includeInactive
         *        A Boolean value that indicates whether to include inactive (unavailable) bundles in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeInactive(Boolean includeInactive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private Boolean includeInactive;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketBundlesRequest model) {
            super(model);
            includeInactive(model.includeInactive);
        }

        public final Boolean getIncludeInactive() {
            return includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBucketBundlesRequest build() {
            return new GetBucketBundlesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
