/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an automatic snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoSnapshotDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoSnapshotDetails.Builder, AutoSnapshotDetails> {
    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("date")
            .getter(getter(AutoSnapshotDetails::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("date").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AutoSnapshotDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AutoSnapshotDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<AttachedDisk>> FROM_ATTACHED_DISKS_FIELD = SdkField
            .<List<AttachedDisk>> builder(MarshallingType.LIST)
            .memberName("fromAttachedDisks")
            .getter(getter(AutoSnapshotDetails::fromAttachedDisks))
            .setter(setter(Builder::fromAttachedDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromAttachedDisks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, CREATED_AT_FIELD,
            STATUS_FIELD, FROM_ATTACHED_DISKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String date;

    private final Instant createdAt;

    private final String status;

    private final List<AttachedDisk> fromAttachedDisks;

    private AutoSnapshotDetails(BuilderImpl builder) {
        this.date = builder.date;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.fromAttachedDisks = builder.fromAttachedDisks;
    }

    /**
     * <p>
     * The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.
     * </p>
     * 
     * @return The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.
     */
    public final String date() {
        return date;
    }

    /**
     * <p>
     * The timestamp when the automatic snapshot was created.
     * </p>
     * 
     * @return The timestamp when the automatic snapshot was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The status of the automatic snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutoSnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the automatic snapshot.
     * @see AutoSnapshotStatus
     */
    public final AutoSnapshotStatus status() {
        return AutoSnapshotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the automatic snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutoSnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the automatic snapshot.
     * @see AutoSnapshotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the FromAttachedDisks property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFromAttachedDisks() {
        return fromAttachedDisks != null && !(fromAttachedDisks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects that describe the block storage disks attached to the instance when the automatic snapshot
     * was created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFromAttachedDisks} method.
     * </p>
     * 
     * @return An array of objects that describe the block storage disks attached to the instance when the automatic
     *         snapshot was created.
     */
    public final List<AttachedDisk> fromAttachedDisks() {
        return fromAttachedDisks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFromAttachedDisks() ? fromAttachedDisks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoSnapshotDetails)) {
            return false;
        }
        AutoSnapshotDetails other = (AutoSnapshotDetails) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasFromAttachedDisks() == other.hasFromAttachedDisks()
                && Objects.equals(fromAttachedDisks(), other.fromAttachedDisks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoSnapshotDetails").add("Date", date()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("FromAttachedDisks", hasFromAttachedDisks() ? fromAttachedDisks() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "date":
            return Optional.ofNullable(clazz.cast(date()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "fromAttachedDisks":
            return Optional.ofNullable(clazz.cast(fromAttachedDisks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoSnapshotDetails, T> g) {
        return obj -> g.apply((AutoSnapshotDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoSnapshotDetails> {
        /**
         * <p>
         * The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.
         * </p>
         * 
         * @param date
         *        The date of the automatic snapshot in <code>YYYY-MM-DD</code> format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);

        /**
         * <p>
         * The timestamp when the automatic snapshot was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the automatic snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The status of the automatic snapshot.
         * </p>
         * 
         * @param status
         *        The status of the automatic snapshot.
         * @see AutoSnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoSnapshotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the automatic snapshot.
         * </p>
         * 
         * @param status
         *        The status of the automatic snapshot.
         * @see AutoSnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoSnapshotStatus
         */
        Builder status(AutoSnapshotStatus status);

        /**
         * <p>
         * An array of objects that describe the block storage disks attached to the instance when the automatic
         * snapshot was created.
         * </p>
         * 
         * @param fromAttachedDisks
         *        An array of objects that describe the block storage disks attached to the instance when the automatic
         *        snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAttachedDisks(Collection<AttachedDisk> fromAttachedDisks);

        /**
         * <p>
         * An array of objects that describe the block storage disks attached to the instance when the automatic
         * snapshot was created.
         * </p>
         * 
         * @param fromAttachedDisks
         *        An array of objects that describe the block storage disks attached to the instance when the automatic
         *        snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAttachedDisks(AttachedDisk... fromAttachedDisks);

        /**
         * <p>
         * An array of objects that describe the block storage disks attached to the instance when the automatic
         * snapshot was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AttachedDisk>.Builder} avoiding the
         * need to create one manually via {@link List<AttachedDisk>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachedDisk>.Builder#build()} is called immediately and its
         * result is passed to {@link #fromAttachedDisks(List<AttachedDisk>)}.
         * 
         * @param fromAttachedDisks
         *        a consumer that will call methods on {@link List<AttachedDisk>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromAttachedDisks(List<AttachedDisk>)
         */
        Builder fromAttachedDisks(Consumer<AttachedDisk.Builder>... fromAttachedDisks);
    }

    static final class BuilderImpl implements Builder {
        private String date;

        private Instant createdAt;

        private String status;

        private List<AttachedDisk> fromAttachedDisks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoSnapshotDetails model) {
            date(model.date);
            createdAt(model.createdAt);
            status(model.status);
            fromAttachedDisks(model.fromAttachedDisks);
        }

        public final String getDate() {
            return date;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoSnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AttachedDisk.Builder> getFromAttachedDisks() {
            List<AttachedDisk.Builder> result = AttachedDiskListCopier.copyToBuilder(this.fromAttachedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFromAttachedDisks(Collection<AttachedDisk.BuilderImpl> fromAttachedDisks) {
            this.fromAttachedDisks = AttachedDiskListCopier.copyFromBuilder(fromAttachedDisks);
        }

        @Override
        public final Builder fromAttachedDisks(Collection<AttachedDisk> fromAttachedDisks) {
            this.fromAttachedDisks = AttachedDiskListCopier.copy(fromAttachedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(AttachedDisk... fromAttachedDisks) {
            fromAttachedDisks(Arrays.asList(fromAttachedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fromAttachedDisks(Consumer<AttachedDisk.Builder>... fromAttachedDisks) {
            fromAttachedDisks(Stream.of(fromAttachedDisks).map(c -> AttachedDisk.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutoSnapshotDetails build() {
            return new AutoSnapshotDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
