/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerServiceDeploymentRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateContainerServiceDeploymentRequest.Builder, CreateContainerServiceDeploymentRequest> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateContainerServiceDeploymentRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<Map<String, Container>> CONTAINERS_FIELD = SdkField
            .<Map<String, Container>> builder(MarshallingType.MAP)
            .memberName("containers")
            .getter(getter(CreateContainerServiceDeploymentRequest::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Container> builder(MarshallingType.SDK_POJO)
                                            .constructor(Container::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<EndpointRequest> PUBLIC_ENDPOINT_FIELD = SdkField
            .<EndpointRequest> builder(MarshallingType.SDK_POJO).memberName("publicEndpoint")
            .getter(getter(CreateContainerServiceDeploymentRequest::publicEndpoint)).setter(setter(Builder::publicEndpoint))
            .constructor(EndpointRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            CONTAINERS_FIELD, PUBLIC_ENDPOINT_FIELD));

    private final String serviceName;

    private final Map<String, Container> containers;

    private final EndpointRequest publicEndpoint;

    private CreateContainerServiceDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceName = builder.serviceName;
        this.containers = builder.containers;
        this.publicEndpoint = builder.publicEndpoint;
    }

    /**
     * <p>
     * The name of the container service for which to create the deployment.
     * </p>
     * 
     * @return The name of the container service for which to create the deployment.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that describes the settings of the containers that will be launched on the container service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return An object that describes the settings of the containers that will be launched on the container service.
     */
    public final Map<String, Container> containers() {
        return containers;
    }

    /**
     * <p>
     * An object that describes the settings of the public endpoint for the container service.
     * </p>
     * 
     * @return An object that describes the settings of the public endpoint for the container service.
     */
    public final EndpointRequest publicEndpoint() {
        return publicEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerServiceDeploymentRequest)) {
            return false;
        }
        CreateContainerServiceDeploymentRequest other = (CreateContainerServiceDeploymentRequest) obj;
        return Objects.equals(serviceName(), other.serviceName()) && hasContainers() == other.hasContainers()
                && Objects.equals(containers(), other.containers()) && Objects.equals(publicEndpoint(), other.publicEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerServiceDeploymentRequest").add("ServiceName", serviceName())
                .add("Containers", hasContainers() ? containers() : null).add("PublicEndpoint", publicEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "publicEndpoint":
            return Optional.ofNullable(clazz.cast(publicEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerServiceDeploymentRequest, T> g) {
        return obj -> g.apply((CreateContainerServiceDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateContainerServiceDeploymentRequest> {
        /**
         * <p>
         * The name of the container service for which to create the deployment.
         * </p>
         * 
         * @param serviceName
         *        The name of the container service for which to create the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * An object that describes the settings of the containers that will be launched on the container service.
         * </p>
         * 
         * @param containers
         *        An object that describes the settings of the containers that will be launched on the container
         *        service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Map<String, Container> containers);

        /**
         * <p>
         * An object that describes the settings of the public endpoint for the container service.
         * </p>
         * 
         * @param publicEndpoint
         *        An object that describes the settings of the public endpoint for the container service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicEndpoint(EndpointRequest publicEndpoint);

        /**
         * <p>
         * An object that describes the settings of the public endpoint for the container service.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointRequest.Builder} avoiding the
         * need to create one manually via {@link EndpointRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #publicEndpoint(EndpointRequest)}.
         * 
         * @param publicEndpoint
         *        a consumer that will call methods on {@link EndpointRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicEndpoint(EndpointRequest)
         */
        default Builder publicEndpoint(Consumer<EndpointRequest.Builder> publicEndpoint) {
            return publicEndpoint(EndpointRequest.builder().applyMutation(publicEndpoint).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String serviceName;

        private Map<String, Container> containers = DefaultSdkAutoConstructMap.getInstance();

        private EndpointRequest publicEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerServiceDeploymentRequest model) {
            super(model);
            serviceName(model.serviceName);
            containers(model.containers);
            publicEndpoint(model.publicEndpoint);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Map<String, Container.Builder> getContainers() {
            Map<String, Container.Builder> result = ContainerMapCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setContainers(Map<String, Container.BuilderImpl> containers) {
            this.containers = ContainerMapCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Map<String, Container> containers) {
            this.containers = ContainerMapCopier.copy(containers);
            return this;
        }

        public final EndpointRequest.Builder getPublicEndpoint() {
            return publicEndpoint != null ? publicEndpoint.toBuilder() : null;
        }

        public final void setPublicEndpoint(EndpointRequest.BuilderImpl publicEndpoint) {
            this.publicEndpoint = publicEndpoint != null ? publicEndpoint.build() : null;
        }

        @Override
        public final Builder publicEndpoint(EndpointRequest publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContainerServiceDeploymentRequest build() {
            return new CreateContainerServiceDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
