/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration for an Amazon Lightsail container service to access private container image repositories,
 * such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access"
 * >Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the
 * <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateRegistryAccess implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateRegistryAccess.Builder, PrivateRegistryAccess> {
    private static final SdkField<ContainerServiceECRImagePullerRole> ECR_IMAGE_PULLER_ROLE_FIELD = SdkField
            .<ContainerServiceECRImagePullerRole> builder(MarshallingType.SDK_POJO).memberName("ecrImagePullerRole")
            .getter(getter(PrivateRegistryAccess::ecrImagePullerRole)).setter(setter(Builder::ecrImagePullerRole))
            .constructor(ContainerServiceECRImagePullerRole::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImagePullerRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_IMAGE_PULLER_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContainerServiceECRImagePullerRole ecrImagePullerRole;

    private PrivateRegistryAccess(BuilderImpl builder) {
        this.ecrImagePullerRole = builder.ecrImagePullerRole;
    }

    /**
     * <p>
     * An object that describes the activation status of the role that you can use to grant a Lightsail container
     * service access to Amazon ECR private repositories. If the role is activated, the Amazon Resource Name (ARN) of
     * the role is also listed.
     * </p>
     * 
     * @return An object that describes the activation status of the role that you can use to grant a Lightsail
     *         container service access to Amazon ECR private repositories. If the role is activated, the Amazon
     *         Resource Name (ARN) of the role is also listed.
     */
    public final ContainerServiceECRImagePullerRole ecrImagePullerRole() {
        return ecrImagePullerRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecrImagePullerRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateRegistryAccess)) {
            return false;
        }
        PrivateRegistryAccess other = (PrivateRegistryAccess) obj;
        return Objects.equals(ecrImagePullerRole(), other.ecrImagePullerRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateRegistryAccess").add("EcrImagePullerRole", ecrImagePullerRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrImagePullerRole":
            return Optional.ofNullable(clazz.cast(ecrImagePullerRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateRegistryAccess, T> g) {
        return obj -> g.apply((PrivateRegistryAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateRegistryAccess> {
        /**
         * <p>
         * An object that describes the activation status of the role that you can use to grant a Lightsail container
         * service access to Amazon ECR private repositories. If the role is activated, the Amazon Resource Name (ARN)
         * of the role is also listed.
         * </p>
         * 
         * @param ecrImagePullerRole
         *        An object that describes the activation status of the role that you can use to grant a Lightsail
         *        container service access to Amazon ECR private repositories. If the role is activated, the Amazon
         *        Resource Name (ARN) of the role is also listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImagePullerRole(ContainerServiceECRImagePullerRole ecrImagePullerRole);

        /**
         * <p>
         * An object that describes the activation status of the role that you can use to grant a Lightsail container
         * service access to Amazon ECR private repositories. If the role is activated, the Amazon Resource Name (ARN)
         * of the role is also listed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerServiceECRImagePullerRole.Builder} avoiding the need to create one manually via
         * {@link ContainerServiceECRImagePullerRole#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerServiceECRImagePullerRole.Builder#build()} is called
         * immediately and its result is passed to {@link #ecrImagePullerRole(ContainerServiceECRImagePullerRole)}.
         * 
         * @param ecrImagePullerRole
         *        a consumer that will call methods on {@link ContainerServiceECRImagePullerRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImagePullerRole(ContainerServiceECRImagePullerRole)
         */
        default Builder ecrImagePullerRole(Consumer<ContainerServiceECRImagePullerRole.Builder> ecrImagePullerRole) {
            return ecrImagePullerRole(ContainerServiceECRImagePullerRole.builder().applyMutation(ecrImagePullerRole).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerServiceECRImagePullerRole ecrImagePullerRole;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateRegistryAccess model) {
            ecrImagePullerRole(model.ecrImagePullerRole);
        }

        public final ContainerServiceECRImagePullerRole.Builder getEcrImagePullerRole() {
            return ecrImagePullerRole != null ? ecrImagePullerRole.toBuilder() : null;
        }

        public final void setEcrImagePullerRole(ContainerServiceECRImagePullerRole.BuilderImpl ecrImagePullerRole) {
            this.ecrImagePullerRole = ecrImagePullerRole != null ? ecrImagePullerRole.build() : null;
        }

        @Override
        public final Builder ecrImagePullerRole(ContainerServiceECRImagePullerRole ecrImagePullerRole) {
            this.ecrImagePullerRole = ecrImagePullerRole;
            return this;
        }

        @Override
        public PrivateRegistryAccess build() {
            return new PrivateRegistryAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
