/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceSnapshotResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceSnapshotResponse.Builder, GetInstanceSnapshotResponse> {
    private static final SdkField<InstanceSnapshot> INSTANCE_SNAPSHOT_FIELD = SdkField
            .<InstanceSnapshot> builder(MarshallingType.SDK_POJO).memberName("instanceSnapshot")
            .getter(getter(GetInstanceSnapshotResponse::instanceSnapshot)).setter(setter(Builder::instanceSnapshot))
            .constructor(InstanceSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SNAPSHOT_FIELD));

    private final InstanceSnapshot instanceSnapshot;

    private GetInstanceSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshot = builder.instanceSnapshot;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance snapshot request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance snapshot
     *         request.
     */
    public final InstanceSnapshot instanceSnapshot() {
        return instanceSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceSnapshotResponse)) {
            return false;
        }
        GetInstanceSnapshotResponse other = (GetInstanceSnapshotResponse) obj;
        return Objects.equals(instanceSnapshot(), other.instanceSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInstanceSnapshotResponse").add("InstanceSnapshot", instanceSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceSnapshot":
            return Optional.ofNullable(clazz.cast(instanceSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceSnapshotResponse, T> g) {
        return obj -> g.apply((GetInstanceSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceSnapshotResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshot request.
         * </p>
         * 
         * @param instanceSnapshot
         *        An array of key-value pairs containing information about the results of your get instance snapshot
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshot(InstanceSnapshot instanceSnapshot);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance snapshot request.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceSnapshot.Builder} avoiding the
         * need to create one manually via {@link InstanceSnapshot#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceSnapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceSnapshot(InstanceSnapshot)}.
         * 
         * @param instanceSnapshot
         *        a consumer that will call methods on {@link InstanceSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceSnapshot(InstanceSnapshot)
         */
        default Builder instanceSnapshot(Consumer<InstanceSnapshot.Builder> instanceSnapshot) {
            return instanceSnapshot(InstanceSnapshot.builder().applyMutation(instanceSnapshot).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private InstanceSnapshot instanceSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceSnapshotResponse model) {
            super(model);
            instanceSnapshot(model.instanceSnapshot);
        }

        public final InstanceSnapshot.Builder getInstanceSnapshot() {
            return instanceSnapshot != null ? instanceSnapshot.toBuilder() : null;
        }

        public final void setInstanceSnapshot(InstanceSnapshot.BuilderImpl instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot != null ? instanceSnapshot.build() : null;
        }

        @Override
        public final Builder instanceSnapshot(InstanceSnapshot instanceSnapshot) {
            this.instanceSnapshot = instanceSnapshot;
            return this;
        }

        @Override
        public GetInstanceSnapshotResponse build() {
            return new GetInstanceSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
