/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a request to configure an Amazon Lightsail container service to access private container image
 * repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access"
 * >Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the
 * <i>Amazon Lightsail Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateRegistryAccessRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateRegistryAccessRequest.Builder, PrivateRegistryAccessRequest> {
    private static final SdkField<ContainerServiceECRImagePullerRoleRequest> ECR_IMAGE_PULLER_ROLE_FIELD = SdkField
            .<ContainerServiceECRImagePullerRoleRequest> builder(MarshallingType.SDK_POJO).memberName("ecrImagePullerRole")
            .getter(getter(PrivateRegistryAccessRequest::ecrImagePullerRole)).setter(setter(Builder::ecrImagePullerRole))
            .constructor(ContainerServiceECRImagePullerRoleRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrImagePullerRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_IMAGE_PULLER_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole;

    private PrivateRegistryAccessRequest(BuilderImpl builder) {
        this.ecrImagePullerRole = builder.ecrImagePullerRole;
    }

    /**
     * <p>
     * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon Lightsail
     * container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
     * </p>
     * 
     * @return An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
     *         Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private
     *         repositories.
     */
    public final ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole() {
        return ecrImagePullerRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecrImagePullerRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateRegistryAccessRequest)) {
            return false;
        }
        PrivateRegistryAccessRequest other = (PrivateRegistryAccessRequest) obj;
        return Objects.equals(ecrImagePullerRole(), other.ecrImagePullerRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateRegistryAccessRequest").add("EcrImagePullerRole", ecrImagePullerRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrImagePullerRole":
            return Optional.ofNullable(clazz.cast(ecrImagePullerRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrivateRegistryAccessRequest, T> g) {
        return obj -> g.apply((PrivateRegistryAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateRegistryAccessRequest> {
        /**
         * <p>
         * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
         * Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
         * </p>
         * 
         * @param ecrImagePullerRole
         *        An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
         *        Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private
         *        repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrImagePullerRole(ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole);

        /**
         * <p>
         * An object to describe a request to activate or deactivate the role that you can use to grant an Amazon
         * Lightsail container service access to Amazon Elastic Container Registry (Amazon ECR) private repositories.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ContainerServiceECRImagePullerRoleRequest.Builder} avoiding the need to create one manually via
         * {@link ContainerServiceECRImagePullerRoleRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContainerServiceECRImagePullerRoleRequest.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #ecrImagePullerRole(ContainerServiceECRImagePullerRoleRequest)}.
         * 
         * @param ecrImagePullerRole
         *        a consumer that will call methods on {@link ContainerServiceECRImagePullerRoleRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecrImagePullerRole(ContainerServiceECRImagePullerRoleRequest)
         */
        default Builder ecrImagePullerRole(Consumer<ContainerServiceECRImagePullerRoleRequest.Builder> ecrImagePullerRole) {
            return ecrImagePullerRole(ContainerServiceECRImagePullerRoleRequest.builder().applyMutation(ecrImagePullerRole)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateRegistryAccessRequest model) {
            ecrImagePullerRole(model.ecrImagePullerRole);
        }

        public final ContainerServiceECRImagePullerRoleRequest.Builder getEcrImagePullerRole() {
            return ecrImagePullerRole != null ? ecrImagePullerRole.toBuilder() : null;
        }

        public final void setEcrImagePullerRole(ContainerServiceECRImagePullerRoleRequest.BuilderImpl ecrImagePullerRole) {
            this.ecrImagePullerRole = ecrImagePullerRole != null ? ecrImagePullerRole.build() : null;
        }

        @Override
        public final Builder ecrImagePullerRole(ContainerServiceECRImagePullerRoleRequest ecrImagePullerRole) {
            this.ecrImagePullerRole = ecrImagePullerRole;
            return this;
        }

        @Override
        public PrivateRegistryAccessRequest build() {
            return new PrivateRegistryAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
