/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstancesRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateInstancesRequest.Builder, CreateInstancesRequest> {
    private static final SdkField<List<String>> INSTANCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("instanceNames")
            .getter(getter(CreateInstancesRequest::instanceNames))
            .setter(setter(Builder::instanceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateInstancesRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> CUSTOM_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customImageName").getter(getter(CreateInstancesRequest::customImageName))
            .setter(setter(Builder::customImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customImageName").build()).build();

    private static final SdkField<String> BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blueprintId").getter(getter(CreateInstancesRequest::blueprintId)).setter(setter(Builder::blueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintId").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bundleId").getter(getter(CreateInstancesRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userData").getter(getter(CreateInstancesRequest::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userData").build()).build();

    private static final SdkField<String> KEY_PAIR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyPairName").getter(getter(CreateInstancesRequest::keyPairName)).setter(setter(Builder::keyPairName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPairName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateInstancesRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AddOnRequest>> ADD_ONS_FIELD = SdkField
            .<List<AddOnRequest>> builder(MarshallingType.LIST)
            .memberName("addOns")
            .getter(getter(CreateInstancesRequest::addOns))
            .setter(setter(Builder::addOns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddOnRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddOnRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(CreateInstancesRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAMES_FIELD,
            AVAILABILITY_ZONE_FIELD, CUSTOM_IMAGE_NAME_FIELD, BLUEPRINT_ID_FIELD, BUNDLE_ID_FIELD, USER_DATA_FIELD,
            KEY_PAIR_NAME_FIELD, TAGS_FIELD, ADD_ONS_FIELD, IP_ADDRESS_TYPE_FIELD));

    private final List<String> instanceNames;

    private final String availabilityZone;

    private final String customImageName;

    private final String blueprintId;

    private final String bundleId;

    private final String userData;

    private final String keyPairName;

    private final List<Tag> tags;

    private final List<AddOnRequest> addOns;

    private final String ipAddressType;

    private CreateInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
        this.tags = builder.tags;
        this.addOns = builder.addOns;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceNames() {
        return instanceNames != null && !(instanceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for
     * example: <code>["MyFirstInstance","MySecondInstance"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceNames} method.
     * </p>
     * 
     * @return The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
     *         commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
     */
    public final List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * <p>
     * The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code> (case
     * sensitive). You can get a list of Availability Zones by using the <a
     * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     * operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code>
     *         (case sensitive). You can get a list of Availability Zones by using the <a
     *         href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     *         operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * (Deprecated) The name for your custom image.
     * </p>
     * <note>
     * <p>
     * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
     * </p>
     * </note>
     * 
     * @return (Deprecated) The name for your custom image.</p> <note>
     *         <p>
     *         In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
     *         </p>
     * @deprecated
     */
    @Deprecated
    public final String customImageName() {
        return customImageName;
    }

    /**
     * <p>
     * The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).
     * Use the <code>get blueprints</code> operation to return a list of available images (or <i>blueprints</i>).
     * </p>
     * <note>
     * <p>
     * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
     * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive when
     * they become outdated due to operating system updates or new application releases.
     * </p>
     * </note>
     * 
     * @return The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
     *         <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list of available
     *         images (or <i>blueprints</i>).</p> <note>
     *         <p>
     *         Use active blueprints when creating new instances. Inactive blueprints are listed to support customers
     *         with existing instances and are not necessarily available to create new instances. Blueprints are marked
     *         inactive when they become outdated due to operating system updates or new application releases.
     *         </p>
     */
    public final String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
     * pricing plan (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle of specification information for your virtual private server (or <i>instance</i>), including
     *         the pricing plan (e.g., <code>micro_1_0</code>).
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * A launch script you can create that configures a server with additional user data. For example, you might want to
     * run <code>apt-get -y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a
     * complete list, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
     * >Amazon Lightsail Developer Guide</a>.
     * </p>
     * </note>
     * 
     * @return A launch script you can create that configures a server with additional user data. For example, you might
     *         want to run <code>apt-get -y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>. For a complete list, see the <a
     *         href="https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
     *         >Amazon Lightsail Developer Guide</a>.
     *         </p>
     */
    public final String userData() {
        return userData;
    }

    /**
     * <p>
     * The name of your key pair.
     * </p>
     * 
     * @return The name of your key pair.
     */
    public final String keyPairName() {
        return keyPairName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values to add to the resource during create.
     * </p>
     * <p>
     * Use the <code>TagResource</code> action to tag a resource after it's created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values to add to the resource during create.</p>
     *         <p>
     *         Use the <code>TagResource</code> action to tag a resource after it's created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddOns() {
        return addOns != null && !(addOns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects representing the add-ons to enable for the new instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOns} method.
     * </p>
     * 
     * @return An array of objects representing the add-ons to enable for the new instance.
     */
    public final List<AddOnRequest> addOns() {
        return addOns;
    }

    /**
     * <p>
     * The IP address type for the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the instance.
     * </p>
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     * </p>
     * <p>
     * The default value is <code>dualstack</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the instance.</p>
     *         <p>
     *         The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
     *         </p>
     *         <p>
     *         The default value is <code>dualstack</code>.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceNames() ? instanceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(customImageName());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOns() ? addOns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest) obj;
        return hasInstanceNames() == other.hasInstanceNames() && Objects.equals(instanceNames(), other.instanceNames())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(customImageName(), other.customImageName())
                && Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(userData(), other.userData()) && Objects.equals(keyPairName(), other.keyPairName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasAddOns() == other.hasAddOns()
                && Objects.equals(addOns(), other.addOns())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstancesRequest").add("InstanceNames", hasInstanceNames() ? instanceNames() : null)
                .add("AvailabilityZone", availabilityZone()).add("CustomImageName", customImageName())
                .add("BlueprintId", blueprintId()).add("BundleId", bundleId()).add("UserData", userData())
                .add("KeyPairName", keyPairName()).add("Tags", hasTags() ? tags() : null)
                .add("AddOns", hasAddOns() ? addOns() : null).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceNames":
            return Optional.ofNullable(clazz.cast(instanceNames()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "customImageName":
            return Optional.ofNullable(clazz.cast(customImageName()));
        case "blueprintId":
            return Optional.ofNullable(clazz.cast(blueprintId()));
        case "bundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "userData":
            return Optional.ofNullable(clazz.cast(userData()));
        case "keyPairName":
            return Optional.ofNullable(clazz.cast(keyPairName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "addOns":
            return Optional.ofNullable(clazz.cast(addOns()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstancesRequest, T> g) {
        return obj -> g.apply((CreateInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstancesRequest> {
        /**
         * <p>
         * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas,
         * for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * </p>
         * 
         * @param instanceNames
         *        The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
         *        commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas,
         * for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * </p>
         * 
         * @param instanceNames
         *        The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
         *        commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code>
         * (case sensitive). You can get a list of Availability Zones by using the <a
         * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
         * operation. Be sure to add the <code>include Availability Zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create your instance. Use the following format:
         *        <code>us-east-2a</code> (case sensitive). You can get a list of Availability Zones by using the <a
         *        href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
         *        regions</a> operation. Be sure to add the <code>include Availability Zones</code> parameter to your
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * (Deprecated) The name for your custom image.
         * </p>
         * <note>
         * <p>
         * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
         * </p>
         * </note>
         * 
         * @param customImageName
         *        (Deprecated) The name for your custom image.</p> <note>
         *        <p>
         *        In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder customImageName(String customImageName);

        /**
         * <p>
         * The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>
         * ). Use the <code>get blueprints</code> operation to return a list of available images (or <i>blueprints</i>).
         * </p>
         * <note>
         * <p>
         * Use active blueprints when creating new instances. Inactive blueprints are listed to support customers with
         * existing instances and are not necessarily available to create new instances. Blueprints are marked inactive
         * when they become outdated due to operating system updates or new application releases.
         * </p>
         * </note>
         * 
         * @param blueprintId
         *        The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         *        <code>app_lamp_7_0</code>). Use the <code>get blueprints</code> operation to return a list of
         *        available images (or <i>blueprints</i>).</p> <note>
         *        <p>
         *        Use active blueprints when creating new instances. Inactive blueprints are listed to support customers
         *        with existing instances and are not necessarily available to create new instances. Blueprints are
         *        marked inactive when they become outdated due to operating system updates or new application releases.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
         * pricing plan (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle of specification information for your virtual private server (or <i>instance</i>),
         *        including the pricing plan (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * A launch script you can create that configures a server with additional user data. For example, you might
         * want to run <code>apt-get -y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>. For a complete list, see the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
         * >Amazon Lightsail Developer Guide</a>.
         * </p>
         * </note>
         * 
         * @param userData
         *        A launch script you can create that configures a server with additional user data. For example, you
         *        might want to run <code>apt-get -y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>. For a complete list, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image"
         *        >Amazon Lightsail Developer Guide</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The name of your key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name of your key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values to add to the resource during create.</p>
         *        <p>
         *        Use the <code>TagResource</code> action to tag a resource after it's created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values to add to the resource during create.
         * </p>
         * <p>
         * Use the <code>TagResource</code> action to tag a resource after it's created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons to enable for the new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(Collection<AddOnRequest> addOns);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * 
         * @param addOns
         *        An array of objects representing the add-ons to enable for the new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOns(AddOnRequest... addOns);

        /**
         * <p>
         * An array of objects representing the add-ons to enable for the new instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AddOnRequest>.Builder} avoiding the need to
         * create one manually via {@link List<AddOnRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AddOnRequest>.Builder#build()} is called immediately and its
         * result is passed to {@link #addOns(List<AddOnRequest>)}.
         * 
         * @param addOns
         *        a consumer that will call methods on {@link List<AddOnRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addOns(List<AddOnRequest>)
         */
        Builder addOns(Consumer<AddOnRequest.Builder>... addOns);

        /**
         * <p>
         * The IP address type for the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the instance.
         * </p>
         * <p>
         * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         * </p>
         * <p>
         * The default value is <code>dualstack</code>.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the instance.</p>
         *        <p>
         *        The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for IPv4 and IPv6.
         *        </p>
         *        <p>
         *        The default value is <code>dualstack</code>.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> instanceNames = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private String customImageName;

        private String blueprintId;

        private String bundleId;

        private String userData;

        private String keyPairName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<AddOnRequest> addOns = DefaultSdkAutoConstructList.getInstance();

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            super(model);
            instanceNames(model.instanceNames);
            availabilityZone(model.availabilityZone);
            customImageName(model.customImageName);
            blueprintId(model.blueprintId);
            bundleId(model.bundleId);
            userData(model.userData);
            keyPairName(model.keyPairName);
            tags(model.tags);
            addOns(model.addOns);
            ipAddressType(model.ipAddressType);
        }

        public final Collection<String> getInstanceNames() {
            if (instanceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceNames;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        @Override
        @Transient
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Deprecated
        public final String getCustomImageName() {
            return customImageName;
        }

        @Deprecated
        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        @Override
        @Transient
        @Deprecated
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        @Override
        @Transient
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        @Transient
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        @Transient
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        @Transient
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AddOnRequest.Builder> getAddOns() {
            List<AddOnRequest.Builder> result = AddOnRequestListCopier.copyToBuilder(this.addOns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddOns(Collection<AddOnRequest.BuilderImpl> addOns) {
            this.addOns = AddOnRequestListCopier.copyFromBuilder(addOns);
        }

        @Override
        @Transient
        public final Builder addOns(Collection<AddOnRequest> addOns) {
            this.addOns = AddOnRequestListCopier.copy(addOns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(AddOnRequest... addOns) {
            addOns(Arrays.asList(addOns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addOns(Consumer<AddOnRequest.Builder>... addOns) {
            addOns(Stream.of(addOns).map(c -> AddOnRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        @Transient
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        @Transient
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
