/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an add-on that is enabled for an Amazon Lightsail resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddOn implements SdkPojo, Serializable, ToCopyableBuilder<AddOn.Builder, AddOn> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AddOn::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AddOn::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SNAPSHOT_TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotTimeOfDay").getter(getter(AddOn::snapshotTimeOfDay)).setter(setter(Builder::snapshotTimeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotTimeOfDay").build()).build();

    private static final SdkField<String> NEXT_SNAPSHOT_TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextSnapshotTimeOfDay").getter(getter(AddOn::nextSnapshotTimeOfDay))
            .setter(setter(Builder::nextSnapshotTimeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSnapshotTimeOfDay").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            SNAPSHOT_TIME_OF_DAY_FIELD, NEXT_SNAPSHOT_TIME_OF_DAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final String snapshotTimeOfDay;

    private final String nextSnapshotTimeOfDay;

    private AddOn(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.snapshotTimeOfDay = builder.snapshotTimeOfDay;
        this.nextSnapshotTimeOfDay = builder.nextSnapshotTimeOfDay;
    }

    /**
     * <p>
     * The name of the add-on.
     * </p>
     * 
     * @return The name of the add-on.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the add-on.
     * </p>
     * 
     * @return The status of the add-on.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The daily time when an automatic snapshot is created.
     * </p>
     * <p>
     * The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
     * </p>
     * <p>
     * The snapshot is automatically created between the time shown and up to 45 minutes after.
     * </p>
     * 
     * @return The daily time when an automatic snapshot is created.</p>
     *         <p>
     *         The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
     *         </p>
     *         <p>
     *         The snapshot is automatically created between the time shown and up to 45 minutes after.
     */
    public final String snapshotTimeOfDay() {
        return snapshotTimeOfDay;
    }

    /**
     * <p>
     * The next daily time an automatic snapshot will be created.
     * </p>
     * <p>
     * The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
     * </p>
     * <p>
     * The snapshot is automatically created between the time shown and up to 45 minutes after.
     * </p>
     * 
     * @return The next daily time an automatic snapshot will be created.</p>
     *         <p>
     *         The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
     *         </p>
     *         <p>
     *         The snapshot is automatically created between the time shown and up to 45 minutes after.
     */
    public final String nextSnapshotTimeOfDay() {
        return nextSnapshotTimeOfDay;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotTimeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(nextSnapshotTimeOfDay());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddOn)) {
            return false;
        }
        AddOn other = (AddOn) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(status(), other.status())
                && Objects.equals(snapshotTimeOfDay(), other.snapshotTimeOfDay())
                && Objects.equals(nextSnapshotTimeOfDay(), other.nextSnapshotTimeOfDay());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddOn").add("Name", name()).add("Status", status())
                .add("SnapshotTimeOfDay", snapshotTimeOfDay()).add("NextSnapshotTimeOfDay", nextSnapshotTimeOfDay()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "snapshotTimeOfDay":
            return Optional.ofNullable(clazz.cast(snapshotTimeOfDay()));
        case "nextSnapshotTimeOfDay":
            return Optional.ofNullable(clazz.cast(nextSnapshotTimeOfDay()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddOn, T> g) {
        return obj -> g.apply((AddOn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddOn> {
        /**
         * <p>
         * The name of the add-on.
         * </p>
         * 
         * @param name
         *        The name of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the add-on.
         * </p>
         * 
         * @param status
         *        The status of the add-on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The daily time when an automatic snapshot is created.
         * </p>
         * <p>
         * The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
         * </p>
         * <p>
         * The snapshot is automatically created between the time shown and up to 45 minutes after.
         * </p>
         * 
         * @param snapshotTimeOfDay
         *        The daily time when an automatic snapshot is created.</p>
         *        <p>
         *        The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
         *        </p>
         *        <p>
         *        The snapshot is automatically created between the time shown and up to 45 minutes after.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotTimeOfDay(String snapshotTimeOfDay);

        /**
         * <p>
         * The next daily time an automatic snapshot will be created.
         * </p>
         * <p>
         * The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
         * </p>
         * <p>
         * The snapshot is automatically created between the time shown and up to 45 minutes after.
         * </p>
         * 
         * @param nextSnapshotTimeOfDay
         *        The next daily time an automatic snapshot will be created.</p>
         *        <p>
         *        The time shown is in <code>HH:00</code> format, and in Coordinated Universal Time (UTC).
         *        </p>
         *        <p>
         *        The snapshot is automatically created between the time shown and up to 45 minutes after.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSnapshotTimeOfDay(String nextSnapshotTimeOfDay);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private String snapshotTimeOfDay;

        private String nextSnapshotTimeOfDay;

        private BuilderImpl() {
        }

        private BuilderImpl(AddOn model) {
            name(model.name);
            status(model.status);
            snapshotTimeOfDay(model.snapshotTimeOfDay);
            nextSnapshotTimeOfDay(model.nextSnapshotTimeOfDay);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSnapshotTimeOfDay() {
            return snapshotTimeOfDay;
        }

        public final void setSnapshotTimeOfDay(String snapshotTimeOfDay) {
            this.snapshotTimeOfDay = snapshotTimeOfDay;
        }

        @Override
        @Transient
        public final Builder snapshotTimeOfDay(String snapshotTimeOfDay) {
            this.snapshotTimeOfDay = snapshotTimeOfDay;
            return this;
        }

        public final String getNextSnapshotTimeOfDay() {
            return nextSnapshotTimeOfDay;
        }

        public final void setNextSnapshotTimeOfDay(String nextSnapshotTimeOfDay) {
            this.nextSnapshotTimeOfDay = nextSnapshotTimeOfDay;
        }

        @Override
        @Transient
        public final Builder nextSnapshotTimeOfDay(String nextSnapshotTimeOfDay) {
            this.nextSnapshotTimeOfDay = nextSnapshotTimeOfDay;
            return this;
        }

        @Override
        public AddOn build() {
            return new AddOn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
