/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabaseLogEventsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRelationalDatabaseLogEventsRequest.Builder, GetRelationalDatabaseLogEventsRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relationalDatabaseName").getter(getter(GetRelationalDatabaseLogEventsRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(GetRelationalDatabaseLogEventsRequest::logStreamName))
            .setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetRelationalDatabaseLogEventsRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetRelationalDatabaseLogEventsRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Boolean> START_FROM_HEAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("startFromHead").getter(getter(GetRelationalDatabaseLogEventsRequest::startFromHead))
            .setter(setter(Builder::startFromHead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startFromHead").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pageToken").getter(getter(GetRelationalDatabaseLogEventsRequest::pageToken))
            .setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, LOG_STREAM_NAME_FIELD, START_TIME_FIELD, END_TIME_FIELD, START_FROM_HEAD_FIELD,
            PAGE_TOKEN_FIELD));

    private final String relationalDatabaseName;

    private final String logStreamName;

    private final Instant startTime;

    private final Instant endTime;

    private final Boolean startFromHead;

    private final String pageToken;

    private GetRelationalDatabaseLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.logStreamName = builder.logStreamName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.startFromHead = builder.startFromHead;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * The name of your database for which to get log events.
     * </p>
     * 
     * @return The name of your database for which to get log events.
     */
    public final String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * <p>
     * Use the <code>get relational database log streams</code> operation to get a list of available log streams.
     * </p>
     * 
     * @return The name of the log stream.</p>
     *         <p>
     *         Use the <code>get relational database log streams</code> operation to get a list of available log
     *         streams.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The start of the time interval from which to get log events.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the start time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The start of the time interval from which to get log events.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the start time.
     *         </p>
     *         </li>
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time interval from which to get log events.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specified in Coordinated Universal Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in the Unix time format.
     * </p>
     * <p>
     * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     * <code>1538424000</code> as the end time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The end of the time interval from which to get log events.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specified in Coordinated Universal Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in the Unix time format.
     *         </p>
     *         <p>
     *         For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
     *         <code>1538424000</code> as the end time.
     *         </p>
     *         </li>
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log event
     * starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail of the
     * log.
     * </p>
     * <note>
     * <p>
     * For PostgreSQL, the default value of <code>false</code> is the only option available.
     * </p>
     * </note>
     * 
     * @return Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the
     *         log event starts from the head of the log. If <code>false</code> is specified, the log event starts from
     *         the tail of the log.</p> <note>
     *         <p>
     *         For PostgreSQL, the default value of <code>false</code> is the only option available.
     *         </p>
     */
    public final Boolean startFromHead() {
        return startFromHead;
    }

    /**
     * <p>
     * The token to advance to the next or previous page of results from your request.
     * </p>
     * <p>
     * To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your results are
     * paginated, the response will return a next forward token and/or next backward token that you can specify as the
     * page token in a subsequent request.
     * </p>
     * 
     * @return The token to advance to the next or previous page of results from your request.</p>
     *         <p>
     *         To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your
     *         results are paginated, the response will return a next forward token and/or next backward token that you
     *         can specify as the page token in a subsequent request.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(startFromHead());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseLogEventsRequest)) {
            return false;
        }
        GetRelationalDatabaseLogEventsRequest other = (GetRelationalDatabaseLogEventsRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(logStreamName(), other.logStreamName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(startFromHead(), other.startFromHead())
                && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRelationalDatabaseLogEventsRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("LogStreamName", logStreamName()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("StartFromHead", startFromHead()).add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "startFromHead":
            return Optional.ofNullable(clazz.cast(startFromHead()));
        case "pageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseLogEventsRequest, T> g) {
        return obj -> g.apply((GetRelationalDatabaseLogEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRelationalDatabaseLogEventsRequest> {
        /**
         * <p>
         * The name of your database for which to get log events.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your database for which to get log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * <p>
         * Use the <code>get relational database log streams</code> operation to get a list of available log streams.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.</p>
         *        <p>
         *        Use the <code>get relational database log streams</code> operation to get a list of available log
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The start of the time interval from which to get log events.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the start time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param startTime
         *        The start of the time interval from which to get log events.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the start time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time interval from which to get log events.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Specified in Coordinated Universal Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in the Unix time format.
         * </p>
         * <p>
         * For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         * <code>1538424000</code> as the end time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endTime
         *        The end of the time interval from which to get log events.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Specified in Coordinated Universal Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in the Unix time format.
         *        </p>
         *        <p>
         *        For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC, then you input
         *        <code>1538424000</code> as the end time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the log
         * event starts from the head of the log. If <code>false</code> is specified, the log event starts from the tail
         * of the log.
         * </p>
         * <note>
         * <p>
         * For PostgreSQL, the default value of <code>false</code> is the only option available.
         * </p>
         * </note>
         * 
         * @param startFromHead
         *        Parameter to specify if the log should start from head or tail. If <code>true</code> is specified, the
         *        log event starts from the head of the log. If <code>false</code> is specified, the log event starts
         *        from the tail of the log.</p> <note>
         *        <p>
         *        For PostgreSQL, the default value of <code>false</code> is the only option available.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFromHead(Boolean startFromHead);

        /**
         * <p>
         * The token to advance to the next or previous page of results from your request.
         * </p>
         * <p>
         * To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your results
         * are paginated, the response will return a next forward token and/or next backward token that you can specify
         * as the page token in a subsequent request.
         * </p>
         * 
         * @param pageToken
         *        The token to advance to the next or previous page of results from your request.</p>
         *        <p>
         *        To get a page token, perform an initial <code>GetRelationalDatabaseLogEvents</code> request. If your
         *        results are paginated, the response will return a next forward token and/or next backward token that
         *        you can specify as the page token in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String logStreamName;

        private Instant startTime;

        private Instant endTime;

        private Boolean startFromHead;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseLogEventsRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            logStreamName(model.logStreamName);
            startTime(model.startTime);
            endTime(model.endTime);
            startFromHead(model.startFromHead);
            pageToken(model.pageToken);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        @Override
        @Transient
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        @Transient
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getStartFromHead() {
            return startFromHead;
        }

        public final void setStartFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
        }

        @Override
        @Transient
        public final Builder startFromHead(Boolean startFromHead) {
            this.startFromHead = startFromHead;
            return this;
        }

        public final String getPageToken() {
            return pageToken;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        @Transient
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRelationalDatabaseLogEventsRequest build() {
            return new GetRelationalDatabaseLogEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
