/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketAccessKeysResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBucketAccessKeysResponse.Builder, GetBucketAccessKeysResponse> {
    private static final SdkField<List<AccessKey>> ACCESS_KEYS_FIELD = SdkField
            .<List<AccessKey>> builder(MarshallingType.LIST)
            .memberName("accessKeys")
            .getter(getter(GetBucketAccessKeysResponse::accessKeys))
            .setter(setter(Builder::accessKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEYS_FIELD));

    private final List<AccessKey> accessKeys;

    private GetBucketAccessKeysResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeys = builder.accessKeys;
    }

    /**
     * Returns true if the AccessKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccessKeys() {
        return accessKeys != null && !(accessKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that describes the access keys for the specified bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that describes the access keys for the specified bucket.
     */
    public final List<AccessKey> accessKeys() {
        return accessKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessKeys() ? accessKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAccessKeysResponse)) {
            return false;
        }
        GetBucketAccessKeysResponse other = (GetBucketAccessKeysResponse) obj;
        return hasAccessKeys() == other.hasAccessKeys() && Objects.equals(accessKeys(), other.accessKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBucketAccessKeysResponse").add("AccessKeys", hasAccessKeys() ? accessKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessKeys":
            return Optional.ofNullable(clazz.cast(accessKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketAccessKeysResponse, T> g) {
        return obj -> g.apply((GetBucketAccessKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBucketAccessKeysResponse> {
        /**
         * <p>
         * An object that describes the access keys for the specified bucket.
         * </p>
         * 
         * @param accessKeys
         *        An object that describes the access keys for the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeys(Collection<AccessKey> accessKeys);

        /**
         * <p>
         * An object that describes the access keys for the specified bucket.
         * </p>
         * 
         * @param accessKeys
         *        An object that describes the access keys for the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeys(AccessKey... accessKeys);

        /**
         * <p>
         * An object that describes the access keys for the specified bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessKey>.Builder} avoiding the need to
         * create one manually via {@link List<AccessKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #accessKeys(List<AccessKey>)}.
         * 
         * @param accessKeys
         *        a consumer that will call methods on {@link List<AccessKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessKeys(List<AccessKey>)
         */
        Builder accessKeys(Consumer<AccessKey.Builder>... accessKeys);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<AccessKey> accessKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAccessKeysResponse model) {
            super(model);
            accessKeys(model.accessKeys);
        }

        public final List<AccessKey.Builder> getAccessKeys() {
            List<AccessKey.Builder> result = AccessKeyListCopier.copyToBuilder(this.accessKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder accessKeys(Collection<AccessKey> accessKeys) {
            this.accessKeys = AccessKeyListCopier.copy(accessKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeys(AccessKey... accessKeys) {
            accessKeys(Arrays.asList(accessKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessKeys(Consumer<AccessKey.Builder>... accessKeys) {
            accessKeys(Stream.of(accessKeys).map(c -> AccessKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessKeys(Collection<AccessKey.BuilderImpl> accessKeys) {
            this.accessKeys = AccessKeyListCopier.copyFromBuilder(accessKeys);
        }

        @Override
        public GetBucketAccessKeysResponse build() {
            return new GetBucketAccessKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
